import { __ } from '@wordpress/i18n';
import {
	InnerBlocks,
	InspectorControls
} from '@wordpress/block-editor';
import {
	PanelBody,
	TextControl,
	SelectControl
} from '@wordpress/components';

import AnimatedBlockWrapper from '../components/animations/AnimatedBlockWrapper';
import AnimationControls from '../components/animations/AnimationControl';
import VisibilityControls from "../components/visibility/VisibilityControls";
import {getVisibilityClasses} from "../components/blockStyleUtils";

const Edit = ({ attributes, setAttributes }) => {
	const {
		ariaLabel = '',
		htmlTag = 'main',
		animationEntrance = '',
		animationDuration = '',
		animationDelay = ''
	} = attributes;

	return (
		<AnimatedBlockWrapper
			animationEntrance={animationEntrance}
			animationDuration={animationDuration}
			animationDelay={animationDelay}
			attributes={attributes}
			className={`lg-block lg-block__wrapper ${getVisibilityClasses(attributes)}`}
			htmlTag={htmlTag}
		>
			<InspectorControls>
				<PanelBody title={__('Layout', 'lead-gen')}>
					<SelectControl
						label={__('HTML Tag', 'lead-gen')}
						value={htmlTag}
						options={[
							{ label: 'main', value: 'main' },
							{ label: 'section', value: 'section' },
							{ label: 'header', value: 'header' },
							{ label: 'footer', value: 'footer' },
							{ label: 'article', value: 'article' },
							{ label: 'aside', value: 'aside' },
							{ label: 'div', value: 'div' },
						]}
						onChange={(val) => setAttributes({ htmlTag: val })}
					/>
					<TextControl
						label={__('Aria Label', 'lead-gen')}
						value={ariaLabel}
						onChange={(val) => setAttributes({ ariaLabel: val })}
						placeholder={__('Optional accessibility label', 'lead-gen')}
					/>
				</PanelBody>
				<VisibilityControls attributes={attributes} setAttributes={setAttributes} />
				<AnimationControls attributes={attributes} setAttributes={setAttributes} />
			</InspectorControls>
			<InnerBlocks />
		</AnimatedBlockWrapper>
	);
};

export default Edit;
