import { __ } from '@wordpress/i18n';
import { useState } from '@wordpress/element';
import {
	InspectorControls
} from '@wordpress/block-editor';
import AnimationControls from '../components/animations/AnimationControl';
import AnimatedBlockWrapper from '../components/animations/AnimatedBlockWrapper';
import TinyMCEEditor from '../components/TinyMCEEditor';
import {getBlockStyleClasses, getNativeWPClasses, getVisibilityClasses} from '../components/blockStyleUtils';
import VisibilityControls from "../components/visibility/VisibilityControls";

const Edit = ({ attributes, setAttributes, clientId }) => {
	const {
		content = '',
		animationEntrance = '',
		animationDuration = '',
		animationDelay = ''
	} = attributes;

	const [isEditing, setIsEditing] = useState(false);
	const editorId = `leadgen-editor-${clientId}`;

	const combinedClasses = [
		'lg-block',
		'lg-block__content',
		'body-font',
		getBlockStyleClasses(attributes),
		getNativeWPClasses(attributes),
		getVisibilityClasses(attributes),
	].filter(Boolean).join(' ');

	return (
		<AnimatedBlockWrapper
			animationEntrance={animationEntrance}
			animationDuration={animationDuration}
			animationDelay={animationDelay}
			attributes={attributes}
			className={combinedClasses}
		>
			<InspectorControls>
				<VisibilityControls attributes={attributes} setAttributes={setAttributes} />
				<AnimationControls attributes={attributes} setAttributes={setAttributes} />
			</InspectorControls>
			<div
				className={combinedClasses}
				dangerouslySetInnerHTML={{
					__html: content || '<p>Click to edit...</p>',
				}}
				onClick={() => setIsEditing(true)}
			/>
			{isEditing && (
				<TinyMCEEditor
					id={editorId}
					value={content}
					onChange={(val) => setAttributes({ content: val })}
					onClose={() => setIsEditing(false)}
				/>
			)}
		</AnimatedBlockWrapper >
	);
};

export default Edit;
