import { __ } from '@wordpress/i18n';
import { InspectorControls } from '@wordpress/block-editor';
import {
	PanelBody,
	__experimentalToggleGroupControl as ToggleGroupControl,
	__experimentalToggleGroupControlOption as ToggleGroupControlOption,
} from '@wordpress/components';
import AnimationControls from '../components/animations/AnimationControl';
import AnimatedBlockWrapper from '../components/animations/AnimatedBlockWrapper';
import VisibilityControls from "../components/visibility/VisibilityControls";
import {getVisibilityClasses} from "../components/blockStyleUtils";

const SPACE_OPTIONS = [
	{ label: __('XS', 'lead-gen'), value: 'xs' },
	{ label: __('SM', 'lead-gen'), value: 'sm' },
	{ label: __('MD', 'lead-gen'), value: 'md' },
	{ label: __('LG', 'lead-gen'), value: 'lg' },
	{ label: __('XL', 'lead-gen'), value: 'xl' }
];

const Edit = ({ attributes, setAttributes }) => {
	const {
		space,
		animationEntrance,
		animationDuration,
		animationDelay
	} = attributes;

	return (
		<AnimatedBlockWrapper
			animationEntrance={animationEntrance}
			animationDuration={animationDuration}
			animationDelay={animationDelay}
			attributes={attributes}
			className={`lg-block lg-block__spacer spacer-${space} ${getVisibilityClasses(attributes)}`}
		>
			<InspectorControls>
				<PanelBody title={__('Spacer Settings', 'lead-gen')} initialOpen={true}>
					<ToggleGroupControl
						label={__('Spacer Size', 'lead-gen')}
						value={space}
						onChange={(val) => setAttributes({ space: val })}
						isBlock
					>
						{SPACE_OPTIONS.map((option) => (
							<ToggleGroupControlOption
								key={option.value}
								value={option.value}
								label={option.label}
							/>
						))}
					</ToggleGroupControl>
				</PanelBody>
				<VisibilityControls attributes={attributes} setAttributes={setAttributes} />
				<AnimationControls attributes={attributes} setAttributes={setAttributes}/>
			</InspectorControls>
		</AnimatedBlockWrapper>
	);
};

export default Edit;
