import { __ } from '@wordpress/i18n';
import { InspectorControls } from '@wordpress/block-editor';
import { PanelBody, ToggleControl } from '@wordpress/components';
import ServerSideRender from '@wordpress/server-side-render';
import AnimationControls from '../components/animations/AnimationControl';
import AnimatedBlockWrapper from '../components/animations/AnimatedBlockWrapper';
import VisibilityControls from "../components/visibility/VisibilityControls";
import {getVisibilityClasses} from "../components/blockStyleUtils";

const Edit = ({ attributes, setAttributes, name }) => {
	const {
		stacked,
		animationEntrance,
		animationDuration,
		animationDelay,
	} = attributes;

	return (
		<AnimatedBlockWrapper
			animationEntrance={animationEntrance}
			animationDuration={animationDuration}
			animationDelay={animationDelay}
			attributes={attributes}
			className={`lg-block lg-block__social-icons ${getVisibilityClasses(attributes)}`}
		>
			<InspectorControls>
				<PanelBody title={__('Social Icons Settings', 'lead-gen')} initialOpen={true}>
					<ToggleControl
						label={__('Stacked Layout', 'lead-gen')}
						help={__('Determines if there is a background behind the icons.', 'lead-gen')}
						checked={stacked}
						onChange={() => setAttributes({ stacked: !stacked })}
					/>
				</PanelBody>
				<VisibilityControls attributes={attributes} setAttributes={setAttributes} />
				<AnimationControls attributes={attributes} setAttributes={setAttributes} />
			</InspectorControls>

			<ServerSideRender
				block={name}
				attributes={attributes}
			/>
		</AnimatedBlockWrapper>
	);
};

export default Edit;
