import { __ } from '@wordpress/i18n';
import {
	InspectorControls
} from '@wordpress/block-editor';
import {
	PanelBody,
	ToggleControl
} from '@wordpress/components';
import { useSelect } from '@wordpress/data';
import AnimationControls from '../components/animations/AnimationControl';
import AnimatedBlockWrapper from '../components/animations/AnimatedBlockWrapper';
import PlaceholderDimensionControls from '../components/PlaceholderDimension/PlaceholderDimensionControls';
import VisibilityControls from "../components/visibility/VisibilityControls";
import {getVisibilityClasses} from "../components/blockStyleUtils";

const Edit = ({ attributes, setAttributes }) => {
	const {
		useAlternate,
		link,
		placeholderDimensions,
		animationEntrance,
		animationDuration,
		animationDelay
	} = attributes;

	const logoId = (typeof siteLogo !== 'undefined' && siteLogo.id) || null;
	const logoImage = useSelect((select) => logoId ? select('core').getMedia(logoId) : null, [logoId]);
	const alternateLogoId = (typeof siteLogo !== 'undefined' && siteLogo.alternate_id) || null;
	const alternateLogoImage = useSelect((select) => alternateLogoId ? select('core').getMedia(alternateLogoId) : null, [alternateLogoId]);

	const previewImage = useAlternate && alternateLogoImage ? alternateLogoImage : logoImage;

	const placeholderUrl =
		placeholderDimensions?.width && placeholderDimensions?.height
			? `https://placehold.co/${placeholderDimensions.width}x${placeholderDimensions.height}`
			: null;

	return (
		<AnimatedBlockWrapper
			animationEntrance={animationEntrance}
			animationDuration={animationDuration}
			animationDelay={animationDelay}
			attributes={attributes}
			className={`lg-block lg-block__site-logo ${getVisibilityClasses(attributes)}`}
		>
			<InspectorControls>
				<PanelBody title={__('Logo Settings', 'lead-gen')} initialOpen={true}>
					<ToggleControl
						label={__('Use Alternate Logo', 'lead-gen')}
						checked={useAlternate}
						onChange={(val) => setAttributes({ useAlternate: val })}
					/>
					<ToggleControl
						label={__('Link to Homepage', 'lead-gen')}
						checked={link}
						onChange={(val) => setAttributes({ link: val })}
					/>
				</PanelBody>

				<PlaceholderDimensionControls attributes={attributes} setAttributes={setAttributes} />
				<VisibilityControls attributes={attributes} setAttributes={setAttributes} />
				<AnimationControls attributes={attributes} setAttributes={setAttributes} />
			</InspectorControls>

			<div className="site-logo__preview">
				{link ? (
					<a href="/" className="site-logo__link" onClick={(e) => {
						e.preventDefault();
						return false;
					}}>
						{previewImage?.source_url ? (
							<img src={previewImage.source_url} alt={previewImage.alt_text || 'Site Logo'} className="site-logo__img" />
						) : placeholderUrl ? (
							<img src={placeholderUrl} alt="Placeholder - Please Replace Me" className="site-logo__img" />
						) : (
							<span className="site-logo__text">{__('Site Title', 'lead-gen')}</span>
						)}
					</a>
				) : previewImage?.source_url ? (
					<img src={previewImage.source_url} alt={previewImage.alt_text || 'Site Logo'} className="site-logo__img" />
				) : placeholderUrl ? (
					<img src={placeholderUrl} alt="Placeholder - Please Replace Me" className="site-logo__img" />
				) : (
					<span className="site-logo__text">{__('Site Title', 'lead-gen')}</span>
				)}
			</div>
		</AnimatedBlockWrapper>
	);
};

export default Edit;
