<?php
/**
 * Section Block
 *
 * @package StrategyBlocks
 *
 * @param array  $attributes  The block's attributes.
 * @param string $content     The block's inner HTML (empty).
 * @param object $block       The block object (contains anchor, etc.).
 */

use StrategyBlocks\Utility;

$id = ! empty( $attributes['anchor'] ) ? $attributes['anchor'] : '';
// phpcs:ignore WordPress.NamingConventions.ValidVariableName.UsedPropertyNotSnakeCase
$block_id = isset( $block->clientId ) ? substr( $block->clientId, 0, 8 ) : substr( uniqid(), 0, 8 );

$class_name = "lg-block lg-block__section section lg-block-$block_id";
$class_name .= Utility\get_block_style_classes( $attributes );
$class_name .= Utility\get_native_wp_classes( $attributes );
$class_name .= Utility\get_visibility_classes( $attributes );
if ( ! empty( $attributes['verticalAlign'] ) ) {
	$class_name .= ' ' . $attributes['verticalAlign'] . '-xs';
}

$html_tag = ! empty( $attributes['htmlTag'] ) ? $attributes['htmlTag'] : 'section';
$animations = Utility\get_animation_data( $attributes );

$container_class_name = Utility\get_section_container_classes( $attributes );

do_action( 'lg_block_section_before' );

$background_image = isset( $attributes['backgroundImage'] ) ? $attributes['backgroundImage'] : null;
$background_video = isset( $attributes['backgroundVideo'] ) ? $attributes['backgroundVideo'] : null;
$background_overlay = isset( $attributes['backgroundOverlay'] ) ? $attributes['backgroundOverlay'] : false;
$background_overlay_color = isset( $attributes['backgroundOverlayColor'] ) ? $attributes['backgroundOverlayColor'] : '';
$background_position = isset( $attributes['backgroundPosition'] ) ? Utility\normalize_background_position( $attributes['backgroundPosition'], true ) : [
	'x' => 0.5,
	'y' => 0.5,
];
$placeholder_dims = isset( $attributes['placeholderDimensions'] ) ? $attributes['placeholderDimensions'] : [
	'width' => '',
	'height' => '',
];

if ( $placeholder_dims && count( array_filter( $placeholder_dims ) ) === 2 ) {
	$placeholder_dims = $placeholder_dims['width'] . 'x' . $placeholder_dims['height'];
} else {
	$placeholder_dims = null;
}

$shape_divider_top = isset( $attributes['shapeDividerTop'] ) ? $attributes['shapeDividerTop'] : '';
$shape_divider_bottom = isset( $attributes['shapeDividerBottom'] ) ? $attributes['shapeDividerBottom'] : '';

$aria_label = isset( $attributes['ariaLabel'] ) ? $attributes['ariaLabel'] : '';
$is_top_level = empty( $block->context );
global $images_loaded;
global $eager_images;

if ( ! isset( $images_loaded ) ) {
	$images_loaded = 0;
}
if ( ! isset( $eager_images ) ) {
	$eager_images = 3;
}

if ( $background_overlay && $background_overlay_color ) { ?>
<style>
	.<?php echo esc_html( "lg-block-$block_id" ); ?> .section__overlay-color {
		background-color: <?php echo esc_html( $background_overlay_color ); ?>;
	}
</style>
<?php } ?>

<?php do_action( 'lg_block_section_before' ); ?>

<<?php echo esc_attr( $html_tag ); ?> <?php echo ! empty( $id ) ? 'id="' . esc_attr( $id ) . '" ' : null; ?> class="<?php echo esc_attr( $class_name ); ?>" <?php echo ! empty( $aria_label ) ? 'aria-label="' . esc_attr( $aria_label ) . '" ' : null; ?> <?php echo ! empty( $animations ) ? 'data-animation="' . esc_attr( $animations ) . '" ' : null; ?> >
<?php
if ( $background_image || $placeholder_dims || $background_video ) {
	$images_loaded++;
	?>
	<div class="section__overlay">
		<?php
		if ( $background_image ) {
			echo wp_get_attachment_image(
				$background_image,
				'full',
				false,
				[
					'class' => 'section__overlay-img',
					'style' => 'object-position: ' . esc_attr( $background_position ),
					'loading' => $images_loaded <= $eager_images ? 'eager' : 'lazy',
				]
			);
		} else if ( $placeholder_dims ) {
			?>
			<img class="section__overlay-img" src="<?php echo esc_url( 'https://placehold.co/' . $placeholder_dims ); ?>" alt="Placeholder - Please Replace Me" title="Placeholder - Please Replace Me" loading="<?php echo $images_loaded <= $eager_images ? 'eager' : 'lazy'; ?>" />
			<?php
		}
		if ( $background_video ) {
			$video_url = wp_get_attachment_url( $background_video );
			$image_url = $background_image ? wp_get_attachment_url( $background_image ) : false;
			$fallback_url = $image_url ? $image_url : false;

			if ( $video_url ) {
				?>
				<video class="section__overlay-video" autoplay="" muted="" loop="" plays-inline="" preload="" <?php if ( $fallback_url ) { echo 'poster="' . esc_attr( $fallback_url ) . '"'; } ?> >
					<source src="<?php echo esc_url( $video_url ); ?>" type="video/mp4">
					Your browser does not support the video tag.
				</video>
				<?php
			}
		}

		if ( $background_overlay ) {
			?>
			<div class="section__overlay-color" aria-hidden="true"></div>
		<?php } ?>
	</div>
<?php } ?>
<?php do_action( 'lg_block_section_container_before' ); ?>
<?php
if ( $is_top_level ) :
	?>
	<div class="<?php echo esc_attr( $container_class_name ); ?>">
		<?php echo $content; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
	</div>
<?php else : ?>
	<?php echo $content; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
<?php endif; ?>
<?php do_action( 'lg_block_section_container_after' ); ?>
<?php
if ( isset( $shape_divider_top['type'] ) && 'none' !== $shape_divider_top['type'] ) :
	$shape_divider_top['position'] = 'top';
	Utility\get_plugin_template_part( 'partials/shape', 'dividers', apply_filters( 'lg_block_section_shape_divider_args', $shape_divider_top ) );
endif;
?>
<?php
if ( isset( $shape_divider_bottom['type'] ) && 'none' !== $shape_divider_bottom['type'] ) :
	$shape_divider_bottom['position'] = 'bottom';
	Utility\get_plugin_template_part( 'partials/shape', 'dividers', apply_filters( 'lg_block_section_shape_divider_args', $shape_divider_bottom ) );
endif;
?>
</<?php echo esc_attr( $html_tag ); ?>>

<?php do_action( 'lg_block_section_after' ); ?>
