import { __ } from '@wordpress/i18n';
import {
	BaseControl,
	PanelBody,
	ToggleControl,
	__experimentalToggleGroupControl as ToggleGroupControl,
	__experimentalToggleGroupControlOption as ToggleGroupControlOption,
} from '@wordpress/components';
import {
	InspectorControls,
	useBlockProps,
} from '@wordpress/block-editor';
import ServerSideRender from '@wordpress/server-side-render';

import AnimationControls from '../components/animations/AnimationControl';
import AnimatedBlockWrapper from '../components/animations/AnimatedBlockWrapper';
import { ReorderableMultiSelect } from '../components/ReorderableMultiSelect';
import VisibilityControls from "../components/visibility/VisibilityControls";
import {getVisibilityClasses} from "../components/blockStyleUtils";

const ELEMENT_OPTIONS = [
	{ key: 'title', label: __('Title', 'lead-gen') },
	{ key: 'categories', label: __('Categories', 'lead-gen') },
	{ key: 'meta', label: __('Meta', 'lead-gen') },
	{ key: 'content', label: __('Content', 'lead-gen') },
	{ key: 'image', label: __('Image', 'lead-gen') },
];

const META_ITEMS_OPTIONS = [
	{ key: 'title', label: __('Title', 'lead-gen') },
	{ key: 'author', label: __('Author', 'lead-gen') },
	{ key: 'date', label: __('Date', 'lead-gen') },
	{ key: 'date_time', label: __('Date/Time', 'lead-gen') },
	{ key: 'reading_time', label: __('Reading Time', 'lead-gen') },
];

const Edit = ({ name, attributes, setAttributes }) => {
	const {
		elements,
		metaItems,
		navigation,
		socialShare,
		titleHtmlTag,
		animationEntrance,
		animationDuration,
		animationDelay
	} = attributes;

	const blockProps = useBlockProps();

	return (
		<AnimatedBlockWrapper
			animationEntrance={animationEntrance}
			animationDuration={animationDuration}
			animationDelay={animationDelay}
			attributes={attributes}
			{...blockProps}
			className={`lg-block lg-block__post post ${getVisibilityClasses(attributes)}`}
		>
			<InspectorControls>
				<PanelBody title={__('Display Settings', 'lead-gen')}>
					<BaseControl label="Elements to Show">
						<ReorderableMultiSelect
							options={ELEMENT_OPTIONS}
							selectedKeys={elements}
							onChangeSelected={(next) => setAttributes({ elements: next })}
						/>
					</BaseControl>
					{elements.includes('title') ? (
						<ToggleGroupControl
							label={__('Title HTML Tag', 'lead-gen')}
							value={titleHtmlTag}
							isBlock
							__nextHasNoMarginBottom
							__next40pxDefaultSize
							onChange={(val) => setAttributes({ titleHtmlTag: val })}
						>
							<ToggleGroupControlOption value="h1" label="H1" />
							<ToggleGroupControlOption value="h2" label="H2" />
							<ToggleGroupControlOption value="h3" label="H3" />
							<ToggleGroupControlOption value="h4" label="H4" />
							<ToggleGroupControlOption value="h5" label="H5" />
							<ToggleGroupControlOption value="h6" label="H6" />
						</ToggleGroupControl>
					) : null}
					{elements.includes('meta') ? (
						<BaseControl label="Order of Meta Elements">
							<ReorderableMultiSelect
								options={META_ITEMS_OPTIONS}
								selectedKeys={metaItems}
								onChangeSelected={(next) => setAttributes({ metaItems: next })}
							/>
						</BaseControl>
					) : null}
					<BaseControl label="Footer Settings">
						<ToggleControl
							label={__('Show Navigation', 'lead-gen')}
							checked={navigation}
							onChange={(val) => setAttributes({ navigation: val })}
						/>
						<ToggleControl
							label={__('Show Social Share', 'lead-gen')}
							checked={socialShare}
							onChange={(val) => setAttributes({ socialShare: val })}
						/>
					</BaseControl>
				</PanelBody>
				<VisibilityControls attributes={attributes} setAttributes={setAttributes} />
				<AnimationControls attributes={attributes} setAttributes={setAttributes} />
			</InspectorControls>
			<ServerSideRender block={name} attributes={attributes} />
		</AnimatedBlockWrapper>
	);
};

export default Edit;
