document.addEventListener("DOMContentLoaded", () => {
	const header = document.getElementsByClassName('lg-header')[0];
	// Close all submenus
	const closeAllSubMenus = () => {
		document.querySelectorAll(".navigation__item-has-children").forEach((el) => {
			el.classList.remove("is-open");
			el.setAttribute("aria-expanded", "false");
		});
	};

	// Close all submenus except one
	const closeAllSubMenusExcept = (exception) => {
		document.querySelectorAll(".navigation__item-has-children").forEach((el) => {
			if (!exception.contains(el)) {
				el.classList.remove("is-open");
				el.setAttribute("aria-expanded", "false");
			}
		});
	};

	// Focus / hover open
	document.querySelectorAll(".navigation__menu [aria-haspopup='true']").forEach((el) => {
		el.addEventListener("focus", () => el.setAttribute("aria-expanded", "true"));
		el.addEventListener("mouseenter", () => el.setAttribute("aria-expanded", "true"));
	});

	// Blur / mouseleave close (only if not open)
	document.querySelectorAll(".navigation__menu [aria-haspopup='true']").forEach((el) => {
		el.addEventListener("blur", () => {
			if (!el.closest(".is-open")) el.setAttribute("aria-expanded", "false");
		});
		el.addEventListener("mouseleave", () => {
			if (!el.closest(".is-open")) el.setAttribute("aria-expanded", "false");
		});
	});

	// Collapse mobile menu
	const collapseMenu = (target) => {
		target.classList.remove("active");
		target.addEventListener(
			"transitionend",
			() => {
				target.style.top = "unset";
				target.classList.remove("show");
			},
			{ once: true }
		);
	};

	// Mobile burger toggle
	document.querySelectorAll('.navigation__burger').forEach((burger) => {
		burger.addEventListener('click', (e) => {
			const el = e.currentTarget;
			const { target } = el.dataset;
			const targetEl = document.getElementById(target);

			if (!targetEl) return;

			let headerHeight = header?.offsetHeight || 0;

			el.classList.toggle('active');

			if (!targetEl.classList.contains('active')) {
				const wpadminbar = document.getElementById('wpadminbar');
				if (wpadminbar) {
					headerHeight += wpadminbar.offsetHeight;
				}

				Object.assign(targetEl.style, {
					top: `${headerHeight}px`,
				});

				targetEl.classList.add('show');

				setTimeout(() => {
					targetEl.classList.add('active');
				}, 20);
			} else {
				collapseMenu(targetEl);
			}
		});
	});

	// Responsive dropdown toggles
	document.querySelectorAll(
		".navigation__menu .navigation__item-has-children > .navigation__dropdown-toggle," +
		".navigation__menu .navigation__item-has-children > button.navigation__link"
	).forEach((btn) => {
		btn.addEventListener("click", (e) => {
			e.preventDefault();
			const parent = btn.closest(".navigation__item-has-children");
			const isOpen = parent.classList.contains("is-open");

			closeAllSubMenusExcept(parent);

			if (isOpen) {
				parent.classList.remove("is-open");
				parent.setAttribute("aria-expanded", "false");
			} else {
				parent.classList.add("is-open");
				parent.setAttribute("aria-expanded", "true");
			}
		});
	});

	// Close menus when clicking outside
	document.addEventListener("click", (e) => {
		if (!e.target.closest(".navigation__menu")) {
			closeAllSubMenus();
		}
	});

	// Reset on resize
	window.addEventListener("resize", () => {
		if (window.innerWidth > 1009) {
			document
				.querySelectorAll(".mega-menu .navigation__dropdown, .standard .navigation__dropdown")
				.forEach((el) => {
					el.style = ""
				});
			closeAllSubMenus();
		}
	});
});
