<?php
/**
 * Navigation Block
 *
 * @package StrategyBlocks
 *
 * @param array  $attributes  The block's attributes.
 * @param string $content     The block's inner content (unused here).
 * @param object $block       The block object (contains anchor, etc.).
 */

use StrategyBlocks\Aria_Walker_Nav_Menu;
use StrategyBlocks\Utility;
use StrategyBlocks\FontAwesomeSVG;

$id            = $attributes['anchor'] ?? '';
$menu          = $attributes['menu'] ?? '';
$show_search   = $attributes['showSearch'] ?? false;
$dropdowns     = $attributes['dropdowns'] ?? 'arrows';
$class_name    = implode(
	' ',
	array_filter(
		[
			'lg-block',
			'lg-block__navigation',
			Utility\get_block_style_classes( $attributes ),
			Utility\get_native_wp_classes( $attributes ),
			Utility\get_visibility_classes( $attributes ),
		]
	)
);
$animations    = Utility\get_animation_data( $attributes );
$menu_id       = 'navigation-' . $menu . '-' . uniqid();
$font_awesome  = new FontAwesomeSVG( STRATEGY_BLOCKS_DIST_PATH . 'font-awesome/svgs' );
$menu_output   = '';
$menu_name     = '';

if ( $menu ) {
	$menu_object = wp_get_nav_menu_object( $menu );
	if ( $menu_object ) {
		$menu_name = $menu_object->name;
		$menu_id   = 'navigation-' . $menu . '-' . uniqid();

		$menu_output = wp_nav_menu(
			[
				'menu'           => $menu,
				'container'      => false,
				'menu_class'     => 'navigation__menu',
				'menu_id'        => $menu_id,
				'walker'         => new Aria_Walker_Nav_Menu( $font_awesome, $dropdowns ),
				'items_wrap'     => '<ul id="%1$s" class="%2$s" role="menubar" aria-label="' . esc_attr( $menu_name ) . '" data-dropdowns="' . esc_attr( $dropdowns ) . '">%3$s</ul>',
				'theme_location' => '__fake', // fake value, to prevent display of 1st real menu
				'fallback_cb'    => false,
				'echo'           => 0,
			]
		);
	}
}

do_action( 'lg_block_navigation_before' ); ?>

<div <?php echo $id ? 'id="' . esc_attr( $id ) . '"' : ''; ?>
	class="<?php echo esc_attr( $class_name ); ?>"
	<?php echo $animations ? 'data-animation="' . esc_attr( $animations ) . '"' : ''; ?>
>
	<?php if ( $menu_output ) : ?>
		<nav class="navigation" aria-label="<?php echo esc_attr( $menu_name ); ?>">
			<button
				class="navigation__burger"
				aria-label="Open <?php echo esc_attr( $menu_name ); ?> Mobile Menu"
				aria-expanded="false"
				data-target="<?php echo esc_attr( $menu_id ); ?>"
			>
				<span aria-hidden="true"></span>
				<span aria-hidden="true"></span>
				<span aria-hidden="true"></span>
			</button>
			<?php echo $menu_output; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
			<?php if ( $show_search && false ) : // We don't support search yet, so this is on purpose ?>
				<div class="navigation__search">
					<?php get_search_form(); ?>
				</div>
			<?php endif; ?>
		</nav>
	<?php endif; ?>
</div>

<?php do_action( 'lg_block_navigation_after' ); ?>
