import { __ } from '@wordpress/i18n';
import {
	PanelBody,
	TextControl,
	SelectControl,
	ToolbarGroup,
	ToolbarButton,
	__experimentalToggleGroupControl as ToggleGroupControl,
	__experimentalToggleGroupControlOption as ToggleGroupControlOption,
} from '@wordpress/components';
import {
	InspectorControls,
	RichText,
	BlockControls
} from '@wordpress/block-editor';
import { useSelect } from '@wordpress/data';
import { store as blockEditorStore } from '@wordpress/block-editor';
import AnimationControls from '../components/animations/AnimationControl';
import AnimatedBlockWrapper from '../components/animations/AnimatedBlockWrapper';
import VisibilityControls from "../components/visibility/VisibilityControls";
import {getVisibilityClasses} from "../components/blockStyleUtils";

const Edit = ({ attributes, setAttributes, clientId  }) => {
	const {
		dividerText,
		dividerStyle,
		dividerWidth,
		dividerThickness,
		dividerAlignment,
		dividerTextPosition,
		htmlTag,
		animationEntrance,
		animationDuration,
		animationDelay
	} = attributes;

	const dividerClassName = [
		'divider',
		dividerText ? `text-divider-${dividerStyle}` : `divider-${dividerStyle}`,
		dividerText ? `text-divider-${dividerThickness}` : `divider-${dividerThickness}`,
		dividerText ? `text-divider-${dividerWidth}` : `divider-${dividerWidth}`,
		dividerAlignment,
		dividerText && `text-divider-${dividerTextPosition}`
	].filter(Boolean).join(' ');

	const isSelected = useSelect(
		(select) => select(blockEditorStore).getSelectedBlockClientId() === clientId,
		[clientId]
	);

	return (
		<AnimatedBlockWrapper
			animationEntrance={animationEntrance}
			animationDuration={animationDuration}
			animationDelay={animationDelay}
			attributes={attributes}
			className={`lg-block lg-block__divider ${getVisibilityClasses(attributes)}`}
		>
			<BlockControls>
				<ToolbarGroup label="Text Position">
					<ToolbarButton
						icon="editor-alignleft"
						label={__('Left', 'lead-gen')}
						isPressed={dividerTextPosition === 'left'}
						onClick={() => setAttributes({dividerTextPosition: 'left'})}
					/>
					<ToolbarButton
						icon="editor-aligncenter"
						label={__('Center', 'lead-gen')}
						isPressed={dividerTextPosition === 'center'}
						onClick={() => setAttributes({dividerTextPosition: 'center'})}
					/>
					<ToolbarButton
						icon="editor-alignright"
						label={__('Right', 'lead-gen')}
						isPressed={dividerTextPosition === 'right'}
						onClick={() => setAttributes({dividerTextPosition: 'right'})}
					/>
				</ToolbarGroup>
			</BlockControls>

			<InspectorControls>
				<PanelBody title={__('Divider Settings', 'lead-gen')} initialOpen={true}>
					<TextControl
						label={__('Divider Text', 'lead-gen')}
						value={dividerText}
						onChange={(val) => setAttributes({dividerText: val})}
					/>

					<SelectControl
						label={__('Divider Style', 'lead-gen')}
						value={dividerStyle}
						options={[
							{label: 'Solid', value: 'solid'},
							{label: 'Double', value: 'solid'},
							{label: 'Dashed', value: 'dashed'},
							{label: 'Dotted', value: 'dotted'},
							{label: 'Ridge', value: 'ridge'},
							{label: 'Groove', value: 'groove'},
							{label: 'Inset', value: 'inset'},
							{label: 'Outset', value: 'outset'},
							{label: 'None', value: 'none'},
						]}
						onChange={(val) => setAttributes({dividerStyle: val})}
					/>

					<ToggleGroupControl
						label={__('Divider Width', 'lead-gen')}
						value={dividerWidth}
						onChange={(val) => setAttributes({dividerWidth: val})}
						isBlock
					>
						<ToggleGroupControlOption value="fullwidth" label="Full"/>
						<ToggleGroupControlOption value="three-fourth" label="3/4"/>
						<ToggleGroupControlOption value="half" label="1/2"/>
						<ToggleGroupControlOption value="one-fourth" label="1/4"/>
					</ToggleGroupControl>

					<ToggleGroupControl
						label={__('Thickness', 'lead-gen')}
						value={dividerThickness}
						onChange={(val) => setAttributes({dividerThickness: val})}
						isBlock
					>
						<ToggleGroupControlOption value="thin" label="Thin"/>
						<ToggleGroupControlOption value="medium" label="Medium"/>
						<ToggleGroupControlOption value="thick" label="Thick"/>
					</ToggleGroupControl>

					<ToggleGroupControl
						label={__('Alignment', 'lead-gen')}
						value={dividerAlignment}
						onChange={(val) => setAttributes({dividerAlignment: val})}
						isBlock
					>
						<ToggleGroupControlOption value="left" label="Left"/>
						<ToggleGroupControlOption value="center" label="Center"/>
						<ToggleGroupControlOption value="right" label="Right"/>
					</ToggleGroupControl>

					<ToggleGroupControl
						label={__('Text Position', 'lead-gen')}
						value={dividerTextPosition}
						onChange={(val) => setAttributes({dividerTextPosition: val})}
						isBlock
					>
						<ToggleGroupControlOption value="left" label="Left"/>
						<ToggleGroupControlOption value="center" label="Center"/>
						<ToggleGroupControlOption value="right" label="Right"/>
					</ToggleGroupControl>

					<SelectControl
						label={__('HTML Tag', 'lead-gen')}
						value={htmlTag}
						options={[
							{label: 'Span', value: 'span'},
							{label: 'Div', value: 'div'},
							{label: 'P', value: 'p'},
							{label: 'H1', value: 'h1'},
							{label: 'H2', value: 'h2'},
							{label: 'H3', value: 'h3'},
							{label: 'H4', value: 'h4'},
							{label: 'H5', value: 'h5'},
							{label: 'H6', value: 'h6'},
						]}
						onChange={(val) => setAttributes({htmlTag: val})}
					/>
				</PanelBody>
				<VisibilityControls attributes={attributes} setAttributes={setAttributes} />
				<AnimationControls attributes={attributes} setAttributes={setAttributes}/>
			</InspectorControls>

			<span className={dividerClassName}>
				{isSelected ? (
					<RichText
						tagName={htmlTag}
						value={dividerText}
						onChange={(val) => setAttributes({ dividerText: val })}
						placeholder={__('Divider text (optional)...', 'lead-gen')}
						className="body-font"
					/>
				) : (
					dividerText && (
						<RichText.Content
							tagName={htmlTag}
							value={dividerText}
							className="body-font"
						/>
					)
				)}
			</span>
		</AnimatedBlockWrapper>
	);
};

export default Edit;
