import { CountUp } from 'countup.js';

document.addEventListener('DOMContentLoaded', () => {
	const counters = document.querySelectorAll('.counter__number');
	counters.forEach((el) => {
		const options = {
			startVal: parseFloat(el.dataset.start),
			duration: parseFloat(el.dataset.duration) / 1000,
			useGrouping: el.dataset.useGrouping === 'true',
			separator: el.dataset.separator,
			enableScrollSpy: true,
		};
		const counter = new CountUp(el, parseFloat(el.dataset.end), options);
		if (!counter.error) counter.start();
	});
});
