import { useSelect } from '@wordpress/data';
import { __ } from '@wordpress/i18n';
import { BaseControl } from '@wordpress/components';
import {
	InspectorControls
} from '@wordpress/block-editor';
import {
	PanelBody,
	ToggleControl,
	TextControl
} from '@wordpress/components';
import { Link } from '@10up/block-components';

import AnimationControls from '../components/animations/AnimationControl';
import AnimatedBlockWrapper from '../components/animations/AnimatedBlockWrapper';
import VisibilityControls from "../components/visibility/VisibilityControls";
import {getVisibilityClasses} from "../components/blockStyleUtils";

const Edit = ({ attributes, setAttributes }) => {
	const siteName = useSelect(() => {
		const site = wp.data.select('core').getEntityRecord('root', 'site');
		return site?.title || 'Strategy Platform';
	}, []);

	const {
		showBacklink = false,
		backlink = {},
		animationEntrance,
		animationDuration,
		animationDelay
	} = attributes;

	const handleTextChange = value => setAttributes({
		backlink: {
			...backlink,
			title: value ?? backlink.title,
		},
	});
	const handleLinkChange = value => setAttributes({
		backlink: {
			...backlink,
			url: value?.url,
			title: value?.title ?? backlink.title,
			opensInNewTab: value?.opensInNewTab,
		},
	});
	const handleLinkRemove = () => setAttributes({
		backlink: {
			...backlink,
			url: null,
		},
	});

	return (

		<AnimatedBlockWrapper
			animationEntrance={animationEntrance}
			animationDuration={animationDuration}
			animationDelay={animationDelay}
			attributes={attributes}
			className={`lg-block lg-block__copyright ${getVisibilityClasses(attributes)}`}
		>
			<InspectorControls>
				<PanelBody title={__('Copyright Settings', 'lead-gen')} initialOpen={true}>
					<ToggleControl
						label={__('Show Backlink', 'lead-gen')}
						checked={!!showBacklink}
						onChange={(val) => setAttributes({ showBacklink: val })}
					/>

					{showBacklink && (
						<div style={{ marginTop: '1rem' }}>
							<TextControl
								label={__('Backlink Text', 'lead-gen')}
								value={backlink.title || ''}
								onChange={(title) =>
									setAttributes({
										backlink: {
											...backlink,
											title,
										},
									})
								}
							/>
							<BaseControl label={"Backlink URL"}>
								<Link
									value={backlink.title}
									url={backlink.url}
									opensInNewTab={true}
									onTextChange={handleTextChange}
									onLinkChange={handleLinkChange}
									onLinkRemove={handleLinkRemove}
									className='example-classname'
									placeholder='Enter Backlink Text Here...'
								/>
							</BaseControl>
						</div>
					)}
				</PanelBody>
				<VisibilityControls attributes={attributes} setAttributes={setAttributes} />
				<AnimationControls attributes={attributes} setAttributes={setAttributes} />
			</InspectorControls>
			<p className={`copyright`}>
				&copy; {new Date().getFullYear()} {siteName}. All Rights Reserved.
				{showBacklink && (
					<>
						<br />
						{backlink?.url ? (
							<a
								href={backlink.url}
								target="_blank"
								rel="noreferrer noopener"
							>
								{backlink.title || __('Visit site', 'lead-gen')}
							</a>
						) : (
							<a
								href="https://strategynewmedia.com"
								target="_blank"
								rel="noreferrer noopener"
							>
								Crafted with ❤ by Strategy
							</a>
						)}
					</>
				)}
			</p>
		</AnimatedBlockWrapper>
	);
};

export default Edit;
