import { PanelBody, SelectControl } from '@wordpress/components';
import DeviceControl from '../responsive/DeviceControl';
import { __ } from '@wordpress/i18n';

const COLUMN_WIDTH_OPTIONS = [
	{ label: __('Unset', 'lead-gen'), value: '' },
	...Array.from({ length: 12 }, (_, i) => ({
		label: `${i + 1} / 12`,
		value: String(i + 1),
	})),
    { label: __('Full', 'lead-gen'), value: 'full' },
	{ label: __('Auto', 'lead-gen'), value: 'auto' },
];

const JUSTIFY_OPTIONS = [
	{ label: __('Inherit', 'lead-gen'), value: '' },
	{ label: __('Start', 'lead-gen'), value: 'start' },
	{ label: __('Center', 'lead-gen'), value: 'center' },
	{ label: __('End', 'lead-gen'), value: 'end' },
	{ label: __('Space Around', 'lead-gen'), value: 'around' },
	{ label: __('Space Between', 'lead-gen'), value: 'between' },
	{ label: __('Space Evenly', 'lead-gen'), value: 'evenly' },
];

const ALIGN_OPTIONS = [
	{ label: __('Inherit', 'lead-gen'), value: '' },
	{ label: __('Top', 'lead-gen'), value: 'top' },
	{ label: __('Middle', 'lead-gen'), value: 'middle' },
	{ label: __('Bottom', 'lead-gen'), value: 'bottom' },
];

export default function VisibilityControls({ attributes, setAttributes }) {
    const { horizontalAlign, verticalAlign, columnWidth } = attributes;

    const handleResponsiveChange = (key) => (val) => {
		setAttributes({ [key]: val });
	};

    return (
        <PanelBody title={__(columnWidth ? 'Sizing & Alignment' : 'Alignment', 'lead-gen')} initialOpen>
            {columnWidth ?
            <DeviceControl
                value={columnWidth}
                onChange={handleResponsiveChange('columnWidth')}
            >
                <SelectControl
                    label={__('Column Width (1-12)', 'lead-gen')}
                    options={COLUMN_WIDTH_OPTIONS}
                />
            </DeviceControl> : null}
            <DeviceControl
                value={horizontalAlign}
                onChange={handleResponsiveChange('horizontalAlign')}
            >
                <SelectControl label="Horizontal Align" options={JUSTIFY_OPTIONS} />
            </DeviceControl>
            <DeviceControl
                value={verticalAlign}
                onChange={handleResponsiveChange('verticalAlign')}
            >
                <SelectControl label="Vertical Align" options={ALIGN_OPTIONS} />
            </DeviceControl>
        </PanelBody>
    );
}


