import { __ } from '@wordpress/i18n';
import { PanelBody, TextControl, SelectControl } from '@wordpress/components';

const LinkBlockControl = ({ link = {}, setAttributes }) => {
	const { url = '', target = '_self', title = '' } = link;

	const updateLink = (newLink) => {
		setAttributes({ link: { ...link, ...newLink } });
	};

	return (
		<PanelBody title={__('Link Settings', 'lead-gen')} initialOpen={false}>
			<TextControl
				label={__('Link URL', 'lead-gen')}
				value={url}
				onChange={(val) => updateLink({ url: val })}
			/>
			<SelectControl
				label={__('Link Target', 'lead-gen')}
				value={target}
				options={[
					{ label: __('Same Window', 'lead-gen'), value: '_self' },
					{ label: __('New Window', 'lead-gen'), value: '_blank' },
				]}
				onChange={(val) => updateLink({ target: val })}
			/>
			<TextControl
				label={__('Link Title', 'lead-gen')}
				value={title}
				onChange={(val) => updateLink({ title: val })}
			/>
		</PanelBody>

	);
};

export default LinkBlockControl;
