import { __ } from '@wordpress/i18n';
import { PanelBody, ToggleControl, SelectControl } from '@wordpress/components';

const BORDER_RADIUS_OPTIONS = [
	{ label: __('None', 'lead-gen'), value: 'none' },
	{ label: __('Extra Small', 'lead-gen'), value: 'xs' },
	{ label: __('Small', 'lead-gen'), value: 'sm' },
	{ label: __('Medium', 'lead-gen'), value: 'md' },
	{ label: __('Large', 'lead-gen'), value: 'lg' },
	{ label: __('Extra Large', 'lead-gen'), value: 'xl' },
];

const COLOR_OPTIONS = [
	{ label: __('Default', 'lead-gen'), value: '' },
	{ label: __('Primary', 'lead-gen'), value: 'primary' },
	{ label: __('Primary Tint 1', 'lead-gen'), value: 'primary-tint-1' },
	{ label: __('Primary Tint 2', 'lead-gen'), value: 'primary-tint-2' },
	{ label: __('Primary Shade 1', 'lead-gen'), value: 'primary-shade-1' },
	{ label: __('Primary Shade 2', 'lead-gen'), value: 'primary-shade-2' },
	{ label: __('Secondary', 'lead-gen'), value: 'secondary' },
	{ label: __('Secondary Tint 1', 'lead-gen'), value: 'secondary-tint-1' },
	{ label: __('Secondary Tint 2', 'lead-gen'), value: 'secondary-tint-2' },
	{ label: __('Secondary Shade 1', 'lead-gen'), value: 'secondary-shade-1' },
	{ label: __('Secondary Shade 2', 'lead-gen'), value: 'secondary-shade-2' },
	{ label: __('Accent 1', 'lead-gen'), value: 'accent-1' },
	{ label: __('Accent 1 Tint 1', 'lead-gen'), value: 'accent-1-tint-1' },
	{ label: __('Accent 1 Tint 2', 'lead-gen'), value: 'accent-1-tint-2' },
	{ label: __('Accent 1 Shade 1', 'lead-gen'), value: 'accent-1-shade-1' },
	{ label: __('Accent 1 Shade 2', 'lead-gen'), value: 'accent-1-shade-2' },
	{ label: __('Accent 2', 'lead-gen'), value: 'accent-2' },
	{ label: __('Accent 2 Tint 1', 'lead-gen'), value: 'accent-2-tint-1' },
	{ label: __('Accent 2 Tint 2', 'lead-gen'), value: 'accent-2-tint-2' },
	{ label: __('Accent 2 Shade 1', 'lead-gen'), value: 'accent-2-shade-1' },
	{ label: __('Accent 2 Shade 2', 'lead-gen'), value: 'accent-2-shade-2' },
];

const BorderPanel = ({ attributes, setAttributes }) => {
	const { border, borderRadius, borderColor } = attributes;

	return (
		<PanelBody title={__('Border', 'lead-gen')} initialOpen={false}>
			<ToggleControl
				label={__('Border', 'lead-gen')}
				checked={border}
				onChange={(val) => setAttributes({ border: val })}
			/>
			{border && (
				<>
					<SelectControl
						label={__('Border Radius', 'lead-gen')}
						value={borderRadius}
						options={BORDER_RADIUS_OPTIONS}
						onChange={(val) => setAttributes({ borderRadius: val })}
					/>
					<SelectControl
						label={__('Border Color', 'lead-gen')}
						value={borderColor}
						options={COLOR_OPTIONS}
						onChange={(val) => setAttributes({ borderColor: val })}
					/>
				</>
			)}
		</PanelBody>
	);
};

export default BorderPanel;

