<?php
/**
 * Social Icons
 *
 * @package StrategyBlocks
 *
 * @var array $attributes Block attributes registered in block.json.
 */

use StrategyBlocks\Utility;

$anchor       = ! empty( $attributes['anchor'] ) ? $attributes['anchor'] : '';
$animations   = Utility\get_animation_data( $attributes );
$class_name   = implode(
	' ',
	array_filter(
		[
			'lg-block',
			'lg-block__social-icons',
			'social__icons',
			$attributes['stacked'] ? ' lg-block__social-icons--stacked' : '',
			Utility\get_block_style_classes( $attributes ),
			Utility\get_native_wp_classes( $attributes ),
			Utility\get_visibility_classes( $attributes ),
		]
	)
);

$social_media = [];

if ( function_exists( 'get_field' ) ) {
	$business_info = get_field( 'business_information', 'options' );
	$social_media = isset( $business_info['social_media'] ) ? $business_info['social_media'] : [];
};

$svg_args = [
	'svg'   => [
		'class'           => true,
		'aria-hidden'     => true,
		'aria-labelledby' => true,
		'role'            => true,
		'xmlns'           => true,
		'width'           => true,
		'height'          => true,
		'viewbox'         => true,
	],
	'g'     => [ 'fill'  => true ],
	'title' => [ 'title' => true ],
	'path'  => [
		'd'               => true,
		'fill'            => true,
	],
];
?>

<?php do_action( 'lg_block_social_icons_before' ); ?>

<?php if ( ! empty( $social_media ) ) : ?>
	<ul
		<?php
		if ( $anchor ) {
			echo 'id="' . esc_attr( $anchor ) . '"';
		}
		?>
		class="<?php echo esc_attr( $class_name ); ?>"
		<?php
		if ( $animations ) {
			echo 'data-animation="' . esc_attr( $animations ) . '"';
		}
		?>
	>
		<?php foreach ( $social_media as $key => $social ) { ?>
			<?php if ( isset( $social ) && ! empty( $social ) ) { ?>
				<li class="social__icon">
					<a
						href="<?php echo esc_url( $social ); ?>"
						target="_blank"
						rel="noreferrer noopener"
						title="(opens in a new window)"
						class="social__icon-link <?php echo $attributes['stacked'] ? 'social__icon-link--stacked' : null; ?>">
						<?php echo wp_kses( Utility\get_social_icon( $key ), $svg_args ); ?>
					</a>
				</li>
			<?php } ?>
		<?php } ?>
	</ul>
<?php endif; ?>

<?php do_action( 'lg_block_social_icons_after' ); ?>
