<?php
/**
 * Counter Block
 *
 * @package StrategyBlocks
 */

use StrategyBlocks\Utility;

$start  = $attributes['startNumber'] ?? 0;
$end    = $attributes['endNumber'] ?? 100;
$prefix = $attributes['prefix'] ?? '';
$suffix = $attributes['suffix'] ?? '';
$duration = $attributes['duration'] ?? 2000;
$thousand_separator = $attributes['thousandSeparator'] ?? true;
$separator = $attributes['separator'] ?? ',';
$title = $attributes['title'] ?? '';
$title_tag = $attributes['titleTag'] ?? 'h3';

$id = 'lg-counter-' . uniqid();

$heading_tags = [ 'h1', 'h2', 'h3', 'h4', 'h5', 'h6' ];
$extra_heading_class = in_array( strtolower( $title_tag ), $heading_tags, true ) ? strtolower( $title_tag ) : '';

$title_classes = '';
if ( in_array( strtolower( $title_tag ), $heading_tags, true ) ) {
	$title_classes .= ' ' . strtolower( $title_tag );
}

$class_name = implode(
	' ',
	array_filter(
		[
			'lg-block',
			'lg-block__counter',
			Utility\get_block_style_classes( $attributes ),
			Utility\get_native_wp_classes( $attributes ),
			Utility\get_visibility_classes( $attributes ),
			$extra_heading_class,
		]
	)
);

$animations = Utility\get_animation_data( $attributes );

do_action( 'lg_block_counter_before' );
?>
<div class="<?php echo esc_attr( $class_name ); ?>" <?php echo ! empty( $animations ) ? 'data-animation="' . esc_attr( $animations ) . '"' : ''; ?>>
	<?php if ( $title ) : ?>
		<<?php echo esc_html( $title_tag ); ?> class="counter__title">
		<?php echo esc_html( $title ); ?>
		</<?php echo esc_html( $title_tag ); ?>>
	<?php endif; ?>

	<div class="counter__number-wrapper">
		<span class="counter__number-prefix"><?php echo esc_html( $prefix ); ?></span>
		<span
			id="<?php echo esc_attr( $id ); ?>"
			class="counter__number"
			data-start="<?php echo esc_attr( $start ); ?>"
			data-end="<?php echo esc_attr( $end ); ?>"
			data-prefix="<?php echo esc_attr( $prefix ); ?>"
			data-suffix="<?php echo esc_attr( $suffix ); ?>"
			data-duration="<?php echo esc_attr( $duration ); ?>"
			data-use-grouping="<?php echo $thousand_separator ? 'true' : 'false'; ?>"
			data-separator="<?php echo esc_attr( $separator ); ?>"
		>
		</span>
		<span class="counter__number-suffix"><?php echo esc_html( $suffix ); ?></span>
	</div>
</div>
<?php do_action( 'lg_block_counter_after' ); ?>
