<?php
/**
 * Card
 *
 * @package StrategyBlocks
 *
 * @param array  $attributes  The block's attributes.
 * @param string $content     The block's inner content (unused here).
 * @param object $block       The block object (contains anchor, etc.).
 */

use StrategyBlocks\Utility;

$id               = $attributes['anchor'] ?? '';
$image_id         = $attributes['imageId'] ?? null;
$image_size       = $attributes['imageSize'] ?? 'md';
$image_placement  = $attributes['imagePlacement'] ?? 'top';
$border           = $attributes['border'] ?? false;
$border_color     = $attributes['borderColor'] ?? '';
$border_radius    = $attributes['borderRadius'] ?? 'none';
$placeholder      = $attributes['placeholderDimensions'] ?? [
	'width' => 640,
	'height' => 360,
];
$animations       = Utility\get_animation_data( $attributes );

switch ( $image_placement ) {
	case 'top':
		$placement = 'vertical';
		break;
	case 'left':
		$placement = 'horizontal';
		break;
	case 'right':
		$placement = 'horizontal reverse';
		break;
	case 'background':
		$placement = 'vertical card--background';
		break;
	default:
		$placement = '';
		break;
}

$class_name = implode(
	' ',
	array_filter(
		[
			'lg-block',
			'lg-block__card',
			'card',
			$placement ? 'card--' . $placement : '',
			$border ? 'card--bordered' : '',
			$border_color ? 'border-color-' . $border_color : '',
			'none' !== $border_radius ? 'rounded-' . $border_radius : '',
			Utility\get_block_style_classes( $attributes ),
			Utility\get_native_wp_classes( $attributes ),
			Utility\get_visibility_classes( $attributes ),
		]
	)
);

do_action( 'lg_block_card_before' ); ?>
<div
	<?php if ( $id ) { echo 'id="' . esc_attr( $id ) . '"';} ?>
	class="<?php echo esc_attr( $class_name ); ?>"
	<?php if ( $animations ) { echo 'data-animation="' . esc_attr( $animations ) . '"';} ?>
>
	<?php if ( 'none' !== $image_placement ) : ?>
		<?php if ( $image_id ) : ?>
			<div class="card__media">
				<?php echo wp_get_attachment_image( $image_id, 'large', false, [ 'class' => 'card__media-img card__media-img--size-' . esc_attr( $image_size ) ] ); ?>
			</div>
		<?php else : ?>
			<div class="card__media">
				<img
					src="https://placehold.co/<?php echo esc_attr( $placeholder['width'] . 'x' . $placeholder['height'] ); ?>"
					alt="Placeholder - Please Replace Me"
					title="Placeholder - Please Replace Me"
					class="card__media-img media__image card__media-img--size-<?php echo esc_attr( $image_size ); ?>"
				/>
			</div>
		<?php endif; ?>
	<?php endif; ?>

	<div class="card__content col">
		<?php echo $content; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
	</div>
</div>
<?php do_action( 'lg_block_card_after' ); ?>
