<?php
/**
 * Bio Block
 *
 * @package StrategyBlocks
 *
 * @param array  $attributes  Block attributes.
 * @param string $content
 * @param object $block
 */

use StrategyBlocks\Utility;

$id         = $attributes['anchor'] ?? '';
$selector   = $attributes['selector'] ?? 'all';
$size       = $attributes['size'] ?? 'md';
$corners    = $attributes['corners'] ?? 0;
$per_row    = $attributes['perRow'] ?? 3;
$btn_text   = $attributes['btnText'] ?? '';
$categories = $attributes['categories'] ?? [];
$team_ids   = $attributes['teamMembers'] ?? [];

$class_name = implode(
	' ',
	array_filter(
		[
			'lg-block',
			'lg-block__content',
			'lg-block__bio--container',
			Utility\get_block_style_classes( $attributes ),
			Utility\get_visibility_classes( $attributes ),
		]
	)
);

$component_classes = array(
	'background'    => null,
	'overlay'       => null,
	'text'          => null,
	'link'          => null,
	'button'        => null,
);

$wp_classes = explode( ' ', trim( Utility\get_native_wp_classes( $attributes ) ) );

foreach ( $wp_classes as $class ) {
	if ( false !== strpos( $class, 'text-color' ) ) {
		$component_classes['text'] = $class;
	} else if ( false !== strpos( $class, 'bg-color' ) ) {
		$component_classes['background'] = $class;
		$component_classes['overlay'] = $class;
		if ( false !== strpos( $class, 'primary' ) ) {
			$component_classes['button'] = 'btn-secondary';
		} else if ( false !== strpos( $class, 'secondary' ) ) {
			$component_classes['button'] = 'btn-primary';
		} else {
			$component_classes['button'] = 'btn-tertiary';
		}
	} else if ( false !== strpos( $class, 'link-color' ) ) {
		$component_classes['link'] = $class;
	} else {
		$class_name .= ' ' . $class;
	}
}

$design_classes = array(
	'background'    => $component_classes['background'] ?? 'bg-color-secondary',
	'overlay'       => $component_classes['overlay'] ?? 'bg-color-secondary',
	'text'          => $component_classes['text'] ?? 'text-color-primary',
	'link'          => $component_classes['link'] ?? 'link-color-accent-1',
	'button'        => $component_classes['button'] ?? 'btn-primary',
);

$open_class    = 'lg-bio lg-bio--open lg-bio--open--size-' . $size . ' lg-bio--corners-' . $corners . ' ' . $design_classes['background'];
$closed_class  = 'lg-bio lg-bio--closed lg-bio--closed--size-' . $size . ' lg-bio--corners-' . $corners;
$animations    = Utility\get_animation_data( $attributes );

$query_args = [
	'post_type'      => 'team-members',
	'post_status'    => 'publish',
	'posts_per_page' => -1,
];

switch ( $selector ) {
	case 'name':
		if ( ! empty( $attributes['teamMembers'][0] ?? '' ) ) {
			$query_args['post__in'] = $attributes['teamMembers'];
		}
		break;

	case 'category':
		if ( ! empty( $attributes['categories'][0] ?? '' ) ) {
			$query_args['tax_query'] = [
				[
					'taxonomy' => 'team-member-categories',
					'field'    => 'id',
					'terms'    => $attributes['categories'],
				],
			];
		}
		break;
}

$query = new WP_Query( $query_args );

do_action( 'lg_block_bio_before' );

if ( $query->have_posts() ) :
	?>

<div <?php echo $id ? 'id="' . esc_attr( $id ) . '"' : ''; ?> class="<?php echo esc_attr( $class_name ); ?>">
	<?php
	while ( $query->have_posts() ) :
		$query->the_post();

		$id         = get_the_ID();
		$post_title = get_the_title( $id );
		$image_id   = get_post_thumbnail_id( $id );
		$bio        = get_the_excerpt( $id );
		$title      = get_field( 'title', $id );
		$link       = get_field( 'link_to_single_page', $id ) ? get_permalink( $id ) : null;
		?>
		<div
			class="lg-block__bio lg-block__bio--closed lg-block__bio--closed--size-<?php echo esc_attr( $size ); ?> row-max--closed-<?php echo esc_attr( $per_row ); ?>"
			<?php echo ! empty( $animations ) ? 'data-animation="' . esc_attr( $animations ) . '" ' : null; ?>
		>
			<div class="<?php echo esc_attr( $closed_class ); ?>">
				<div class="lg-bio__image--container">
					<?php
					if ( $image_id ) {
						echo wp_get_attachment_image(
							$image_id,
							'full',
							false,
							[
								'class' => esc_attr( 'lg-bio__image lg-bio--corners-' . $corners ),
								'loading' => 'lazy',
							]
						);
					}
					?>
					<div class="lg-bio__overlay lg-bio--corners-<?php echo esc_attr( $corners ); ?> <?php echo esc_attr( $design_classes['overlay'] ); ?>"></div>
				</div>
				<div class="lg-bio__text lg-bio__text--container <?php echo esc_attr( $design_classes['text'] ); ?>">
					<span class="lg-bio__text lg-bio__text--name"><?php echo esc_html( $post_title ); ?></span>
					<span class="lg-bio__text lg-bio__text--title"><?php echo esc_html( $title ); ?></span>
				</div>
				<?php if ( $bio ) : ?>
					<a class="btn <?php echo esc_attr( $design_classes['button'] ); ?> lg-bio__btn lg-bio__btn--open">
						<?php echo esc_html( $btn_text ); ?>
					</a>
				<?php elseif ( $link ) : ?>
					<a class="btn <?php echo esc_attr( $design_classes['button'] ); ?> lg-bio__btn" href="<?php echo esc_url( $link ); ?>">
						<?php echo esc_html( $btn_text ); ?>
					</a>
				<?php endif; ?>
			</div>
			<?php if ( $bio ) : ?>
				<div class="<?php echo esc_attr( $open_class ); ?> <?php echo esc_attr( $design_classes['text'] ); ?> <?php echo esc_attr( $design_classes['link'] ); ?>">
					<div class="lg-bio__text lg-bio__text--bio">
						<?php Utility\sanitize_and_output_html_content( $bio ); ?>
					</div>
					<?php if ( $link ) : ?>
						<a class="lg-bio__text lg-bio__text--link" href="<?php echo esc_url( $link ); ?>"><?php esc_html_e( 'Read More >', 'lead-gen' ); ?></a>
					<?php endif; ?>
				</div>
				<?php
			endif;
			?>
		</div>
		<?php endwhile; ?>
</div>
	<?php
	endif;
	wp_reset_postdata();
?>

<?php do_action( 'lg_block_bio_after' ); ?>
