<?php

namespace GroundhoggZeroBounce\API;

use Groundhogg\Api\V4\Base_Api;
use GroundhoggZeroBounce\ZeroBounce;
use function Groundhogg\get_contactdata;
use function GroundhoggZeroBounce\fetch_zb_status;

class ZeroBounce_Api extends Base_Api {

	public function register_routes() {

		register_rest_route( self::NAME_SPACE, 'zerobounce/validate', [
			[
				'methods'             => \WP_REST_Server::READABLE,
				'permission_callback' => [ $this, 'permission_callback' ],
				'callback'            => [ $this, 'validate' ],
			]
		] );
	}

	/**
	 * @param \WP_REST_Request $request
	 *
	 * @return object|\WP_Error|\WP_REST_Response
	 */
	public function validate( \WP_REST_Request $request ) {
		$id      = $request->get_param( 'id_or_email' );
		$contact = get_contactdata( $id );

		if ( ! $contact ) {
			return self::ERROR_404();
		}

		$status = fetch_zb_status( $contact );

		return self::SUCCESS_RESPONSE( [
			'item'   => $contact,
			'status' => $status
		] );
	}

	public function permission_callback( \WP_REST_Request $request ) {
		return current_user_can( 'edit_contact', $request->get_param( 'id_or_email' ) );
	}
}
