<?php
/**
 * Created by PhpStorm.
 * User: atty
 * Date: 31-Jul-19
 * Time: 1:15 PM
 */

namespace GroundhoggWhiteLabel;

use function Groundhogg\get_white_label_option;
use function Groundhogg\get_white_labeled_author_name;
use function Groundhogg\get_white_labeled_author_uri;
use function Groundhogg\get_white_labeled_plugin_uri;
use function Groundhogg\is_white_labeled;
use function Groundhogg\white_labeled_name;

class White_Label {

	public function __construct() {
		if ( is_white_labeled() ) {
			add_filter( 'all_plugins', [ $this, 'change_plugin_names' ] );
			add_filter( 'groundhogg/extension/name', [ $this, 'filter_name' ] );
			add_filter( 'groundhogg/extension/description', [ $this, 'filter_description' ] );
		}
	}

	public function filter_name( $name ) {
		return preg_replace( '/Groundhogg/', white_labeled_name(), $name );
	}

	public function filter_description( $description ) {

		$desc = preg_replace( '/Groundhogg Inc\./', get_white_labeled_author_name(), $description );
		$desc = preg_replace( '/Groundhogg/', white_labeled_name(), $desc );
		$desc = preg_replace( '#https://www\.groundhogg\.io/#', get_white_labeled_author_uri(), $desc );

		return $desc;
	}

	/**
	 * Search and replace Groundhogg in the plugin title so it appears as the white labeled name
	 *
	 * @param $plugins
	 *
	 * @return array[]
	 */
	public function change_plugin_names( $plugins ) {
		foreach ( $plugins as &$plugin ) {
			// Not a Groundhogg Plugin
			if ( ! preg_match( '/Groundhogg/', $plugin['Name'] ) ) {
				continue;
			}

			$plugin['Name']        = preg_replace( '/Groundhogg/', white_labeled_name(), $plugin['Name'] );
			$plugin['Title']       = preg_replace( '/Groundhogg/', white_labeled_name(), $plugin['Title'] );
			$plugin['Description'] = preg_replace( '/Groundhogg Inc\./', get_white_labeled_author_name(), $plugin['Description'] );
			$plugin['Description'] = preg_replace( '/Groundhogg/', white_labeled_name(), $plugin['Description'] );

			$plugin['Author']     = get_white_labeled_author_name();
			$plugin['AuthorName'] = get_white_labeled_author_name();
			$plugin['AuthorURI']  = get_white_labeled_author_uri();
			$plugin['PluginURI']  = get_white_labeled_plugin_uri();
		}

		return $plugins;
	}

}
