<?php

namespace GroundhoggWhiteLabel;

use Groundhogg\Extension;
use function Groundhogg\is_option_enabled;
use function Groundhogg\white_label_is_network_active;

class Plugin extends Extension {

	/**
	 * @var White_Label $white_label;
	 */
	public $white_label;

	/**
	 * Override the parent instance.
	 *
	 * @var Plugin
	 */
	public static $instance;

	/**
	 * Include any files.
	 *
	 * @return void
	 */
	public function includes() {
		include __DIR__ . '/functions.php';
	}

	/**
	 * Init any components that need to be added.
	 *
	 * @return void
	 */
	public function init_components() {
		$this->installer   = new Installer();
		$this->updater     = new Updater();
		$this->white_label = new White_Label();
	}

	public function register_settings( $settings ) {

		$settings['gh_white_label_enable'] = [
			'id'      => 'gh_white_label_enable',
			'section' => 'branding_settings',
			'label'   => __( 'White Label Service ', 'groundhogg' ),
			'desc'    => __( 'Enable this setting to use White Label.', 'groundhogg' ),
			'type'    => 'checkbox',
			'atts'    => [
				'name'    => 'gh_white_label_enable',
				'id'      => 'gh_white_label_enable',
				'label'   => __( 'Enable' ),
				'checked' => is_option_enabled( 'gh_white_label_enable' )
			]
		];

		$settings['gh_white_label_branding_name'] = [
			'id'      => 'gh_white_label_branding_name',
			'section' => 'branding_settings',
			'type'    => 'input',
			'label'   => __( 'Brand Name', 'groundhogg' ),
			'desc'    => __( 'Instances of the phrase <b>Groundhogg</b> will be replaced with this.', 'groundhogg' ),
			'atts'    => [
				'type' => 'text',
				'name' => 'gh_white_label_branding_name',
				'id'   => 'gh_white_label_branding_name',
			]
		];

		$settings['gh_white_label_author_name'] = [
			'id'      => 'gh_white_label_author_name',
			'section' => 'branding_settings',
			'type'    => 'input',
			'label'   => __( 'Author Name', 'groundhogg' ),
			'desc'    => __( 'Will show as author in the plugin view.', 'groundhogg' ),
			'atts'    => [
				'type' => 'text',
				'name' => 'gh_white_label_author_name',
				'id'   => 'gh_white_label_author_name',
			]
		];

		$settings['gh_white_label_author_uri'] = [
			'id'      => 'gh_white_label_author_uri',
			'section' => 'branding_settings',
			'type'    => 'link_picker',
			'label'   => __( 'Author URI', 'groundhogg' ),
			'desc'    => __( 'Will show as author URI the plugin view.', 'groundhogg' ),
			'atts'    => [
				'type' => 'text',
				'name' => 'gh_white_label_author_uri',
				'id'   => 'gh_white_label_author_uri',
			]
		];

		$settings['gh_white_label_plugin_uri'] = [
			'id'      => 'gh_white_label_plugin_uri',
			'section' => 'branding_settings',
			'type'    => 'link_picker',
			'label'   => __( 'Plugin URI', 'groundhogg' ),
			'desc'    => __( 'Will show as Plugin URI the plugin view.', 'groundhogg' ),
			'atts'    => [
				'type' => 'text',
				'name' => 'gh_white_label_plugin_uri',
				'id'   => 'gh_white_label_plugin_uri',
			]
		];

		$settings['gh_white_label_template_site'] = [
			'id'      => 'gh_white_label_template_site',
			'section' => 'branding_settings',
			'type'    => 'input',
			'label'   => __( 'Template Directory', 'groundhogg' ),
			'desc'    => __( 'The root domain of the site you wish to pull funnel & email templates from.', 'groundhogg' ),
			'atts'    => [
				'type'        => 'url',
				'placeholder' => 'https://library.myagency.com/',
				'name'        => 'gh_white_label_template_site',
				'id'          => 'gh_white_label_template_site',
			]
		];

		return $settings;
	}


	public function register_settings_sections( $sections ) {

		$sections['branding_settings'] = [
			'id'    => 'branding_settings',
			'title' => _x( 'Branding', 'settings_sections', 'groundhogg' ),
			'tab'   => 'white_label'
		];

		return $sections;
	}


	public function register_settings_tabs( $tabs ) {

		if ( \Groundhogg\is_main_blog() || ! white_label_is_network_active() ) {
			$tabs['white_label'] = [
				'id'    => 'white_label',
				'title' => _x( 'White Label', 'settings_tabs', 'groundhogg' ),
				'cap'   => 'manage_gh_white_label'
			];
		}

		return $tabs;
	}

	/**
	 * Get the ID number for the download in EDD Store
	 *
	 * @return int
	 */
	public function get_download_id() {
		return 4754;
	}

	/**
	 * Get the version #
	 *
	 * @return mixed
	 */
	public function get_version() {
		return GROUNDHOGG_WHITE_LABEL_VERSION;
	}

	/**
	 * @return string
	 */
	public function get_plugin_file() {
		return GROUNDHOGG_WHITE_LABEL__FILE__;
	}

	/**
	 * Register autoloader.
	 *
	 * Groundhogg autoloader loads all the classes needed to run the plugin.
	 *
	 * @since  1.6.0
	 * @access private
	 */
	protected function register_autoloader() {
		require GROUNDHOGG_WHITE_LABEL_PATH . 'includes/autoloader.php';
		Autoloader::run();
	}
}

Plugin::instance();
