<?php

namespace Groundhogg;

function white_label_is_network_active() {

	if ( ! is_multisite() ){
		return true;
	}

	return is_plugin_active_for_network( GROUNDHOGG_WHITE_LABEL_PLUGIN_BASE );
}

/**
 * Get a white label option, gould be from main blog or single site options DB
 *
 * @param string $option
 * @param bool $default
 *
 * @return mixed
 */
function get_white_label_option( $option = '', $default = false ) {
	if ( is_multisite() && white_label_is_network_active() ) {
		return get_blog_option( get_main_blog_id(), $option, $default );
	}

	return get_option( $option, $default );
}

/**
 * Get the author name
 *
 * @return mixed|void
 */
function get_white_labeled_author_name() {

	if ( is_white_labeled() ) {
		return get_white_label_option( 'gh_white_label_author_name', 'Groundhogg Inc.' );
	}

	return 'Groundhogg Inc.';

}

/**
 * Get the author URI
 *
 * @return string
 */
function get_white_labeled_author_uri() {

	if ( is_white_labeled() ) {
		return get_white_label_option( 'gh_white_label_author_uri', 'https://www.groundhogg.io' );
	}

	return 'https://www.groundhogg.io';
}

/**
 * Get the White label plugin URI
 *
 * @return string
 */
function get_white_labeled_plugin_uri() {

	if ( is_white_labeled() ) {
		return get_white_label_option( 'gh_white_label_plugin_uri', 'https://www.groundhogg.io' );
	}

	return 'https://www.groundhogg.io';
}

if ( ! function_exists( __NAMESPACE__ . '\is_white_labeled' ) ) {

	/**
	 * Whether the Groundhogg is while labeled or not.
	 *
	 * @return bool
	 */
	function is_white_labeled() {
		return get_white_label_option( 'gh_white_label_enable', false );
	}

}

if ( ! function_exists( __NAMESPACE__ . '\white_labeled_name' ) ) {

	/**
	 * Return replacement name form white label
	 *
	 * @return string
	 */
	function white_labeled_name() {

		if ( is_white_labeled() ) {
			return get_white_label_option( 'gh_white_label_branding_name', false );
		}

		return 'Groundhogg';
	}
}
