<?php

namespace GroundhoggWhiteLabel;

use function Groundhogg\words_to_key;

class Installer extends \Groundhogg\Installer {

	protected function activate() {

		// remove site wide license access
		$caps_to_remove = [
			'manage_gh_white_label',
			'manage_gh_licenses',
		];

		$roles = [ 'administrator', 'marketer' ];

		foreach ( $roles as $role ) {
			$role = get_role( $role );

			if ( ! $role ) {
				continue;
			}

			foreach ( $caps_to_remove as $cap ) {
				$role->remove_cap( $cap );
			}
		}

		if ( wp_get_current_user() ){
			// Add access to the current user only...
			wp_get_current_user()->add_cap( 'manage_gh_white_label' );
			wp_get_current_user()->add_cap( 'manage_gh_licenses' );
		}
	}

	protected function deactivate() {

		// Restore the caps...
		$caps_to_add = [
			'manage_gh_white_label',
			'manage_gh_licenses',
		];

		$roles = [ 'administrator', 'marketer' ];

		foreach ( $roles as $role ) {
			$role = get_role( $role );

			if ( ! $role ) {
				continue;
			}

			foreach ( $caps_to_add as $cap ) {
				$role->add_cap( $cap );
			}
		}
	}

	/**
	 * The path to the main plugin file
	 *
	 * @return string
	 */
	function get_plugin_file() {
		return GROUNDHOGG_WHITE_LABEL__FILE__;
	}

	/**
	 * Get the plugin version
	 *
	 * @return string
	 */
	function get_plugin_version() {
		return GROUNDHOGG_WHITE_LABEL_VERSION;
	}

	/**
	 * A unique name for the updater to avoid conflicts
	 *
	 * @return string
	 */
	protected function get_installer_name() {
		return words_to_key( GROUNDHOGG_WHITE_LABEL_NAME );
	}
}