<?php

namespace GroundhoggWhiteLabel;

use function Groundhogg\get_white_label_option;
use function Groundhogg\is_white_labeled;

/**
 * Filter the template library url.
 *
 * @param $url
 *
 * @return string
 */
function filter_template_library( $url ) {

	if ( ! is_white_labeled() ) {
		return $url;
	}

	$override = get_white_label_option( 'gh_white_label_template_site' );

	if ( empty( $override ) ){
		return $url;
	}

	return trailingslashit( $override ) . 'wp-json/gh/v4/';
}

add_filter( 'groundhogg/library/get_library_url', __NAMESPACE__ . '\filter_template_library' );
