<?php
/*
 * Plugin Name: Groundhogg - White Label
 * Plugin URI:  https://www.groundhogg.io/?utm_source=wp-plugins&utm_campaign=plugin-uri&utm_medium=wp-dash
 * Description: Change the branding Groundhogg to your own.
 * Version: 2.0.9
 * Author: Groundhogg Inc.
 * Author URI: https://www.groundhogg.io/?utm_source=wp-plugins&utm_campaign=author-uri&utm_medium=wp-dash
 * Text Domain: groundhogg
 * Domain Path: /languages
 *
 * Groundhogg is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * Groundhogg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */

if ( ! defined( 'ABSPATH' ) ) exit;

define( 'GROUNDHOGG_WHITE_LABEL_VERSION', '2.0.9' );
define( 'GROUNDHOGG_WHITE_LABEL_PREVIOUS_STABLE_VERSION', '2.0.8' );
define( 'GROUNDHOGG_WHITE_LABEL_NAME', 'White Label' );

define( 'GROUNDHOGG_WHITE_LABEL__FILE__', __FILE__ );
define( 'GROUNDHOGG_WHITE_LABEL_PLUGIN_BASE', plugin_basename( GROUNDHOGG_WHITE_LABEL__FILE__ ) );
define( 'GROUNDHOGG_WHITE_LABEL_PATH', plugin_dir_path( GROUNDHOGG_WHITE_LABEL__FILE__ ) );

define( 'GROUNDHOGG_WHITE_LABEL_URL', plugins_url( '/', GROUNDHOGG_WHITE_LABEL__FILE__ ) );

define( 'GROUNDHOGG_WHITE_LABEL_ASSETS_PATH', GROUNDHOGG_WHITE_LABEL_PATH . 'assets/' );
define( 'GROUNDHOGG_WHITE_LABEL_ASSETS_URL', GROUNDHOGG_WHITE_LABEL_URL . 'assets/' );

add_action( 'plugins_loaded', function (){
    load_plugin_textdomain( GROUNDHOGG_WHITE_LABEL_TEXT_DOMAIN, false, basename( dirname( __FILE__ ) ) . '/languages' );
} );

define( 'GROUNDHOGG_WHITE_LABEL_TEXT_DOMAIN', 'groundhogg' );

if ( ! version_compare( PHP_VERSION, '5.6', '>=' ) ) {
    add_action( 'admin_notices', function(){
        $message = sprintf( esc_html__( '%s requires PHP version %s+, plugin is currently NOT RUNNING.', 'groundhogg' ), GROUNDHOGG_WHITE_LABEL_NAME, '5.6' );
        $html_message = sprintf( '<div class="notice notice-error">%s</div>', wpautop( $message ) );
        echo wp_kses_post( $html_message );
    } );
} elseif ( ! version_compare( get_bloginfo( 'version' ), '4.9', '>=' ) ) {
    add_action( 'admin_notices', function (){
        $message = sprintf( esc_html__( '%s requires WordPress version %s+. Because you are using an earlier version, the plugin is currently NOT RUNNING.', 'groundhogg' ), GROUNDHOGG_WHITE_LABEL_NAME, '4.9' );
        $html_message = sprintf( '<div class="notice notice-error">%s</div>', wpautop( $message ) );
        echo wp_kses_post( $html_message );
    } );
} else {

    // Groundhogg is loaded, load now.
    if ( did_action( 'groundhogg/loaded' ) ){

        require __DIR__ . '/includes/plugin.php';

    // Lazy load, wait for Groundhogg!
    } else {
        add_action('groundhogg/loaded', function () {
            require __DIR__ . '/includes/plugin.php';
        });
    }
}

include_once dirname( __FILE__ ) . '/includes/overrides.php';


if ( ! defined( '__GROUNDHOGG_ITEM_ID' ) ) define( '__GROUNDHOGG_ITEM_ID', 1814 );