<?php

namespace GroundhoggReplacements;

use Groundhogg\Extension;

class Plugin extends Extension {


	/**
	 * Override the parent instance.
	 *
	 * @var Plugin
	 */
	public static $instance;

	/**
	 * @var Custom_Replacements
	 */
	public $custom_replacements;

	/**
	 * Include any files.
	 *
	 * @return void
	 */
	public function includes() {
		require GROUNDHOGG_REPLACEMENTS_PATH . '/admin/replacements-page.php';
	}

	/**
	 * Init any components that need to be added.
	 *
	 * @return void
	 */
	public function init_components() {
		$this->roles = new Roles();
		new Replacements_Page();
		$this->custom_replacements = new Custom_Replacements();
		$this->installer           = new Installer();
	}

	/**
	 * Get the ID number for the download in EDD Store
	 *
	 * @return int
	 */
	public function get_download_id() {
		return 4631;
	}

	/**
	 * Get the version #
	 *
	 * @return mixed
	 */
	public function get_version() {
		return GROUNDHOGG_REPLACEMENTS_VERSION;
	}

	/**
	 * @return string
	 */
	public function get_plugin_file() {
		return GROUNDHOGG_REPLACEMENTS__FILE__;
	}

	/**
	 * Register autoloader.
	 *
	 * Groundhogg autoloader loads all the classes needed to run the plugin.
	 *
	 * @since 1.6.0
	 * @access private
	 */
	protected function register_autoloader() {
		require GROUNDHOGG_REPLACEMENTS_PATH . 'includes/autoloader.php';
		Autoloader::run();
	}
}

Plugin::instance();