<?php

namespace GroundhoggReplacements;

use function Groundhogg\words_to_key;

class Installer extends \Groundhogg\Installer {

	protected function activate() {
		Plugin::$instance->roles->install_roles_and_caps();
	}

	protected function deactivate() {
	}

	/**
	 * The path to the main plugin file
	 *
	 * @return string
	 */
	function get_plugin_file() {
		return GROUNDHOGG_REPLACEMENTS__FILE__;
	}

	/**
	 * Get the plugin version
	 *
	 * @return string
	 */
	function get_plugin_version() {
		return GROUNDHOGG_REPLACEMENTS_VERSION;
	}

	/**
	 * A unique name for the updater to avoid conflicts
	 *
	 * @return string
	 */
	protected function get_installer_name() {
		return words_to_key( GROUNDHOGG_REPLACEMENTS_NAME );
	}
}