<?php
namespace GroundhoggReplacements;

use function Groundhogg\get_array_var;
use function Groundhogg\get_request_var;
use function Groundhogg\html;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$code        = sanitize_key( get_request_var( 'replacement' ) );
$replacement = Plugin::$instance->custom_replacements->get_replacement( $code );
?>
<form name="edittag" id="edittag" method="post" action="">
	<?php wp_nonce_field(); ?>
	<table class="form-table">
		<tbody>
		<tr class="form-field">
			<th scope="row">
				<label for="replacement-code-name"><?php _e( 'Name', 'groundhogg' ) ?></label>
			</th>
			<td><?php
				echo html()->input( [
					'id'         => 'replacement-name',
					'name'       => 'name',
					'value'      => get_array_var( $replacement, 'name' ),
				] );
				?>
			</td>
		</tr>
		<tr class="form-field">
			<th scope="row">
				<label for="replacement-code"><?php _e( 'Code', 'groundhogg' ) ?></label>
			</th>
			<td><?php
				echo html()->input( [
					'id'         => 'replacement-title',
					'name'       => 'title',
					'value'      => $replacement['code'],
					'readonly'   => true
				] );
				?>
			</td>
		</tr>
		<tr class="form-field">
			<th scope="row">
				<label for="replacement-description"><?php _e( 'Description', 'groundhogg' ) ?></label>
			</th>
			<td>
				<?php
				echo html()->textarea( [
					'id'    => 'replacement-description',
					'name'  => 'description',
					'value' => $replacement['description'],
					'rows'  => 3
				] );
				?>
				<p class="description"><?php _e( 'Enter a description.', 'groundhogg' ); ?></p>
			</td>
		</tr>
		<tr class="form-field">
			<th scope="row">
				<label for="replacement-content"><?php _e( 'Content', 'groundhogg' ) ?></label>
			</th>
			<td>
				<div style="max-width: 700px">
					<?php

					add_action( 'media_buttons', [
						\Groundhogg\Plugin::$instance->replacements,
						'show_replacements_dropdown'
					] );

					wp_editor( $replacement['content'] ? $replacement['content'] : '', 'content', [
						'editor_height' => 200,
						'editor_width'  => 500
					] );
					?>
				</div>
				<p class="description"><?php _e( 'Enter content to be replaced. Accepts replacement codes.', 'groundhogg' ); ?></p>
			</td>
		</tr>
		</tbody>
	</table>
	<div class="edit-replacement-actions">
		<?php submit_button( __( 'Update Replacement' ), 'primary', 'update', false ); ?>
		<span id="delete-link"><a class="delete"
		                          href="<?php echo wp_nonce_url( admin_url( 'admin.php?page=gh_replacements&action=delete&replacement=' . $replacement['code'] ), 'delete' ) ?>"><?php _e( 'Delete' ); ?></a></span>
	</div>
</form>