( () => {

  const {
    bold,
  } = Groundhogg.element

  const { superlinks: Superlinks } = Groundhogg.stores

  const { sprintf, __, _x, _n } = wp.i18n

  Groundhogg.ActivityTimeline.addType('clicked_superlink', {
    iconFramed: true,
    //language=HTML
    icon: `
        <svg xmlns="http://www.w3.org/2000/svg" xml:space="preserve" viewBox="0 0 512.006 512.006">
  <path fill="#ffffff" d="m212.265 390.248-60.331 60.331c-25.012 25.012-65.517 25.012-90.508.005-24.996-24.996-24.996-65.505-.005-90.496l120.683-120.683c24.991-24.992 65.5-24.992 90.491 0 8.331 8.331 21.839 8.331 30.17 0 8.331-8.331 8.331-21.839 0-30.17-41.654-41.654-109.177-41.654-150.831 0L31.252 329.918c-41.654 41.654-41.654 109.177 0 150.831 41.649 41.676 109.177 41.676 150.853 0l60.331-60.331c8.331-8.331 8.331-21.839 0-30.17s-21.84-8.331-30.171 0z"/>
            <path fill="#ffffff" d="M480.756 182.08c41.654-41.654 41.654-109.177 0-150.831-41.653-41.653-109.173-41.653-150.848-.005l-72.389 72.389c-8.331 8.331-8.331 21.839 0 30.17s21.839 8.331 30.17 0l72.384-72.384c25.008-24.992 65.521-24.992 90.513 0 24.991 24.991 24.991 65.5 0 90.491L317.85 284.646c-24.992 24.992-65.5 24.992-90.491 0-8.331-8.331-21.839-8.331-30.17 0s-8.331 21.839 0 30.17c41.654 41.654 109.177 41.654 150.831 0L480.756 182.08zm-81.657 186.846c-8.331-8.331-21.839-8.331-30.17 0-8.331 8.331-8.331 21.839 0 30.17l63.979 63.979c8.331 8.331 21.839 8.331 30.17 0 8.331-8.331 8.331-21.839 0-30.17l-63.979-63.979zM112.946 143.113c8.331 8.331 21.839 8.331 30.17 0s8.331-21.839 0-30.17L79.073 48.9c-8.331-8.331-21.839-8.331-30.17 0-8.331 8.331-8.331 21.839 0 30.17l64.043 64.043zM490.67 320h-64c-11.782 0-21.333 9.551-21.333 21.333 0 11.782 9.551 21.333 21.333 21.333h64c11.782 0 21.333-9.551 21.333-21.333 0-11.782-9.551-21.333-21.333-21.333zm-320-213.333c11.782 0 21.333-9.551 21.333-21.333v-64C192.003 9.551 182.452 0 170.67 0c-11.782 0-21.333 9.551-21.333 21.333v64c-.001 11.782 9.551 21.334 21.333 21.334zM21.336 192h64c11.782 0 21.333-9.551 21.333-21.333 0-11.782-9.551-21.333-21.333-21.333h-64c-11.782 0-21.333 9.551-21.333 21.333C.003 182.449 9.554 192 21.336 192zm320 213.333c-11.782 0-21.333 9.551-21.333 21.333v64c0 11.782 9.551 21.333 21.333 21.333 11.782 0 21.333-9.551 21.333-21.333v-64c.001-11.781-9.551-21.333-21.333-21.333z"/>
</svg>`,
    render: ({ meta, data }) => {
      let { superlink = 0 } = meta
      return `${ sprintf(__('Clicked superlink %s', 'groundhogg-pro'), bold(Superlinks.get(
        superlink)?.data.name)) }</a>`
    },
    preload: ({ meta, data }) => {
      let { superlink = 0 } = meta

      if (superlink) {
        return Superlinks.maybeFetchItem(superlink)
      }

    },
  })
} )()
