<?php

namespace GroundhoggGForms;

use Groundhogg\Extension;
use GroundhoggGForms\Steps\GForm;

class Plugin extends Extension {

	/**
	 * @var
	 */
	public static $instance;

	/**
	 * Include any files.
	 *
	 * @return void
	 */
	public function includes() {
	}

	/**
	 * Init any components that need to be added.
	 *
	 * @return void
	 */
	public function init_components() {
	}

	/**
	 * register the new benchmark.
	 *
	 * @param \Groundhogg\Steps\Manager $manager
	 */
	public function register_funnel_steps( $manager ) {
		$manager->add_step( new GForm() );
	}

	/**
	 * Get the ID number for the download in EDD Store
	 *
	 * @return int
	 */
	public function get_download_id() {
		return 219;
	}


	/**
	 * Get the version #
	 *
	 * @return mixed
	 */
	public function get_version() {
		return GROUNDHOGG_GFORMS_VERSION;
	}

	/**
	 * @return string
	 */
	public function get_plugin_file() {
		return GROUNDHOGG_GFORMS__FILE__;
	}

	/**
	 * Dependency plugin
	 * @return array|string[]
	 */
	public function get_dependent_plugins() {
		return [
			'gravityforms/gravityforms.php',
		];
	}


	/**
	 * Register autoloader.
	 *
	 * Groundhogg autoloader loads all the classes needed to run the plugin.
	 *
	 * @since  1.6.0
	 * @access private
	 */
	protected function register_autoloader() {
		require GROUNDHOGG_GFORMS_PATH . 'includes/autoloader.php';
		Autoloader::run();
	}
}

Plugin::instance();
