<?php
/*
 * Plugin Name: Groundhogg - Gravity Forms Integration
 * Plugin URI:  https://www.groundhogg.io/downloads/gravity-forms/?utm_source=wp-plugins&utm_campaign=plugin-uri&utm_medium=wp-dash
 * Description: Integrate Groundhogg with Gravity Forms!
 * Version: 2.0.11
 * Author: Groundhogg Inc.
 * Author URI: https://www.groundhogg.io/?utm_source=wp-plugins&utm_campaign=author-uri&utm_medium=wp-dash
 * Text Domain: groundhogg-gravity
 * Domain Path: /languages
 *
 * Groundhogg is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * Groundhogg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */
if ( ! defined( 'ABSPATH' ) ) exit;

define( 'GROUNDHOGG_GFORMS_VERSION', '2.0.11' );
define( 'GROUNDHOGG_GFORMS_PREVIOUS_STABLE_VERSION', '2.0.10' );
define( 'GROUNDHOGG_GFORMS_NAME', 'Gravity Forms Integration' );

define( 'GROUNDHOGG_GFORMS__FILE__', __FILE__ );
define( 'GROUNDHOGG_GFORMS_PLUGIN_BASE', plugin_basename( GROUNDHOGG_GFORMS__FILE__ ) );
define( 'GROUNDHOGG_GFORMS_PATH', plugin_dir_path( GROUNDHOGG_GFORMS__FILE__ ) );

define( 'GROUNDHOGG_GFORMS_URL', plugins_url( '/', GROUNDHOGG_GFORMS__FILE__ ) );

define( 'GROUNDHOGG_GFORMS_ASSETS_PATH', GROUNDHOGG_GFORMS_PATH . 'assets/' );
define( 'GROUNDHOGG_GFORMS_ASSETS_URL', GROUNDHOGG_GFORMS_URL . 'assets/' );

add_action( 'plugins_loaded', function (){
    load_plugin_textdomain( GROUNDHOGG_GFORMS_TEXT_DOMAIN, false, basename( dirname( __FILE__ ) ) . '/languages' );
} );

define( 'GROUNDHOGG_GFORMS_TEXT_DOMAIN', 'groundhogg-gravity' );

if ( ! version_compare( PHP_VERSION, '5.4', '>=' ) ) {
    add_action( 'admin_notices', function(){
        $message = sprintf( esc_html__( '%s requires PHP version %s+, plugin is currently NOT RUNNING.', 'groundhogg' ), GROUNDHOGG_GFORMS_NAME, '5.6' );
        $html_message = sprintf( '<div class="error">%s</div>', wpautop( $message ) );
        echo wp_kses_post( $html_message );
    } );
} elseif ( ! version_compare( get_bloginfo( 'version' ), '4.7', '>=' ) ) {
    add_action( 'admin_notices', function (){
        $message = sprintf( esc_html__( '%s requires WordPress version %s+. Because you are using an earlier version, the plugin is currently NOT RUNNING.', 'groundhogg' ), GROUNDHOGG_GFORMS_NAME, '4.9' );
        $html_message = sprintf( '<div class="error">%s</div>', wpautop( $message ) );
        echo wp_kses_post( $html_message );
    } );
} else {
    if ( did_action( 'groundhogg/loaded' ) ){
        require GROUNDHOGG_GFORMS_PATH . 'includes/plugin.php';
    } else {
        add_action( 'groundhogg/loaded', function(){
            require GROUNDHOGG_GFORMS_PATH . 'includes/plugin.php';
        } );
    }
}


if ( ! defined( '__GROUNDHOGG_ITEM_ID' ) ) define( '__GROUNDHOGG_ITEM_ID', 1814 );