<?php

namespace GroundhoggContentRestriction;

use Groundhogg\Extension;
use GroundhoggContentRestriction\Admin\Metabox;
use GroundhoggContentRestriction\Api\Content_Restriction_Api;

class Plugin extends Extension {


	/**
	 * Override the parent instance.
	 *
	 * @var Plugin
	 */
	public static $instance;

	/**
	 * Include any files.
	 *
	 * @return void
	 */
	public function includes() {
		include __DIR__ . '/functions.php';
	}

	/**
	 * Init any components that need to be added.
	 *
	 * @return void
	 */
	public function init_components() {
		if ( is_admin() ) {
			new Metabox();
		}

		new Restriction();
	}

	/**
	 * Get the ID number for the download in EDD Store
	 *
	 * @return int
	 */
	public function get_download_id() {
		return 15016;
	}

	/**
	 * Get the version #
	 *
	 * @return mixed
	 */
	public function get_version() {
		return GROUNDHOGG_CONTENT_RESTRICTION_VERSION;
	}

	/**
	 * @return string
	 */
	public function get_plugin_file() {
		return GROUNDHOGG_CONTENT_RESTRICTION__FILE__;
	}

	public function register_v4_apis( $api_manager ) {
		$api_manager->content_restriciton = new Content_Restriction_Api();
	}

	/**
	 * Register autoloader.
	 *
	 * Groundhogg autoloader loads all the classes needed to run the plugin.
	 *
	 * @since 1.6.0
	 * @access private
	 */
	protected function register_autoloader() {
		require GROUNDHOGG_CONTENT_RESTRICTION_PATH . 'includes/autoloader.php';
		Autoloader::run();
	}

	public function register_admin_scripts( $is_minified, $dot_min ) {
		wp_register_script( 'groundhogg-content-restriction-admin', GROUNDHOGG_CONTENT_RESTRICTION_ASSETS_URL . 'admin.js', [
			'groundhogg-admin-search-filters'
		] );
	}

	public function register_settings_sections( $sections ) {

		$sections['content_restriction'] = [
			'id'    => 'content_restriction',
			'title' => _x( 'Content Restriction', 'settings_sections', 'groundhogg-content-restriction' ),
			'tab'   => 'misc'
		];

		return $sections;
	}

	public function register_settings( $settings ) {

		$settings['gh_content_restriction_default_redirect'] = [
			'id'      => 'gh_content_restriction_default_redirect',
			'section' => 'content_restriction',
			'label'   => _x( 'Default Redirect URL', 'settings', 'groundhogg-content-restriction' ),
			'desc'    => _x( "The default url to redirect to if the visitor does not meet the content restriction requirements.", 'settings', 'groundhogg-pro' ),
			'type'    => 'link_picker',
			'atts'    => array(
				'name' => 'gh_content_restriction_default_redirect',
				'id'   => 'gh_content_restriction_default_redirect',
			),
		];

		return $settings;
	}
}

Plugin::instance();