<?php

namespace GroundhoggContentRestriction;


/**
 * Get the filter query for a protect post
 *
 * @param $post_id
 *
 * @return array[]
 */
function get_post_restriction_filters( $post_id ) {

	$filters = get_post_meta( $post_id, 'groundhogg_content_restriction_filters', true );

	// Not using the new filters system yet, upgrade the old logic
	if ( empty( $filters ) ) {
		$filters = upgrade_restriction_query( $post_id );
	}

	// If somehow there are no filters just pass back an empty array
	return $filters ?: [];
}

/**
 * If the restriction setup is not using filters yet, upgrade the old logic to the new filters.
 *
 * @param $post_id
 *
 * @return array[]|false
 */
function upgrade_restriction_query( $post_id ) {

	$tags         = wp_parse_id_list( get_post_meta( $post_id, 'groundhogg_content_restriction_tags', true ) );
	$relationship = get_post_meta( $post_id, 'groundhogg_content_restriction_tags_relationship', true );

	if ( empty( $tags ) || empty( $relationship ) ){
		return false;
	}

	// Filters are [ [group... [ filter... ] ] ]
	return [
		[
			[
				'type'     => 'tags',
				'tags'     => $tags,
				'compare'  => 'includes',
				'compare2' => $relationship,
			]
		]
	];
}
