(($) => {

  const { createFilters } = Groundhogg.filters.functions

  const { post, get, patch, routes, ajax } = Groundhogg.api

  const { post: thePost, rest_route } = GroundhoggContentRestriction
  const { contacts: ContactsStore } = Groundhogg.stores
  const { formatNumber, formatTime, formatDate, formatDateTime } = Groundhogg.formatting

  function json_encode_utf8_to_b64 (str) {
    return window.btoa(unescape(encodeURIComponent(JSON.stringify(str))))
  }

  const {
    dialog,
    bold
  } = Groundhogg.element

  const { sprintf, __, _x, _n } = wp.i18n
  const post_id = thePost.ID

  $(() => {

    let timeout

    const getTotal = (filters) => {
      ContactsStore.count({
        filters: json_encode_utf8_to_b64(filters),
      }).then(total => {
        $('#gh-content-restriction-total-preview').html(`<p>${sprintf(__('~%s contacts will be able to see this post.', 'groundhogg-content-restriction'), bold(formatNumber(total)))}</p>`)
      })
    }

    get(rest_route, { post_id }).then((filters) => {

      if (!Array.isArray(filters)) {
        filters = []
      }

      createFilters('#gh-content-restriction', filters, (filters) => {

        if (timeout) {
          clearTimeout(timeout)
        }

        timeout = setTimeout(() => {

          post(rest_route, {
            filters,
            post_id
          }).then(() => {
            dialog({
              message: __('Content restriction rules have been updated!', 'groundhogg-content-restriction')
            })

            getTotal(filters)
          })

        }, 3000)

      }).init()

      getTotal(filters)

    })

  })

})(jQuery)