<?php

namespace GroundhoggContentRestriction\Api;

use Groundhogg\Api\V4\Base_Api;
use function GroundhoggContentRestriction\get_post_restriction_filters;

class Content_Restriction_Api extends Base_Api {

	public function register_routes() {

		register_rest_route( self::NAME_SPACE, 'content-restriction', [
			[
				'methods'             => \WP_REST_Server::READABLE,
				'callback'            => [ $this, 'read' ],
				'permission_callback' => [ $this, 'edit_permissions_callback' ]
			],
			[
				'methods'             => \WP_REST_Server::EDITABLE,
				'callback'            => [ $this, 'edit' ],
				'permission_callback' => [ $this, 'edit_permissions_callback' ]
			],
		] );
	}

	/**
	 * Update the content restriction filters
	 *
	 * @param \WP_REST_Request $request
	 *
	 * @return mixed|null
	 */
	public function edit( \WP_REST_Request $request ) {

		$filters = $request->get_param( 'filters' );
		$post_id = absint( $request->get_param( 'post_id' ) );

		update_post_meta( $post_id, 'groundhogg_content_restriction_filters', $filters );

		return $filters;
	}

	/**
	 * Get the content restriction filters
	 */
	public function read( \WP_REST_Request $request ) {

		$post_id = absint( $request->get_param( 'post_id' ) );

		return get_post_restriction_filters( $post_id );
	}

	/**
	 * Only admins who can view contacts and edit posts can work with content restriction
	 *
	 * @return bool
	 */
	public function edit_permissions_callback() {
		return current_user_can( 'edit_posts' ) && current_user_can( 'view_contacts' );
	}
}
