<?php

namespace GroundhoggLogic;

use function Groundhogg\get_db;
use function Groundhogg\words_to_key;

class Updater extends \Groundhogg\Updater {

	/**
	 * A unique name for the updater to avoid conflicts
	 *
	 * @return string
	 */
	protected function get_updater_name() {
		return words_to_key( GROUNDHOGG_LOGIC_NAME );
	}

	/**
	 * Get a list of updates which are available.
	 *
	 * @return string[]
	 */
	protected function get_available_updates() {
		return [
			'1.2'
		];
	}

	protected function get_automatic_updates() {
		return [
			'1.2'
		];
	}

	/**
	 * Migrate conditionals to filters
	 */
	public function version_1_2() {

		get_db( 'stepmeta' )->query( [
			'_conditional_logic' => ''
		] );

	}
}