<?php

namespace GroundhoggLogic;

use Groundhogg\Admin\Admin_Menu;
use Groundhogg\DB\Manager;
use Groundhogg\Extension;

class Plugin extends Extension {


	/**
	 * Override the parent instance.
	 *
	 * @var Plugin
	 */
	public static $instance;

	/**
	 * Include any files.
	 *
	 * @return void
	 */
	public function includes() {
		require dirname( __FILE__ ) . '/functions.php';
	}

	/**
	 * Init any components that need to be added.
	 *
	 * @return void
	 */
	public function init_components() {
		$this->installer = new Installer();
		$this->updater   = new Updater();
		$this->roles     = new Roles();

		new Logic();
	}

	public function register_admin_scripts( $is_minified, $dot_min ) {
		wp_register_script( 'groundhogg-logic-admin', GROUNDHOGG_LOGIC_ASSETS_URL . 'js/logic.js', [ 'jquery' ], GROUNDHOGG_LOGIC_VERSION );
	}

	/**
	 * Register the admin styles
	 */
	public function register_admin_styles() {
		wp_register_style( 'groundhogg-logic-admin', GROUNDHOGG_LOGIC_ASSETS_URL . 'css/logic.css', [], GROUNDHOGG_LOGIC_VERSION );
	}

	/**
	 * Get the ID number for the download in EDD Store
	 *
	 * @return int
	 */
	public function get_download_id() {
		return 34308;
	}

	/**
	 * Get the version #
	 *
	 * @return mixed
	 */
	public function get_version() {
		return GROUNDHOGG_LOGIC_VERSION;
	}

	/**
	 * @return string
	 */
	public function get_plugin_file() {
		return GROUNDHOGG_LOGIC__FILE__;
	}

	/**
	 * Register autoloader.
	 *
	 * Groundhogg autoloader loads all the classes needed to run the plugin.
	 *
	 * @since 1.6.0
	 * @access private
	 */
	protected function register_autoloader() {
		require GROUNDHOGG_LOGIC_PATH . 'includes/autoloader.php';
		Autoloader::run();
	}
}

Plugin::instance();