<?php

namespace GroundhoggLogic;

use Groundhogg\Step;

/**
 * Guess the type of value and return it in a proper type.
 * Mostly for string ==> int conversions
 *
 * @param $val mixed
 *
 * @return mixed
 */
function maybe_convert_to_int( $val ) {
	if ( is_string( $val ) && is_numeric( $val ) ) {

		if ( strpos( $val, '.' ) !== false ) {
			return floatval( $val );
		}

		return intval( $val );
	}

	return $val;
}

/**
 * Get a list of steps that come after the given step.
 *
 * @param int $step_id
 *
 * @return Step[]
 */
function get_steps_after_given_id( $step_id = 0 ) {
	$given_step = new Step( $step_id );

	$steps = $given_step->get_funnel()->get_steps();

	$return_steps = [];

	foreach ( $steps as $step ) {

		if ( $step->get_group() === 'action' && $step->get_order() > $given_step->get_order() ) {
			$return_steps[] = $step;
		}

	}

	return $return_steps;
}