(() => {

  const { get } = Groundhogg.api

  Groundhogg.createStore('companies', GroundhoggCompanies.route, {
    async fetchFiles (id, opts = {}) {
      return get(`${this.route}/${id}/files`, {}, opts)
        .then(r => this.getItemsFromResponse(r))
    },
  })

  if ( ! Groundhogg.companies ){
    Groundhogg.companies = {}
  }

  Groundhogg.companyDepartments = [
    'Accounting & Finance',
    'Administration',
    'Human Resources',
    'Leadership',
    'Management',
    'Marketing',
    'Operations',
    'Production',
    'Purchasing',
    'Sales',
  ]

  Groundhogg.companies.deparments = Groundhogg.companyDepartments

  Groundhogg.companyPositions = [
    'Account Collector',
    'Account Executive',
    'Account Manager',
    'Account Representative',
    'Accountant',
    'Accounting Analyst',
    'Accounting Director',
    'Accounting Staff',
    'Accounts Payable/Receivable Clerk',
    'Actor',
    'Actuary',
    'Addiction Counselor',
    'Administrative Analyst',
    'Administrative Assistant',
    'Administrative Manager',
    'Administrative Specialist',
    'Administrator',
    'Animal Breeder',
    'Animal Control Officer',
    'Animal Shelter Board Member',
    'Animal Shelter Manager',
    'Animal Shelter Volunteer',
    'Animal Shelter Worker',
    'Animal Trainer',
    'Application Developer',
    'Architect',
    'Archivist',
    'Area Sales Manager',
    'Artificial Intelligence Engineer',
    'Artist',
    'Artistic Jobs',
    'Assistant Engineer',
    'Assistant Golf Professional',
    'Assistant Manager',
    'Assistant Professor',
    'Astronomer',
    'Atmospheric Scientist',
    'Attorney',
    'Auditing Clerk',
    'Auditor',
    'B2B Sales Specialist',
    'Bank Teller',
    'Barber',
    'Barista',
    'Beautician',
    'Bellhop',
    'Benefits Manager',
    'Biological Engineer',
    'Biologist',
    'Biostatistician',
    'Board of Directors',
    'Boilermaker',
    'Bookkeeper',
    'Branch Manager',
    'Brand Manager',
    'Brand Strategist',
    'Budget Analyst',
    'Building Inspector',
    'Bus Driver',
    'Bus Person',
    'Business Analyst',
    'Business Job Titles, Office Job Titles, and Administrative Job Titles',
    'Business Manager',
    'Business Owner Titles',
    'Cab Driver',
    'Cafeteria Worker',
    'Call Center Representative',
    'Camera Operator',
    'Caregiver',
    'Caretaker or House Sitter',
    'Carpenter',
    'Cashier',
    'Casino Host',
    'CCO - Chief Customer Officer',
    'CDO - Chief Data Officer',
    'CEO - Chief Executive Officer',
    'CFO - Chief Financial Officer',
    'CIO - Chief Information Officer',
    'CTO - Chief Technology Officer',
    'Chef',
    'Chemical Engineer',
    'Chemist',
    'Chief',
    'Chief Engineer',
    'Chief Executive Officer',
    'Chief People Officer',
    'Chief Robot Whisperer',
    'CHRO - Chief Human Resources Officer',
    'Church Volunteer',
    'Civil Engineer',
    'C-Level Jobs',
    'C-Level or C-Suite',
    'Client Service Specialist',
    'Cloud Architect',
    'CMO - Chief Marketing Officer',
    'CNA',
    'Columnist',
    'Commercial Loan Officer',
    'Communications Director',
    'Community Food Project Worker',
    'Community Volunteer Jobs',
    'Computer Animator',
    'Computer Programmer',
    'Computer Scientist',
    'Concierge',
    'Conservation Scientist',
    'Conservation Volunteer',
    'Construction Job Titles',
    'Construction Worker',
    'Content Creator',
    'Content Marketing Manager',
    'Content Strategist',
    'Continuous Improvement Consultant',
    'Continuous Improvement Lead',
    'Controller',
    'COO - Chief Operating Officer',
    'Cool Job Titles',
    'Coordinator',
    'Copy Editor',
    'Copywriter',
    'Cosmetologist',
    'Cosmetology Job Titles',
    'Counseling Business Titles',
    'Counselor',
    'Couples Counselor',
    'Courier',
    'CPO - Chief Product Officer',
    'Crane Operator',
    'Credit Authorizer',
    'Credit Counselor',
    'Cruise Director',
    'Cruise Ship Attendant',
    'Culture Operations Manager',
    'Current Title Meaning',
    'Customer Care Associate',
    'Customer Service',
    'Customer Service Job Titles',
    'Customer Service Manager',
    'Customer Support',
    'Customer Support Representative',
    'Data Analyst',
    'Data Entry',
    'Delivery Driver',
    'Dental Hygienist',
    'DevOps Engineer',
    'Digital Marketing Manager',
    'Digital Overlord',
    'Direct Salesperson',
    'Director',
    'Director of Bean Counting',
    'Director of Ethical Hacking',
    'Director of First Impressions',
    'Director of Inside Sales',
    'Director of Maintenance',
    'Director of Photography',
    'Director of Storytelling',
    'Dispatcher for Trucks or Taxis',
    'Doctor',
    'Dog Walker / Pet Sitter',
    'Drafter',
    'Driving Jobs',
    'eCommerce Marketing Specialist',
    'Economist',
    'Editor/Proofreader',
    'Electrical Engineer',
    'Electrician',
    'Emergency Relief Worker',
    'Engineer',
    'Engineering Business Titles',
    'Engineering Technician',
    'Entertainment Specialist',
    'Entrepreneur',
    'Esthetician',
    'Event Planner',
    'Events Manager',
    'Executive',
    'Executive Assistant',
    'Farm Worker',
    'Fast Food Worker',
    'File Clerk',
    'Film Critic',
    'Finance and Accounting Job Positions',
    'Finance Director',
    'Finance Manager',
    'Financial Analyst',
    'Financial Planner',
    'Financial Services Representative',
    'Flight Attendant',
    'Food Kitchen Worker',
    'Food Service Company Titles',
    'Foreman',
    'Founder',
    'Front Desk Associate',
    'Front Desk Manager',
    'Front-Line Employees',
    'Funeral Attendant',
    'Geological Engineer',
    'Geologist',
    'Ghostwriter',
    'Grant Writer',
    'Graphic Designer',
    'Group Sales',
    'Guidance Counselor',
    'Habitat for Humanity Builder',
    'Hair Stylist',
    'Handyman',
    'Head',
    'Healthcare Jobs',
    'Heavy Equipment Operator',
    'Help Desk',
    'Help Desk Worker/Desktop Support',
    'Homeless Shelter Worker',
    'Hospital Volunteer',
    'Hospitality Jobs',
    'Hotel Front Door Greeter',
    'Hotel Manager',
    'Hotel Receptionist',
    'Housekeeper',
    'Human Resources',
    'HVAC Technician',
    'Information Security Analyst',
    'Interior Designer',
    'Iron Worker',
    'IT Manager',
    'IT Professional',
    'Jobs Working With Animals',
    'Journalist',
    'Landscaping Assistant',
    'Landscaping Worker',
    'Lead',
    'Leadership Titles',
    'Library Assistant',
    'Life Coach',
    'Line Cook',
    'Locksmith',
    'Lodging Manager',
    'Machinery Operator',
    'Mail Carrier',
    'Maintenance Engineer',
    'Makeup Artist',
    'Management Consultant',
    'Manager',
    'Managers',
    'Managing Member',
    'Managing Partner',
    'Manicurist',
    'Manufacturing Assembler',
    'Market Development Manager',
    'Market Researcher',
    'Marketing Communications Manager',
    'Marketing Consultant',
    'Marketing Director',
    'Marketing Manager',
    'Marketing Research Analyst',
    'Marketing Specialist',
    'Marketing Staff',
    'Mason',
    'Massage Therapy',
    'Mathematician',
    'Meals on Wheels Driver',
    'Mechanic',
    'Mechanical Engineer',
    'Media Buyer',
    'Media Relations Coordinator',
    'Medical Administrator',
    'Medical Laboratory Tech',
    'Medical Researcher',
    'Medical Transcriptionist',
    'Meeting Planner',
    'Mental Health Counselor',
    'Mentor',
    'Merchandising Associate',
    'Mining Engineer',
    'Molecular Scientist',
    'Mortgage Loan Processor',
    'Motion Picture Director',
    'Mover',
    'Music Producer',
    'Musician',
    'Nail Technician',
    'Network Administrator',
    'Novelist/Writer',
    'Nuclear Engineer',
    'Nurse',
    'Nurse Practitioner',
    'Office Assistant',
    'Office Clerk',
    'Office Manager',
    'Office Volunteer',
    'Officer',
    'Online ESL Instructor',
    'On-the-Phone Jobs',
    'Operations Analyst',
    'Operations Assistant',
    'Operations Coordinator',
    'Operations Director',
    'Operations Job Titles',
    'Operations Manager',
    'Operations Professional',
    'Orderly',
    'Organizer',
    'Other Job Positions',
    'Outside Sales Manager',
    'Over the Phone Interpreter',
    'Overseer',
    'Owner',
    'Painter',
    'Paralegal',
    'Parking Attendant',
    'Payroll Clerk',
    'Payroll Manager',
    'Personal Assistant',
    'Personal Trainer',
    'Petroleum Engineer',
    'Pharmacist',
    'Pharmacy Assistant',
    'Phlebotomist',
    'Phone Sales Specialist',
    'Phone Survey Conductor',
    'Photographer',
    'Physical Labor Jobs',
    'Physical Therapist',
    'Physical Therapy Assistant',
    'Physicist',
    'Pipefitter',
    'Plant Engineer',
    'Playwright',
    'Plumber',
    'Political Scientist',
    'Porter',
    'Positions in a Company',
    'Preschool Teacher',
    'President',
    'Principal',
    'Product Manager',
    'Production Engineer',
    'Professor',
    'Program Administrator',
    'Program Manager',
    'Proposal Writer',
    'Proprietor',
    'Public Relations',
    'Public Relations Specialist',
    'Purchasing Staff',
    'Quality Control',
    'Quality Control Coordinator',
    'Quality Engineer',
    'Real Estate Broker',
    'Receptionist',
    'Recruiter',
    'Recyclables Collector',
    'Red Cross Volunteer',
    'Reiki Practitioner',
    'Research Assistant',
    'Researcher',
    'Researcher/Analyst Company Positions',
    'Reservationist',
    'Restaurant Chain Executive',
    'Restaurant Manager',
    'Retail Worker',
    'Risk Manager',
    'Roofer',
    'Safety Engineer',
    'Sales Analyst',
    'Sales Associate',
    'Sales Engineer',
    'Sales Job Titles',
    'Sales Manager',
    'Sales Representative',
    'Salon Manager',
    'School Bus Driver',
    'School Counselor',
    'School Volunteer',
    'Scientist Business Titles',
    'Screenwriter',
    'Scrum Master',
    'Secretary',
    'Security Guard',
    'SEO Manager',
    'Server',
    'Service Dog Trainer',
    'Shareholders',
    'Sheet Metal Worker',
    'Shelf Stocker',
    'Shipping and Receiving Staff',
    'Skin Care Specialist',
    'Social Media Assistant',
    'Social Media Specialist',
    'Social Worker',
    'Sociologist',
    'Software Engineer',
    'Software Ninjaneer',
    'Solar Photovoltaic Installer',
    'Sound Engineer',
    'Spa Manager',
    'Speech Pathologist',
    'Speechwriter',
    'Sports Volunteer',
    'SQL Developer',
    'Store Manager',
    'Substitute Teacher',
    'Suicide Hotline Volunteer',
    'Superintendent',
    'Supervisor',
    'Supervisors',
    'Taper',
    'Teacher',
    'Teacher Jobs',
    'Teaching Assistant',
    'Team Leader',
    'Technical Specialist',
    'Technical Support Specialist',
    'Technical Writer',
    'Telemarketer',
    'Telephone Operator',
    'Telework Nurse/Doctor',
    'Test Scorer',
    'Therapist',
    'Title Analyst',
    'Title Researcher',
    'Tow Truck Operator',
    'Translator',
    'Travel Agent',
    'Travel Nurse',
    'Travel Writer',
    'Truck Driver',
    'Tutor/Online Tutor',
    'UPS Driver',
    'UX Designer & UI Developer',
    'Valet',
    'Vehicle or Equipment Cleaner',
    'Veterinary Assistant',
    'Vice President of Marketing',
    'Vice President of Operations',
    'Video Editor',
    'Video Game Writer',
    'Video or Film Producer',
    'Virtual Assistant',
    'Volunteer Company Titles',
    'VP of Miscellaneous Stuff',
    'Wait Staff Manager',
    'Waiter/Waitress',
    'Warehouse Worker',
    'Web Designer',
    'Web Developer',
    'Wedding Coordinator',
    'Welder',
    'Welding',
    'Well Driller',
    'Women’s Shelter Jobs',
    'Writing Job Titles',
    'Yoga Instructor',
    'Youth Volunteer',
    'Zoologist'
  ]

  Groundhogg.companyIndustries = [
    'Accounting',
    'Agriculture',
    'Airlines/Aviation',
    'Alternative Dispute Resolution',
    'Alternative Medicine',
    'Animation',
    'Apparel & Fashion',
    'Architecture & Planning',
    'Arts & Crafts',
    'Automotive',
    'Aviation & Aerospace',
    'Banking',
    'Biotechnology',
    'Broadcast Media',
    'Building Materials',
    'Business Supplies & Equipment',
    'Capital Markets',
    'Chemicals',
    'Civic & Social Organization',
    'Civil Engineering',
    'Commercial Real Estate',
    'Computer & Network Security',
    'Computer Games',
    'Computer Hardware',
    'Computer Networking',
    'Computer Software',
    'Construction',
    'Consumer Electronics',
    'Consumer Goods',
    'Consumer Services',
    'Cosmetics',
    'Dairy',
    'Defense & Space',
    'Design',
    'Education Management',
    'E-learning',
    'Electrical & Electronic Manufacturing',
    'Entertainment',
    'Environmental Services',
    'Events Services',
    'Executive Office',
    'Facilities Services',
    'Farming',
    'Financial Services',
    'Fine Art',
    'Fishery',
    'Food & Beverages',
    'Food Production',
    'Fundraising',
    'Furniture',
    'Gambling & Casinos',
    'Glass, Ceramics & Concrete',
    'Government Administration',
    'Government Relations',
    'Graphic Design',
    'Health, Wellness & Fitness',
    'Higher Education',
    'Hospital & Health Care',
    'Hospitality',
    'Human Resources',
    'Import & Export',
    'Individual & Family Services',
    'Industrial Automation',
    'Information Services',
    'Information Technology & Services',
    'Insurance',
    'International Affairs',
    'International Trade & Development',
    'Internet',
    'Investment Banking/Venture',
    'Investment Management',
    'Judiciary',
    'Law Enforcement',
    'Law Practice',
    'Legal Services',
    'Legislative Office',
    'Leisure & Travel',
    'Libraries',
    'Logistics & Supply Chain',
    'Luxury Goods & Jewelry',
    'Machinery',
    'Management Consulting',
    'Maritime',
    'Marketing & Advertising',
    'Market Research',
    'Mechanical or Industrial Engineering',
    'Media Production',
    'Medical Device',
    'Medical Practice',
    'Mental Health Care',
    'Military',
    'Mining & Metals',
    'Motion Pictures & Film',
    'Museums & Institutions',
    'Music',
    'Nanotechnology',
    'Newspapers',
    'Nonprofit Organization Management',
    'Oil & Energy',
    'Online Publishing',
    'Outsourcing/Offshoring',
    'Package/Freight Delivery',
    'Packaging & Containers',
    'Paper & Forest Products',
    'Performing Arts',
    'Pharmaceuticals',
    'Philanthropy',
    'Photography',
    'Plastics',
    'Political Organization',
    'Primary/Secondary',
    'Printing',
    'Professional Training',
    'Program Development',
    'Public Policy',
    'Public Relations',
    'Public Safety',
    'Publishing',
    'Railroad Manufacture',
    'Ranching',
    'Real Estate',
    'Recreational',
    'Facilities & Services',
    'Religious Institutions',
    'Renewables & Environment',
    'Research',
    'Restaurants',
    'Retail',
    'Security & Investigations',
    'Semiconductors',
    'Shipbuilding',
    'Sporting Goods',
    'Sports',
    'Staffing & Recruiting',
    'Supermarkets',
    'Telecommunications',
    'Textiles',
    'Think Tanks',
    'Tobacco',
    'Translation & Localization',
    'Transportation/Trucking/Railroad',
    'Utilities',
    'Venture Capital',
    'Veterinary',
    'Warehousing',
    'Wholesale',
    'Wine & Spirits',
    'Wireless',
    'Writing & Editing'
  ]

  Groundhogg.companies.positions = Groundhogg.companyPositions


})()
