<?php
/**
 * Plugin Name:       Common Framework Plugin
 * Description:       All custom functionality for the Common Framework.
 * Version:           1.2.2
 * Requires at least: 6.0
 * Requires PHP:      8.1
 * Author:            Strategy, LLC
 * Author URI:        https://strategynewmedia.com
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       strategy
 * Domain Path:       /languages
 *
 * @package           CommonFrameworkPlugin
 */

// Useful global constants.
define( 'COMMON_FRAMEWORK_PLUGIN_VERSION', '1.2.2' );
define( 'COMMON_FRAMEWORK_PLUGIN_BASE', plugin_basename( __FILE__ ) );
define( 'COMMON_FRAMEWORK_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'COMMON_FRAMEWORK_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'COMMON_FRAMEWORK_PLUGIN_INC', COMMON_FRAMEWORK_PLUGIN_PATH . 'includes/' );
define( 'COMMON_FRAMEWORK_PLUGIN_DIST_URL', COMMON_FRAMEWORK_PLUGIN_URL . 'dist/' );
define( 'COMMON_FRAMEWORK_PLUGIN_DIST_PATH', COMMON_FRAMEWORK_PLUGIN_PATH . 'dist/' );

// Require Composer autoloader if it exists.
if ( file_exists( COMMON_FRAMEWORK_PLUGIN_PATH . 'vendor/autoload.php' ) ) {
	require_once COMMON_FRAMEWORK_PLUGIN_PATH . 'vendor/autoload.php';
}

// Include files.
require_once COMMON_FRAMEWORK_PLUGIN_INC . '/utility.php';
require_once COMMON_FRAMEWORK_PLUGIN_INC . '/core.php';

// Plugin Updates (token needs to be defined in wp-config)
if ( defined( 'STRATEGY_UPDATE_TOKEN' ) ) {
	include_once COMMON_FRAMEWORK_PLUGIN_INC . '/plugin-updater.php';
	$updater = new StrategyPluginUpdater( __FILE__ );
	$updater->init();
}

// Activation/Deactivation.
register_activation_hook( __FILE__, '\CommonFrameworkPlugin\Core\activate' );
register_deactivation_hook( __FILE__, '\CommonFrameworkPlugin\Core\deactivate' );

// Bootstrap.
CommonFrameworkPlugin\Core\setup();
