<?php
/**
 * Projects
 *
 * @package CommonFrameworkPlugin
 */

namespace CommonFrameworkPlugin;

use CommonFrameworkPlugin\CPTGenerator;

/**
 * Creates the CommonFrameworkPlugin post type and shortcodes to output them.
 */
class Projects extends \CommonFrameworkPlugin\Module {
	/**
	 * Only register if on an admin page and if fieldmanager plugin is active.
	 *
	 * @return bool
	 */
	public function can_register() {
		return true;
	}

	/**
	 * Register our hooks.
	 *
	 * @return void
	 */
	public function register() {
		add_action( 'init', [ $this, 'create_projects_custom_post_type' ], 10 );
		add_action( 'init', [ $this, 'create_custom_fields' ], 20 );

		add_filter( 'the_excerpt', [ $this, 'filter_excerpt' ] );
	}

	/**
	 * Creates the custom post type for Products.
	 *
	 * @return void
	 */
	public function create_projects_custom_post_type() {
		$cpt = new CPTGenerator();

		$fields = [
			'slug'                  => 'projects',
			'singular'              => 'Project',
			'plural'                => 'Projects',
			'menu_name'             => 'Projects',
			'description'           => 'Projects',
			'has_archive'           => true,
			'hierarchical'          => true,
			'menu_icon'             => 'dashicons-portfolio',
			'rewrite' => array(
				'slug'                  => 'projects',
				'with_front'            => false,
				'pages'                 => true,
				'feeds'                 => false,
				'ep_mask'               => EP_PERMALINK,
			),
			'menu_position'         => 23,
			'public'                => true,
			'publicly_queryable'    => true,
			'exclude_from_search'   => false,
			'show_ui'               => true,
			'show_in_menu'          => true,
			'query_var'             => true,
			'show_in_admin_bar'     => true,
			'show_in_nav_menus'     => true,
			'show_in_rest'          => true,
			'supports'              => array(
				'title',
				'editor',
				'excerpt',
				'author',
				'thumbnail',
				'custom-fields',
			),
			'custom_caps'           => false,
			'custom_caps_users'     => array(
				'administrator',
			),
		];

		$cpt->register_single_post_type( $fields );
	}

	/**
	 * Creates the custom fields for Products.
	 *
	 * @return void
	 */
	public function create_custom_fields() {
		if ( function_exists( 'acf_add_local_field_group' ) ) {
			acf_add_local_field_group(
				array(
					'key' => 'group_583c7d01bdce5',
					'title' => 'Featured Projects',
					'fields' => array(
						array(
							'key' => 'field_57a0f1622253b',
							'label' => 'Project Title',
							'name' => 'project_title',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'formatting' => 'html',
							'maxlength' => '',
						),
						array(
							'key' => 'field_57a0f1d72253d',
							'label' => 'Location',
							'name' => 'location',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'formatting' => 'html',
							'maxlength' => '',
						),
						array(
							'key' => 'field_57a0f1e32253e',
							'label' => 'Time Frame',
							'name' => 'time_frame',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'location' => array(
						array(
							array(
								'param' => 'post_type',
								'operator' => '==',
								'value' => 'projects',
							),
						),
					),
					'menu_order' => 0,
					'position' => 'side',
					'style' => 'seamless',
					'label_placement' => 'top',
					'instruction_placement' => 'label',
					'hide_on_screen' => '',
					'active' => true,
					'description' => '',
					'show_in_rest' => 1,
				)
			);
		}
	}

	/**
	 * Filters the excerpt for Projects post type.
	 *
	 * @return string The modified excerpt.
	 */
	public function filter_excerpt() {
		global $post;

		$excerpt = get_the_excerpt();

		if ( 'projects' != $post->post_type ) {
			return $excerpt;
		}

		$content = '<strong>PROJECT: </strong>' . esc_html( get_field( 'project_title', $post->ID ) ) . '<br>';

		$categories = wp_get_post_terms( $post->ID, 'product-category', array( 'fields' => 'names' ) );
		$content .= '<strong>PRODUCT TYPE: </strong>' . esc_html( implode( ', ', $categories ) ) . '<br>';

		if ( get_field( 'location', $post->ID ) ) {
			$content .= '<strong>LOCATION: </strong>' . esc_html( get_field( 'location', $post->ID ) ) . '<br>';
		}

		if ( get_field( 'time_frame', $post->ID ) ) {
			$content .= '<strong>TIME FRAME: </strong>' . esc_html( get_field( 'time_frame', $post->ID ) ) . '<br>';
		}

		$content .= '<strong>SUMMARY: </strong>' . wp_kses_post( $excerpt );

		return $content;
	}
}
