<?php
/**
 * OurProducts
 *
 * @package CommonFrameworkPlugin
 */

namespace CommonFrameworkPlugin;

use CommonFrameworkPlugin\CPTGenerator;

/**
 * Creates the CommonFrameworkPlugin post type and shortcodes to output them.
 */
class OurProducts extends \CommonFrameworkPlugin\Module {
	/**
	 * Only register if on an admin page and if fieldmanager plugin is active.
	 *
	 * @return bool
	 */
	public function can_register() {
		return true;
	}

	/**
	 * Register our hooks.
	 *
	 * @return void
	 */
	public function register() {
		add_action( 'init', [ $this, 'create_our_products_custom_post_type' ], 10 );
		add_action( 'init', [ $this, 'create_custom_fields' ], 20 );
	}

	/**
	 * Creates the custom post type for Our Products.
	 *
	 * @return void
	 */
	public function create_our_products_custom_post_type() {
		$cpt = new CPTGenerator();

		$fields = [
			'slug'                  => 'our-products',
			'singular'              => 'Our Products',
			'plural'                => 'Our Products',
			'menu_name'             => 'Our Products',
			'description'           => 'Our Products',
			'has_archive'           => false,
			'hierarchical'          => true,
			'menu_icon'             => 'dashicons-products',
			'rewrite' => array(
				'slug'                  => 'our-products',
				'with_front'            => false,
				'pages'                 => true,
				'feeds'                 => false,
				'ep_mask'               => EP_PERMALINK,
			),
			'menu_position'         => 23,
			'public'                => true,
			'publicly_queryable'    => true,
			'exclude_from_search'   => false,
			'show_ui'               => true,
			'show_in_menu'          => true,
			'query_var'             => true,
			'show_in_admin_bar'     => true,
			'show_in_nav_menus'     => true,
			'supports'              => array(
				'title',
				'editor',
				'excerpt',
				'author',
				'thumbnail',
				'custom-fields',
				'page-attributes',
			),
			'custom_caps'           => false,
			'custom_caps_users'     => array(
				'administrator',
			),
			'taxonomies'            => array(
				array(
					'taxonomy'          => 'our-product-category',
					'plural'            => 'Product Categories',
					'single'            => 'Product Category',
					'post_types'        => array( 'our-products' ),
					'public'             => true,
					'publicly_queryable' => true,
					'hierarchical'       => true,
					'show_ui'            => true,
					'show_admin_column'  => true,
					'has_archive'        => true,
					'query_var'          => true,
					'show_in_nav_menus'  => true,
					'rewrite'            => array(
						'slug' => 'our-product-category',
						'hierarchical' => true,
						'with_front'   => false,
						'ep_mask'      => EP_PERMALINK,
					),
				),
			),
		];

		$cpt->register_single_post_type( $fields );
	}

	/**
	 * Creates the custom fields for Our Products.
	 *
	 * @return void
	 */
	public function create_custom_fields() {
		if ( function_exists( 'acf_add_local_field_group' ) ) {
			acf_add_local_field_group(
				array(
					'key' => 'group_64515c5b7b1c3',
					'title' => 'Our Products',
					'fields' => array(
						array(
							'key' => 'field_64515c5b740bb',
							'label' => 'Product Specification',
							'name' => '',
							'aria-label' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
							'selected' => 0,
						),
						array(
							'key' => 'field_64515e29740bc',
							'label' => 'Electronic Features',
							'name' => 'electronic_features',
							'aria-label' => '',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'layout' => 'table',
							'pagination' => 0,
							'min' => 0,
							'max' => 0,
							'collapsed' => '',
							'button_label' => 'Add Row',
							'rows_per_page' => 20,
							'sub_fields' => array(
								array(
									'key' => 'field_64515f93740be',
									'label' => 'Name',
									'name' => 'name',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_64515e29740bc',
								),
								array(
									'key' => 'field_64515fa0740bf',
									'label' => 'Specification',
									'name' => 'specification',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_64515e29740bc',
								),
							),
						),
						array(
							'key' => 'field_64516111d76cd',
							'label' => 'Cooling Capacity',
							'name' => 'cooling_capacity',
							'aria-label' => '',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'layout' => 'table',
							'pagination' => 0,
							'min' => 0,
							'max' => 0,
							'collapsed' => '',
							'button_label' => 'Add Row',
							'rows_per_page' => 20,
							'sub_fields' => array(
								array(
									'key' => 'field_64516126d76ce',
									'label' => 'Name',
									'name' => 'name',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_64516111d76cd',
								),
								array(
									'key' => 'field_64516131d76cf',
									'label' => 'Specification',
									'name' => 'specification',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_64516111d76cd',
								),
							),
						),
						array(
							'key' => 'field_64516147d76d0',
							'label' => 'Electrical Characteristics',
							'name' => 'electrical_characteristics',
							'aria-label' => '',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'layout' => 'table',
							'pagination' => 0,
							'min' => 0,
							'max' => 0,
							'collapsed' => '',
							'button_label' => 'Add Row',
							'rows_per_page' => 20,
							'sub_fields' => array(
								array(
									'key' => 'field_64516154d76d1',
									'label' => 'Name',
									'name' => 'name',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_64516147d76d0',
								),
								array(
									'key' => 'field_64516165d76d2',
									'label' => 'Specification',
									'name' => 'specification',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_64516147d76d0',
								),
							),
						),
						array(
							'key' => 'field_64516170d76d3',
							'label' => 'Fans',
							'name' => 'fans',
							'aria-label' => '',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'layout' => 'table',
							'pagination' => 0,
							'min' => 0,
							'max' => 0,
							'collapsed' => '',
							'button_label' => 'Add Row',
							'rows_per_page' => 20,
							'sub_fields' => array(
								array(
									'key' => 'field_64516170d76d4',
									'label' => 'Name',
									'name' => 'name',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_64516170d76d3',
								),
								array(
									'key' => 'field_64516170d76d5',
									'label' => 'Specification',
									'name' => 'specification',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_64516170d76d3',
								),
							),
						),
						array(
							'key' => 'field_6451617ed76d6',
							'label' => 'Evaporator',
							'name' => 'evaporator',
							'aria-label' => '',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'layout' => 'table',
							'pagination' => 0,
							'min' => 0,
							'max' => 0,
							'collapsed' => '',
							'button_label' => 'Add Row',
							'rows_per_page' => 20,
							'sub_fields' => array(
								array(
									'key' => 'field_6451617ed76d7',
									'label' => 'Name',
									'name' => 'name',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_6451617ed76d6',
								),
								array(
									'key' => 'field_6451617ed76d8',
									'label' => 'Specification',
									'name' => 'specification',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_6451617ed76d6',
								),
							),
						),
						array(
							'key' => 'field_64516191d76da',
							'label' => 'Condensor',
							'name' => 'condensor',
							'aria-label' => '',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'layout' => 'table',
							'pagination' => 0,
							'min' => 0,
							'max' => 0,
							'collapsed' => '',
							'button_label' => 'Add Row',
							'rows_per_page' => 20,
							'sub_fields' => array(
								array(
									'key' => 'field_64516191d76db',
									'label' => 'Name',
									'name' => 'name',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_64516191d76da',
								),
								array(
									'key' => 'field_64516191d76dc',
									'label' => 'Specification',
									'name' => 'specification',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_64516191d76da',
								),
							),
						),
						array(
							'key' => 'field_6451619cd76dd',
							'label' => 'Compressor',
							'name' => 'compressor',
							'aria-label' => '',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'layout' => 'table',
							'pagination' => 0,
							'min' => 0,
							'max' => 0,
							'collapsed' => '',
							'button_label' => 'Add Row',
							'rows_per_page' => 20,
							'sub_fields' => array(
								array(
									'key' => 'field_6451619cd76de',
									'label' => 'Name',
									'name' => 'name',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_6451619cd76dd',
								),
								array(
									'key' => 'field_6451619cd76df',
									'label' => 'Specification',
									'name' => 'specification',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_6451619cd76dd',
								),
							),
						),
						array(
							'key' => 'field_645161a7d76e0',
							'label' => 'Refrigerant',
							'name' => 'refrigerant',
							'aria-label' => '',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'layout' => 'table',
							'pagination' => 0,
							'min' => 0,
							'max' => 0,
							'collapsed' => '',
							'button_label' => 'Add Row',
							'rows_per_page' => 20,
							'sub_fields' => array(
								array(
									'key' => 'field_645161a7d76e1',
									'label' => 'Name',
									'name' => 'name',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_645161a7d76e0',
								),
								array(
									'key' => 'field_645161a7d76e2',
									'label' => 'Specification',
									'name' => 'specification',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_645161a7d76e0',
								),
							),
						),
						array(
							'key' => 'field_645161b0d76e3',
							'label' => 'Dimensions',
							'name' => 'dimensions',
							'aria-label' => '',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'layout' => 'table',
							'pagination' => 0,
							'min' => 0,
							'max' => 0,
							'collapsed' => '',
							'button_label' => 'Add Row',
							'rows_per_page' => 20,
							'sub_fields' => array(
								array(
									'key' => 'field_645161b0d76e4',
									'label' => 'Name',
									'name' => 'name',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_645161b0d76e3',
								),
								array(
									'key' => 'field_645161b0d76e5',
									'label' => 'Specification',
									'name' => 'specification',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_645161b0d76e3',
								),
							),
						),
						array(
							'key' => 'field_645161bbd76e6',
							'label' => 'Weight',
							'name' => 'weight',
							'aria-label' => '',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'layout' => 'table',
							'pagination' => 0,
							'min' => 0,
							'max' => 0,
							'collapsed' => '',
							'button_label' => 'Add Row',
							'rows_per_page' => 20,
							'sub_fields' => array(
								array(
									'key' => 'field_645161bbd76e7',
									'label' => 'Name',
									'name' => 'name',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_645161bbd76e6',
								),
								array(
									'key' => 'field_645161bbd76e8',
									'label' => 'Specification',
									'name' => 'specification',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_645161bbd76e6',
								),
							),
						),
						array(
							'key' => 'field_645161c5d76e9',
							'label' => 'Power Cord',
							'name' => 'power_cord',
							'aria-label' => '',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'layout' => 'table',
							'pagination' => 0,
							'min' => 0,
							'max' => 0,
							'collapsed' => '',
							'button_label' => 'Add Row',
							'rows_per_page' => 20,
							'sub_fields' => array(
								array(
									'key' => 'field_645161c5d76ea',
									'label' => 'Name',
									'name' => 'name',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_645161c5d76e9',
								),
								array(
									'key' => 'field_645161c5d76eb',
									'label' => 'Specification',
									'name' => 'specification',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_645161c5d76e9',
								),
							),
						),
						array(
							'key' => 'field_645161d7d76ed',
							'label' => 'Condensate Tank',
							'name' => 'condensate_tank',
							'aria-label' => '',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'layout' => 'table',
							'pagination' => 0,
							'min' => 0,
							'max' => 0,
							'collapsed' => '',
							'button_label' => 'Add Row',
							'rows_per_page' => 20,
							'sub_fields' => array(
								array(
									'key' => 'field_645161d7d76ee',
									'label' => 'Name',
									'name' => 'name',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_645161d7d76ed',
								),
								array(
									'key' => 'field_645161d7d76ef',
									'label' => 'Specification',
									'name' => 'specification',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_645161d7d76ed',
								),
							),
						),
						array(
							'key' => 'field_645161ecd76f1',
							'label' => 'Operating Conditions',
							'name' => 'operating_conditions',
							'aria-label' => '',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'layout' => 'table',
							'pagination' => 0,
							'min' => 0,
							'max' => 0,
							'collapsed' => '',
							'button_label' => 'Add Row',
							'rows_per_page' => 20,
							'sub_fields' => array(
								array(
									'key' => 'field_645161ecd76f2',
									'label' => 'Name',
									'name' => 'name',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_645161ecd76f1',
								),
								array(
									'key' => 'field_645161ecd76f3',
									'label' => 'Specification',
									'name' => 'specification',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_645161ecd76f1',
								),
							),
						),
						array(
							'key' => 'field_64516205d76f5',
							'label' => 'Max. Duct Length',
							'name' => 'max_duct_length',
							'aria-label' => '',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'layout' => 'table',
							'pagination' => 0,
							'min' => 0,
							'max' => 0,
							'collapsed' => '',
							'button_label' => 'Add Row',
							'rows_per_page' => 20,
							'sub_fields' => array(
								array(
									'key' => 'field_64516205d76f6',
									'label' => 'Name',
									'name' => 'name',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_64516205d76f5',
								),
								array(
									'key' => 'field_64516205d76f7',
									'label' => 'Specification',
									'name' => 'specification',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_64516205d76f5',
								),
							),
						),
						array(
							'key' => 'field_64516213d76f8',
							'label' => 'Max. Sound Level',
							'name' => 'max_sound_level',
							'aria-label' => '',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'layout' => 'table',
							'pagination' => 0,
							'min' => 0,
							'max' => 0,
							'collapsed' => '',
							'button_label' => 'Add Row',
							'rows_per_page' => 20,
							'sub_fields' => array(
								array(
									'key' => 'field_64516213d76f9',
									'label' => 'Name',
									'name' => 'name',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_64516213d76f8',
								),
								array(
									'key' => 'field_64516213d76fa',
									'label' => 'Specification',
									'name' => 'specification',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_64516213d76f8',
								),
							),
						),
						array(
							'key' => 'field_64516228d76fc',
							'label' => 'Product Accessories',
							'name' => '',
							'aria-label' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
							'selected' => 0,
						),
						array(
							'key' => 'field_64516259d76fd',
							'label' => 'Unit Image',
							'name' => 'unit_image',
							'aria-label' => '',
							'type' => 'image',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'array',
							'library' => 'all',
							'min_width' => '',
							'min_height' => '',
							'min_size' => '',
							'max_width' => '',
							'max_height' => '',
							'max_size' => '',
							'mime_types' => '',
							'preview_size' => 'medium',
						),
						array(
							'key' => 'field_64516292d76fe',
							'label' => 'Product Accessories Table',
							'name' => 'product_accessories_table',
							'aria-label' => '',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'layout' => 'table',
							'pagination' => 0,
							'min' => 0,
							'max' => 0,
							'collapsed' => '',
							'button_label' => 'Add Row',
							'rows_per_page' => 20,
							'sub_fields' => array(
								array(
									'key' => 'field_645162b3d76ff',
									'label' => 'Images/Videos',
									'name' => 'imagesvideos',
									'aria-label' => '',
									'type' => 'oembed',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'width' => '',
									'height' => '',
									'parent_repeater' => 'field_64516292d76fe',
								),
								array(
									'key' => 'field_645162fed7700',
									'label' => 'Callout No.',
									'name' => 'callout_no',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_64516292d76fe',
								),
								array(
									'key' => 'field_64516307d7701',
									'label' => 'Part No.',
									'name' => 'part_no',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_64516292d76fe',
								),
								array(
									'key' => 'field_6451630fd7702',
									'label' => 'Item',
									'name' => 'item',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_64516292d76fe',
								),
								array(
									'key' => 'field_64516316d7703',
									'label' => 'Description',
									'name' => 'description',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_64516292d76fe',
								),
							),
						),
						array(
							'key' => 'field_6451632cd7704',
							'label' => 'Downloads',
							'name' => '',
							'aria-label' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
							'selected' => 0,
						),
						array(
							'key' => 'field_64516337d7705',
							'label' => 'Downloads Table',
							'name' => 'downloads_table',
							'aria-label' => '',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'layout' => 'table',
							'pagination' => 0,
							'min' => 0,
							'max' => 0,
							'collapsed' => '',
							'button_label' => 'Add Row',
							'rows_per_page' => 20,
							'sub_fields' => array(
								array(
									'key' => 'field_6451634dd7706',
									'label' => 'Download File',
									'name' => 'download_file',
									'aria-label' => '',
									'type' => 'file',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'url',
									'library' => 'all',
									'min_size' => '',
									'max_size' => '',
									'mime_types' => '',
									'parent_repeater' => 'field_64516337d7705',
								),
								array(
									'key' => 'field_64516365d7707',
									'label' => 'Download Category',
									'name' => 'download_category',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_64516337d7705',
								),
								array(
									'key' => 'field_6451636ed7708',
									'label' => 'Download Title',
									'name' => 'download_title',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'maxlength' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'parent_repeater' => 'field_64516337d7705',
								),
							),
						),
					),
					'location' => array(
						array(
							array(
								'param' => 'post_type',
								'operator' => '==',
								'value' => 'our-products',
							),
						),
					),
					'menu_order' => 0,
					'position' => 'normal',
					'style' => 'default',
					'label_placement' => 'top',
					'instruction_placement' => 'label',
					'hide_on_screen' => '',
					'active' => true,
					'description' => '',
					'show_in_rest' => 1,
				)
			);

			acf_add_local_field_group(
				array(
					'key' => 'group_64515b9bd8613',
					'title' => 'Our Product Categories',
					'fields' => array(
						array(
							'key' => 'field_64515b9c5753f',
							'label' => 'Page Title',
							'name' => 'page_title',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'maxlength' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
						),
						array(
							'key' => 'field_64515bb357540',
							'label' => 'Description',
							'name' => 'description',
							'aria-label' => '',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 0,
						),
						array(
							'key' => 'field_64515bb957541',
							'label' => 'Featured Image',
							'name' => 'featured_image',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'maxlength' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
						),
					),
					'location' => array(
						array(
							array(
								'param' => 'taxonomy',
								'operator' => '==',
								'value' => 'our-product-category',
							),
						),
					),
					'menu_order' => 0,
					'position' => 'normal',
					'style' => 'default',
					'label_placement' => 'top',
					'instruction_placement' => 'label',
					'hide_on_screen' => '',
					'active' => true,
					'description' => '',
					'show_in_rest' => 1,
				)
			);
		}
	}
}
