# Common Framework Plugin

## Product Filter Setup
To setup the product filter page and the associated facets, please follow these steps:

1. If this is the first time it is being setup, you will need to edit several of the special facets so that they are ignored by the "all facets" shortcode:
    1. product_categories >> pf_spec_product_categories
    2. product_name >> pf_spec_product_name
    3. product_search >> pf_spec_product_search
    4. pagination >> pf_spec_pagination
    5. reset >> pf_spec_reset

2. Make sure that the product-filter page and popup have been edited in Elementor to reflect the above changes to the shortcodes.

3. Broadcast the product-filter page to all subsites.

4. Make sure that the Products ACF field group is synced with the top-level site on all subsites.

5. In the site tools (multisite network admin), run the Product Facet Broadcast option. This will save all facets that are prepended with "pf_" into JSON template files. These files are used to programmatically create facets on the subsites.

6. Re-index FacetWP on all subsites.

7. Check the product-filter page on each subsite. If the styles seem different from what is on the top-level site, regenerate the Elementor styles in <b>Elementor</b> > <b>Tools</b>.

Once these steps have been completed, maintenance should only consist of running imports and regenerating facet templates whenever necessary. The majority of manual labor should be eliminated from the process.

## Other Notes
- When creating new modules within the scaffold, the class name **MUST** be the same as the file name (excluding the file extension)
	- **Bad**:
		- **Filename**: email.php
		- **Class**: EmailHandler
	- **Good**:
		- **Filename**: EmailHandler.php
		- **Class**: EmailHandler
