<?php
/**
 * Common Framework Quick Tools Page
 *
 * This PHP file provides a series of quick tools for managing product reports
 * and other administrative tasks within the WordPress framework. It is designed
 * to allow users to generate various reports related to products, manage XML
 * imports, clean up data, and execute specific actions such as clearing caches
 * or flushing styles.
 *
 * Note: Access to this file is restricted to WordPress to prevent direct access.
 *
 * @package    CommonFramework
 * @subpackage QuickTools
 * @version    1.0
 * @author     [Your Name]
 * @license    MIT License
 *
 * Actions Provided:
 * - Generate reports for products that have never been in the XML feed.
 * - Generate reports for products that have been in the XML feed.
 * - Import new XML files manually.
 * - Clean duplicate products from the list.
 * - Clear and preload WP Rocket cache for all sites in the network.
 * - Broadcast settings across the network.
 * - Flush Elementor styles for all sites.
 * - Create dynamic PDFs for buyer's guides.
 *
 * Usage:
 * Users can trigger these actions through the forms provided on this page,
 * which post to the `admin-post.php` file for handling.
 */

?>

<h1>Common Framework Quick Tools</h1>

<!-- <p>Generates a report of all the products that have never been in the XML feed.</p>
<form action="<?php echo esc_url( get_admin_url( 1, 'admin-post.php' ) ); ?>" method="POST">
	<input type="submit" name="exportsubmitnotid" value="Outside XML Products Report">
	<input type="hidden" name="action" value="not_vertiv_products_report">
</form>

<p>Generates a report of all products that contain a product id. These are all the products that have ever been in the XML feed.</p>
<form action="<?php echo esc_url( get_admin_url( 1, 'admin-post.php' ) ); ?>" method="POST">
	<input type="submit" name="exportsubmitid" value="XML Feed Products Report">
	<input type="hidden" name="action" value="vertiv_products_report">
</form>

<p>Generates a report of all the products and their url.</p>
<form action="<?php echo esc_url( get_admin_url( 1, 'admin-post.php' ) ); ?>" method="POST">
	<input type="submit" name="getproductpostsurl" value="All Products Report">
	<input type="hidden" name="action" value="all_products_report">
</form>

<p>Generates a report of all the products with a focus keyword.</p>
<form action="<?php echo esc_url( get_admin_url( 1, 'admin-post.php' ) ); ?>" method="POST">
	<input type="submit" name="exportfocuskeyword" value="Focus Keyword Report">
	<input type="hidden" name="action" value="focus_keyword_products_report">
</form>

<p>Generates a report of every child product detailing which product is their parent.</p>
<form action="<?php echo esc_url( get_admin_url( 1, 'admin-post.php' ) ); ?>" method="POST">
	<input type="submit" name="prodchild_report" value="Get Child Products">
	<input type="hidden" name="action" value="child_products_report">
</form>

<p>Generates a report of products that have been updated in the last two weeks.</p>
<form action="<?php echo esc_url( get_admin_url( 1, 'admin-post.php' ) ); ?>" method="POST">
	<input type="submit" name="importsubmitnewupdate" value="Product Report - Two Weeks">
	<input type="hidden" name="action" value="updated_products_two_weeks_report">
</form>

<p>Generates a report of products that have been created in the last month.</p>
<form action="<?php echo esc_url( get_admin_url( 1, 'admin-post.php' ) ); ?>" method="POST">
	<input type="submit" name="importsubmitnewcreate" value="Product Report - Last Month">
	<input type="hidden" name="action" value="new_products_last_month_report">
</form>

<p>Generates a report of every product's child products and compare with the child products that are shown for the product in the xml files.</p>
<form action="<?php echo esc_url( get_admin_url( 1, 'admin-post.php' ) ); ?>" method="POST">
	<input type="submit" name="matchingchildprod" value="Matching Child Products">
	<input type="hidden" name="action" value="matching_child_products_report">
</form>

<p>Generates a report of all new products that are not on VF.</p>
<form action="<?php echo esc_url( get_admin_url( 1, 'admin-post.php' ) ); ?>" method="POST">
	<input type="submit" name="getnewproducts" value="New Products Report">
	<input type="hidden" name="action" value="all_unsynced_products_report">
</form> -->

<?php if ( 'https://commonframework.us' === home_url() ) { ?>
	<p>Manually import new xml files.</p>
	<form action="<?php echo esc_url( get_admin_url( 1, 'admin-post.php' ) ); ?>" method="POST">
		<input type="submit" name="importnewxmlfiles" value="Import New XML Files">
		<input type="hidden" name="action" value="import_vertiv_products">
	</form>
	<p>Manually run the cron job.</p>
	<form action="<?php echo esc_url( get_admin_url( 1, 'admin-post.php' ) ); ?>" method="POST">
		<input type="submit" name="cronjobreport" value="Do Cron Job">
		<input type="hidden" name="action" value="cron_job_report">
	</form>
	<p>Save the Product FacetWP settings so that they can be broadcast to every website in the network.</p>
	<form action="<?php echo esc_url( get_admin_url( 1, 'admin-post.php' ) ); ?>" method="POST">
		<input type="submit" name="broadcastproductfacets" value="Broadcast Product Facets">
		<input type="hidden" name="action" value="broadcast_product_facets">
	</form>
<?php } ?>

<p>Create Buyer's Guides</p>
<form action="<?php echo esc_url( get_admin_url( 1, 'admin-post.php' ) ); ?>" method="POST">
	<input type="submit" name="create_dynamic_pdfs" value="Create Dynamic PDF">
	<input type="hidden" name="action" value="create_dynamic_pdfs">
</form>

<p>Generate Lead Magnets</p>
<form action="<?php echo esc_url( get_admin_url( 1, 'admin-post.php' ) ); ?>" method="POST">
	<input type="submit" name="generate_lead_magnets" value="Generate Lead Magnets">
	<input type="hidden" name="action" value="generate_lead_magnets">
</form>

<p>Clean duplicate products from the products list.<p>
<form action="<?php echo esc_url( get_admin_url( 1, 'admin-post.php' ) ); ?>" method="POST">
	<input type="submit" name="cleanduplicates" value="Clean Duplicates">
	<input type="hidden" name="action" value="clean_duplicates">
</form>

<p>Clear the WP Rocket cache.</p>
<form action="<?php echo esc_url( get_admin_url( 1, 'admin-post.php' ) ); ?>" method="POST">
	<input type="submit" name="cleancachewprocket" value="Clear All Caches">
	<input type="hidden" name="action" value="clean_cache_wp_rocket">
</form>

<p>Preload the WP Rocket cache.</p>
<form action="<?php echo esc_url( get_admin_url( 1, 'admin-post.php' ) ); ?>" method="POST">
	<input type="submit" name="preloadcacheswprocket" value="Preload All Caches">
	<input type="hidden" name="action" value="preload_caches_wp_rocket">
</form>

<p>Flush Elementor styles.</p>
<form action="<?php echo esc_url( get_admin_url( 1, 'admin-post.php' ) ); ?>" method="POST">
	<input type="submit" name="flushelementorstyles" value="Flush Elementor Styles">
	<input type="hidden" name="action" value="flush_elementor_styles">
</form>
