<?php
/**
 * Videos
 *
 * @package CommonFrameworkPlugin
 */

namespace CommonFrameworkPlugin;

use CommonFrameworkPlugin\CPTGenerator;

/**
 * Creates the CommonFrameworkPlugin post type and shortcodes to output them.
 */
class Videos extends \CommonFrameworkPlugin\Module {
	/**
	 * Only register if on an admin page and if fieldmanager plugin is active.
	 *
	 * @return bool
	 */
	public function can_register() {
		return true;
	}

	/**
	 * Register our hooks.
	 *
	 * @return void
	 */
	public function register() {
		add_action( 'init', [ $this, 'create_video_custom_post_type' ] );
	}

	/**
	 * Creates the custom post type for Our Products.
	 *
	 * @return void
	 */
	public function create_video_custom_post_type() {
		$cpt = new CPTGenerator();

		$fields = [
			'slug'                  => 'video',
			'singular'              => 'Video',
			'plural'                => 'Videos',
			'menu_name'             => 'Videos',
			'description'           => 'Videos',
			'has_archive'           => true,
			'hierarchical'          => true,
			'menu_icon'             => 'dashicons-editor-video',
			'rewrite' => array(
				'slug'                  => 'video',
				'with_front'            => false,
				'pages'                 => true,
				'feeds'                 => false,
				'ep_mask'               => EP_PERMALINK,
			),
			'menu_position'         => 25,
			'public'                => true,
			'publicly_queryable'    => true,
			'exclude_from_search'   => false,
			'show_ui'               => true,
			'show_in_menu'          => true,
			'query_var'             => true,
			'show_in_admin_bar'     => true,
			'show_in_nav_menus'     => true,
			'show_in_rest'          => true,
			'supports'              => array(
				'title',
				'editor',
				'excerpt',
				'author',
				'thumbnail',
				'custom-fields',
			),
			'custom_caps'           => false,
			'custom_caps_users'     => array(
				'administrator',
			),
			'taxonomies'            => array(
				array(
					'taxonomy'          => 'video-category',
					'plural'            => 'Categories',
					'single'            => 'Category',
					'post_types'        => array( 'video' ),
					'show_admin_column' => true,
					'show_in_rest'      => true,
					'hierarchical'      => true,
					'rewrite'           => true,
				),
			),
		];

		$cpt->register_single_post_type( $fields );
	}
}
