<?php
/**
 * Products
 *
 * @package CommonFrameworkPlugin
 */

namespace CommonFrameworkPlugin;

use CommonFrameworkPlugin\CPTGenerator;
use FacetWP;
use WP_Query;

/**
 * Creates the CommonFrameworkPlugin post type and shortcodes to output them.
 */
class Products extends \CommonFrameworkPlugin\Module {
	/**
	 * Only register if on an admin page and if fieldmanager plugin is active.
	 *
	 * @return bool
	 */
	public function can_register() {
		return true;
	}

	/**
	 * Register our hooks.
	 *
	 * @return void
	 */
	public function register() {
		add_action( 'init', [ $this, 'create_products_custom_post_type' ], 10 );
		add_action( 'init', [ $this, 'create_custom_fields' ], 20 );

		add_action( 'wp_footer', [ $this, 'facet_accordion_script' ], 100 );
		add_action( 'wp_head', [ $this, 'add_schemas' ] );
		add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_styles' ], 1 );
		add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_scripts' ], 1 );

		add_shortcode( 'all_product_facets', [ $this, 'all_product_facets_shortcode' ] );
		add_shortcode( 'display_all_products', [ $this, 'display_all_products_shortcode' ] );
		add_shortcode( 'product_accordions', [ $this, 'product_accordions_shortcode' ] );
		add_shortcode( 'product_images', [ $this, 'product_image_slider_shortcode' ] );

		add_filter( 'facetwp_filtered_post_ids', [ $this, 'put_featured_products_first' ], 15, 2 );
		add_filter( 'broadcast_queue_clean_queue', '__return_false' );
		add_filter( 'the_content', [ $this, 'add_discontinued_badge' ] );
		add_filter( 'wpseo_title', [ $this, 'add_discontinued_to_yoast_title' ] );
		add_filter( 'wpseo_opengraph_title', [ $this, 'add_discontinued_to_yoast_title' ] );
		add_filter( 'wpseo_twitter_title', [ $this, 'add_discontinued_to_yoast_title' ] );
		add_filter( 'wpseo_metadesc', [ $this, 'custom_meta' ], PHP_INT_MAX );
		add_filter( 'wpseo_title', [ $this, 'add_discontinued_to_yoast_title' ] );
		add_filter( 'wpseo_opengraph_title', [ $this, 'add_discontinued_to_yoast_title' ] );
		add_filter( 'wpseo_twitter_title', [ $this, 'add_discontinued_to_yoast_title' ] );

		add_filter( 'manage_products_posts_columns', [ $this, 'manage_products_columns' ] );
		add_action( 'manage_products_posts_custom_column', [ $this, 'manage_products_custom_column' ], 10, 2 );
		add_filter( 'manage_edit-products_sortable_columns', [ $this, 'manage_sortable_columns' ] );
		add_action( 'pre_get_posts', [ $this, 'manage_posts_orderby' ] );
	}

	/**
	 * Creates the custom post type for Products.
	 *
	 * @return void
	 */
	public function create_products_custom_post_type() {
		$cpt = new CPTGenerator();

		$fields = [
			'slug'                  => 'products',
			'singular'              => 'Product',
			'plural'                => 'Products',
			'menu_name'             => 'Products',
			'description'           => 'Products',
			'has_archive'           => false,
			'hierarchical'          => false,
			'menu_icon'             => 'dashicons-tag',
			'rewrite' => array(
				'slug'                  => 'products',
				'with_front'            => false,
				'pages'                 => true,
				'feeds'                 => false,
				'ep_mask'               => EP_PERMALINK,
			),
			'menu_position'         => 21,
			'public'                => true,
			'publicly_queryable'    => true,
			'exclude_from_search'   => false,
			'show_ui'               => true,
			'show_in_menu'          => true,
			'show_in_rest'          => true,
			'query_var'             => true,
			'show_in_admin_bar'     => true,
			'show_in_nav_menus'     => true,
			'supports'              => array(
				'title',
				'editor',
				'excerpt',
				'author',
				'thumbnail',
				'custom-fields',
				'revisions',
			),
			'custom_caps'           => true,
			'custom_caps_users'     => array(
				'administrator',
			),
			'taxonomies'            => array(
				// Register "product-category" Taxonomy
				array(
					'taxonomy'          => 'product-category',
					'plural'            => 'Product Categories',
					'single'            => 'Product Category',
					'post_types'        => array( 'products', 'projects' ),
					'public'             => true,
					'publicly_queryable' => true,
					'hierarchical'       => true,
					'show_ui'            => true,
					'show_admin_column'  => true,
					'has_archive'        => true,
					'query_var'          => true,
					'show_in_nav_menus'  => true,
					'show_in_rest'       => true,
					'rewrite'            => array(
						'slug' => 'product-category',
						'hierarchical' => true,
						'with_front'   => false,
						'ep_mask'      => EP_PERMALINK,
					),
				),
			),
		];

		$cpt->register_single_post_type( $fields );
	}

	/**
	 * Creates custom fields for the Products post type.
	 *
	 * @return void
	 */
	public function create_custom_fields() {
		if ( function_exists( 'acf_add_local_field_group' ) ) {
			acf_add_local_field_group(
				array(
					'key' => 'group_5bc78852f086e',
					'title' => 'Product Categories',
					'fields' => array(
						array(
							'key' => 'field_62cf385480a1a',
							'label' => 'Page Title',
							'name' => 'page_title',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_5c828a9c92997',
							'label' => 'Description',
							'name' => 'description',
							'aria-label' => '',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 0,
						),
						array(
							'key' => 'field_62cf41fa2a395',
							'label' => 'Additional Line Items',
							'name' => 'additional_line_items',
							'aria-label' => '',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 0,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Row',
							'sub_fields' => array(
								array(
									'key' => 'field_62cf42292a396',
									'label' => 'Title',
									'name' => 'title',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
									'parent_repeater' => 'field_62cf41fa2a395',
								),
								array(
									'key' => 'field_62cf423a2a397',
									'label' => 'Image Source',
									'name' => 'image_source',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
									'parent_repeater' => 'field_62cf41fa2a395',
								),
								array(
									'key' => 'field_62cf42682a399',
									'label' => 'Description',
									'name' => 'description',
									'aria-label' => '',
									'type' => 'textarea',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => '',
									'new_lines' => '',
									'parent_repeater' => 'field_62cf41fa2a395',
								),
								array(
									'key' => 'field_62cf6627c39cc',
									'label' => 'External Link',
									'name' => 'external_link',
									'aria-label' => '',
									'type' => 'true_false',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'message' => '',
									'default_value' => 0,
									'ui' => 1,
									'ui_on_text' => '',
									'ui_off_text' => '',
									'parent_repeater' => 'field_62cf41fa2a395',
								),
								array(
									'key' => 'field_62cf43f33a2c5',
									'label' => 'Link',
									'name' => 'link',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
									'parent_repeater' => 'field_62cf41fa2a395',
								),
							),
							'rows_per_page' => 20,
						),
						array(
							'key' => 'field_62cf394780a1b',
							'label' => 'Additional Content',
							'name' => 'additional_item_content',
							'aria-label' => '',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 0,
						),
						array(
							'key' => 'field_5bc78862a7308',
							'label' => 'Featured Image',
							'name' => 'featured_image',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => 'Place the image file name here',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_5bc78876a7309',
							'label' => 'Excerpt',
							'name' => 'excerpt',
							'aria-label' => '',
							'type' => 'wysiwyg',
							'instructions' => 'Shown on other pages or in site search.',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'tabs' => 'all',
							'toolbar' => 'basic',
							'media_upload' => 1,
							'delay' => 0,
						),
						array(
							'key' => 'field_5bc7896bc0701',
							'label' => 'Featured Products',
							'name' => 'featured_products',
							'aria-label' => '',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 0,
							'max' => 0,
							'layout' => 'table',
							'button_label' => 'Add Featured Product',
							'sub_fields' => array(
								array(
									'key' => 'field_5bc7897dc0702',
									'label' => 'Product ID',
									'name' => 'product',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
									'parent_repeater' => 'field_5bc7896bc0701',
								),
							),
							'rows_per_page' => 20,
						),
						array(
							'key' => 'field_5bc78a0ac0703',
							'label' => 'Additional Categories',
							'name' => 'additional_categories',
							'aria-label' => '',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 0,
							'max' => 0,
							'layout' => 'table',
							'button_label' => 'Add Category',
							'sub_fields' => array(
								array(
									'key' => 'field_5bc78a46c0704',
									'label' => 'Category Slug',
									'name' => 'category',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
									'parent_repeater' => 'field_5bc78a0ac0703',
								),
							),
							'rows_per_page' => 20,
						),
						array(
							'key' => 'field_5c78475feb2f4',
							'label' => 'Additional Products',
							'name' => 'additional_products',
							'aria-label' => '',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 0,
							'max' => 0,
							'layout' => 'table',
							'button_label' => 'Add Featured Product',
							'sub_fields' => array(
								array(
									'key' => 'field_5c78475feb2f5',
									'label' => 'Product ID',
									'name' => 'product',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
									'parent_repeater' => 'field_5c78475feb2f4',
								),
							),
							'rows_per_page' => 20,
						),
						array(
							'key' => 'field_5c784739eb2f3',
							'label' => 'Additional Content',
							'name' => 'additional_content',
							'aria-label' => '',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 0,
						),
						array(
							'key' => 'field_5c3ce4594a48e',
							'label' => 'Show Products',
							'name' => 'show_products',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => 'Check if you want to show products even when there are categories shown.',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 1,
							'ui_on_text' => 'True',
							'ui_off_text' => 'False',
						),
						array(
							'key' => 'field_5c7d691588c90',
							'label' => 'Discontinued Relationship',
							'name' => 'discontinued_relationship',
							'aria-label' => '',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 0,
							'max' => 0,
							'layout' => 'table',
							'button_label' => 'Add Category',
							'sub_fields' => array(
								array(
									'key' => 'field_5c7d691588c91',
									'label' => 'Relationship Slug',
									'name' => 'relationship',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
									'parent_repeater' => 'field_5c7d691588c90',
								),
							),
							'rows_per_page' => 20,
						),
					),
					'location' => array(
						array(
							array(
								'param' => 'taxonomy',
								'operator' => '==',
								'value' => 'product-category',
							),
						),
					),
					'menu_order' => 0,
					'position' => 'normal',
					'style' => 'seamless',
					'label_placement' => 'top',
					'instruction_placement' => 'label',
					'hide_on_screen' => '',
					'active' => true,
					'description' => '',
					'show_in_rest' => 1,
				)
			);

			acf_add_local_field_group(
				array(
					'key' => 'group_5d8aa0322a670',
					'title' => 'Products',
					'fields' => array(
						array(
							'key' => 'field_5d8aa10883ad1',
							'label' => 'Parent Product ID',
							'name' => 'parent_product_id',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_5d8aa05483acc',
							'label' => 'Product ID',
							'name' => 'product_id',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_5d8aa08383acd',
							'label' => 'Sub Products',
							'name' => 'sub_products',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_5d8aa18383ad3',
							'label' => 'Product Group',
							'name' => 'product_group',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_5d8aa19983ad4',
							'label' => 'Product Category',
							'name' => 'product_category',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_5d8aa14c83ad2',
							'label' => 'Product Features',
							'name' => 'product_features',
							'aria-label' => '',
							'type' => 'textarea',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'maxlength' => '',
							'rows' => '',
							'new_lines' => '',
						),
						array(
							'key' => 'field_5d8aa1fd83ad5',
							'label' => 'Product Benefits',
							'name' => 'product_benefits',
							'aria-label' => '',
							'type' => 'textarea',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'maxlength' => '',
							'rows' => '',
							'new_lines' => '',
						),
						array(
							'key' => 'field_5d8aa29783ad6',
							'label' => 'Product Images',
							'name' => 'product_images',
							'aria-label' => '',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 0,
							'max' => 0,
							'layout' => 'table',
							'button_label' => 'Add Image',
							'rows_per_page' => 20,
							'sub_fields' => array(
								array(
									'key' => 'field_5d8aa2be83ad7',
									'label' => 'Image',
									'name' => 'image',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
									'parent_repeater' => 'field_5d8aa29783ad6',
								),
								array(
									'key' => 'field_5d8aa4a583adb',
									'label' => 'Group',
									'name' => 'group',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
									'parent_repeater' => 'field_5d8aa29783ad6',
								),
							),
						),
						array(
							'key' => 'field_5d8aa30483ad8',
							'label' => 'Product Documents',
							'name' => 'product_documents',
							'aria-label' => '',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 0,
							'max' => 0,
							'layout' => 'table',
							'button_label' => 'Add Document',
							'rows_per_page' => 20,
							'sub_fields' => array(
								array(
									'key' => 'field_5d951bf3df627',
									'label' => 'Title',
									'name' => 'title',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '20',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
									'parent_repeater' => 'field_5d8aa30483ad8',
								),
								array(
									'key' => 'field_5d8aa3e983ada',
									'label' => 'Group',
									'name' => 'group',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '20',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
									'parent_repeater' => 'field_5d8aa30483ad8',
								),
								array(
									'key' => 'field_5d8aa33d83ad9',
									'label' => 'Document',
									'name' => 'document',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '60',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
									'parent_repeater' => 'field_5d8aa30483ad8',
								),
							),
						),
						array(
							'key' => 'field_5d8aa4b883adc',
							'label' => 'Product Videos',
							'name' => 'product_videos',
							'aria-label' => '',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 0,
							'max' => 0,
							'layout' => 'table',
							'button_label' => 'Add Video',
							'rows_per_page' => 20,
							'sub_fields' => array(
								array(
									'key' => 'field_5d8aa4b883add',
									'label' => 'Video',
									'name' => 'video',
									'aria-label' => '',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
									'parent_repeater' => 'field_5d8aa4b883adc',
								),
							),
						),
						array(
							'key' => 'field_5d8aa57c83adf',
							'label' => 'Created Date',
							'name' => 'created_date',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_5d8aa58983ae0',
							'label' => 'Modified Date',
							'name' => 'modified_date',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_5d8aa59083ae1',
							'label' => 'Published Date',
							'name' => 'published_date',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_5d8aa0e483acf',
							'label' => 'Regions Sold In',
							'name' => 'regions_sold_in',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => 'hidden',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_5d8aa0f483ad0',
							'label' => 'Countries Sold In',
							'name' => 'countries_sold_in',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => 'hidden',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_63f93fad74466',
							'label' => 'Facets',
							'name' => 'facets',
							'aria-label' => '',
							'type' => 'group',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'layout' => 'block',
							'sub_fields' => array(
								array(
									'key' => 'field_63f947c3b302e',
									'label' => 'Access Type',
									'name' => 'access_type',
									'aria-label' => '',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => false,
									'conditional_logic' => false,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'local' => 'Local',
										'remote' => 'Remote',
									),
									'layout' => 'vertical',
									'default_value' => array(),
									'allow_custom' => 0,
									'save_custom' => 0,
									'toggle' => 0,
									'return_format' => 'value',
									'custom_choice_button_text' => 'Add new choice',
								),
								array(
									'key' => 'field_63f947b8dd2ec',
									'label' => 'Aisle Width (mm / in)',
									'name' => 'aisle_width_mm_in',
									'aria-label' => '',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => false,
									'conditional_logic' => false,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'1200_47_24' => '1200/47.24',
										'indoor_cabinet' => 'Indoor Cabinet',
									),
									'layout' => 'vertical',
									'default_value' => array(),
									'allow_custom' => 0,
									'save_custom' => 0,
									'toggle' => 0,
									'return_format' => 'value',
									'custom_choice_button_text' => 'Add new choice',
								),
								array(
									'key' => 'field_6630063089af7',
									'label' => 'Application',
									'name' => 'application',
									'aria-label' => '',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'battery_monitoring_and_testing' => 'Battery Monitoring and Testing',
										'broadband_fttx_node' => 'Broadband/FTTx Node',
										'catv_headend' => 'CATV Headend',
										'capacity_planning' => 'Capacity Planning',
										'central_office_mtso' => 'Central Office/MTSO',
										'central_officemtso' => 'Central OfficeMTSO',
										'colocation_hosting' => 'Colocation Hosting',
										'control_room_management' => 'Control Room Management',
										'copper_distribution' => 'Copper Distribution',
										'critical_facility_site' => 'Critical Facility Site',
										'customer_premises' => 'Customer Premises',
										'das_distributed_antenna_system' => 'DAS Distributed Antenna System',
										'data_center' => 'Data Center',
										'desktop_access_productivity' => 'Desktop Access Productivity',
										'emergency_lighting' => 'Emergency Lighting',
										'energy_management' => 'Energy Management',
										'energy_monitoring' => 'Energy Monitoring',
										'fiber_distribution' => 'Fiber Distribution',
										'micro_data_center' => 'Micro Data Center',
										'network_closet' => 'Network Closet',
										'off_grid' => 'Off-grid',
										'remote_management' => 'Remote Management',
										'remote_terminal' => 'Remote Terminal',
										'server_management' => 'Server Management',
										'service_processor_management' => 'Service Processor Management',
										'small_cell' => 'Small Cell',
										'small_computer_room' => 'Small Computer Room',
										'thermal_management' => 'Thermal Management',
										'thermal_monitoring' => 'Thermal Monitoring',
										'wireless_base_station' => 'Wireless Base Station',
									),
									'default_value' => array(),
									'return_format' => 'value',
									'allow_custom' => 0,
									'layout' => 'vertical',
									'toggle' => 0,
									'save_custom' => 0,
									'custom_choice_button_text' => 'Add new choice',
								),
								array(
									'key' => 'field_63f947996b7c3',
									'label' => 'Brand',
									'name' => 'brand',
									'aria-label' => '',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'alber' => 'Alber',
										'avocent' => 'Avocent',
										'cybex' => 'Cybex',
										'liebert' => 'Liebert',
										'net_xtend' => 'Net Xtend',
										'powerbar' => 'Powerbar',
										'smart_solutions' => 'Smart Solutions',
										'vertiv' => 'Vertiv',
									),
									'default_value' => array(),
									'return_format' => 'value',
									'allow_custom' => 0,
									'layout' => 'vertical',
									'toggle' => 0,
									'save_custom' => 0,
									'custom_choice_button_text' => 'Add new choice',
								),
								array(
									'key' => 'field_63f940e20cd28',
									'label' => 'Capacity (amps)',
									'name' => 'capacity_amps',
									'aria-label' => '',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'10_100_amps' => '10 - 100 amps',
										'100_250_amps' => '100 - 250 amps',
										'100_600_amps' => '100 - 600 amps',
										'1000_4000_amps' => '1000 - 4000 amps',
										'1000_5000_amps' => '1000 - 5000 amps',
										'250_600_amps' => '250 - 600 amps',
										'400_2000_amps' => '400 - 2000 amps',
										'4000_12000_amps' => '4000 - 12000 amps',
										'600_1000_amps' => '600 - 1000 amps',
									),
									'default_value' => array(),
									'return_format' => 'value',
									'allow_custom' => 0,
									'layout' => 'vertical',
									'toggle' => 0,
									'save_custom' => 0,
									'custom_choice_button_text' => 'Add new choice',
								),
								array(
									'key' => 'field_63f947c2431aa',
									'label' => 'Capacity (kVA)',
									'name' => 'capacity_kva',
									'aria-label' => '',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'500_kva' => '500 kVA',
										'0_35_3_kva' => '0.35 - 3 kVA',
										'100_500_kva' => '100 - 500 kVA',
										'20_100_kva' => '20 - 100 kVA',
										'3_20_kva' => '3 - 20 kVA',
									),
									'default_value' => array(),
									'return_format' => 'value',
									'allow_custom' => 0,
									'layout' => 'vertical',
									'toggle' => 0,
									'save_custom' => 0,
									'custom_choice_button_text' => 'Add new choice',
								),
								array(
									'key' => 'field_63f940ea3635e',
									'label' => 'Capacity (kW)',
									'name' => 'capacity_kw',
									'aria-label' => '',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => false,
									'conditional_logic' => false,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'0_5_5_kw' => '0.5 - 5 kW',
										'1_5_15_mw' => '1.5 - 15 MW',
										'10_20_kw' => '10 - 20 kW',
										'100_250_kw' => '100 - 250 kW',
										'20_100_kw' => '20 - 100 kW',
										'200_600_kw' => '200 - 600 kW',
										'5_30_kw' => '5 - 30 kW',
										'50_200_kw' => '50 - 200 kW',
									),
									'layout' => 'vertical',
									'default_value' => array(),
									'allow_custom' => 0,
									'save_custom' => 0,
									'toggle' => 0,
									'return_format' => 'value',
									'custom_choice_button_text' => 'Add new choice',
								),
								array(
									'key' => 'field_63f947c24fc83',
									'label' => 'Compliance',
									'name' => 'compliance',
									'aria-label' => '',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'baa' => 'BAA',
										'taa' => 'TAA',
									),
									'default_value' => array(),
									'return_format' => 'value',
									'allow_custom' => 0,
									'layout' => 'vertical',
									'toggle' => 0,
									'save_custom' => 0,
									'custom_choice_button_text' => 'Add new choice',
								),
								array(
									'key' => 'field_642afd05efcc8',
									'label' => 'Controls and Monitoring Type',
									'name' => 'controls_and_monitoring_type',
									'aria-label' => '',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => false,
									'conditional_logic' => false,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'battery_monitoring_and_testing' => 'Battery Monitoring and Testing',
										'battery_monitors' => 'Battery Monitors',
										'battery_testers' => 'Battery Testers',
										'branch_circuit_monitoring' => 'Branch Circuit Monitoring',
										'communication_cards' => 'Communication Cards',
										'controllers' => 'Controllers',
										'environmental_sensors' => 'Environmental Sensors',
										'leak_detection' => 'Leak Detection',
										'monitoring' => 'Monitoring',
										'monitoring_panels' => 'Monitoring Panels',
										'monitoring_software' => 'Monitoring Software',
										'outlet_control_and_monitoring' => 'Outlet Control and Monitoring',
										'outlet_monitoring' => 'Outlet Monitoring',
									),
									'layout' => 'vertical',
									'default_value' => array(),
									'allow_custom' => 0,
									'save_custom' => 0,
									'toggle' => 0,
									'return_format' => 'value',
									'custom_choice_button_text' => 'Add new choice',
								),
								array(
									'key' => 'field_63f949075fa4a',
									'label' => 'Critical Facility Type',
									'name' => 'critical_facility_type',
									'aria-label' => '',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => false,
									'conditional_logic' => false,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'control_room' => 'Control Room',
										'data_center' => 'Data Center',
										'healthcare' => 'Healthcare',
										'telecom' => 'Telecom',
										'utility' => 'Utility',
									),
									'layout' => 'vertical',
									'default_value' => array(),
									'allow_custom' => 0,
									'save_custom' => 0,
									'toggle' => 0,
									'return_format' => 'value',
									'custom_choice_button_text' => 'Add new choice',
								),
								array(
									'key' => 'field_63f94a0988528',
									'label' => 'Device Type',
									'name' => 'device_type',
									'aria-label' => '',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => false,
									'conditional_logic' => false,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'desktop' => 'Desktop',
										'mobile' => 'Mobile',
									),
									'layout' => 'vertical',
									'default_value' => array(),
									'allow_custom' => 0,
									'save_custom' => 0,
									'toggle' => 0,
									'return_format' => 'value',
									'custom_choice_button_text' => 'Add new choice',
								),
								array(
									'key' => 'field_63f947b6ac289',
									'label' => 'Facility Type',
									'name' => 'facility_type',
									'aria-label' => '',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => false,
									'conditional_logic' => false,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'telecom' => 'Telecom',
										'utility' => 'Utility',
									),
									'layout' => 'vertical',
									'default_value' => array(),
									'allow_custom' => 0,
									'save_custom' => 0,
									'toggle' => 0,
									'return_format' => 'value',
									'custom_choice_button_text' => 'Add new choice',
								),
								array(
									'key' => 'field_63f947bebab07',
									'label' => 'Industry',
									'name' => 'industry',
									'aria-label' => '',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => false,
									'conditional_logic' => false,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'banking_financial_insurance' => 'Banking Financial Insurance',
										'broadcast' => 'Broadcast',
										'broadcast_entertainment' => 'Broadcast Entertainment',
										'construction_engineering' => 'Construction Engineering',
										'data_center_colocation_hosting' => 'Data Center Colocation Hosting',
										'education' => 'Education',
										'financial' => 'Financial',
										'government' => 'Government',
										'healthcare' => 'Healthcare',
										'industrial' => 'Industrial',
										'manufacturing' => 'Manufacturing',
										'professional_services' => 'Professional Services',
										'retail' => 'Retail',
										'retail_wholesale' => 'Retail Wholesale',
										'telecom' => 'Telecom',
										'transportation' => 'Transportation',
									),
									'layout' => 'vertical',
									'default_value' => array(),
									'allow_custom' => 0,
									'save_custom' => 0,
									'toggle' => 0,
									'return_format' => 'value',
									'custom_choice_button_text' => 'Add new choice',
								),
								array(
									'key' => 'field_63f94105d604a',
									'label' => 'Input Voltage',
									'name' => 'input_voltage',
									'aria-label' => '',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'100_vac_single_phase' => '100 VAC Single Phase',
										'120_vac_single_phase' => '120 VAC Single Phase',
										'208_vac_single_phase' => '208 VAC Single Phase',
										'208_vac_three_phase' => '208 VAC Three Phase',
										'220_vac_single_phase' => '220 VAC Single Phase',
										'220_vac_three_phase' => '220 VAC Three Phase',
										'230_vac_single_phase' => '230 VAC Single Phase',
										'230_vac_three_phase' => '230 VAC Three Phase',
										'240_vac_single_phase' => '240 VAC Single Phase',
										'240_vac_three_phase' => '240 VAC Three Phase',
										'380_vac_three_phase' => '380 VAC Three Phase',
										'400_vac_three_phase' => '400 VAC Three Phase',
										'415_vac_three_phase' => '415 VAC Three Phase',
										'480_vac_three_phase' => '480 VAC Three Phase',
										'575_vac_three_phase' => '575 VAC Three Phase',
										'600_vac_three_phase' => '600 VAC Three Phase',
									),
									'default_value' => array(),
									'return_format' => 'value',
									'allow_custom' => 0,
									'layout' => 'vertical',
									'toggle' => 0,
									'save_custom' => 0,
									'custom_choice_button_text' => 'Add new choice',
								),
								array(
									'key' => 'field_63f947997e39a',
									'label' => 'Location',
									'name' => 'location',
									'aria-label' => '',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'outdoor_enclosure' => 'Outdoor Enclosure',
										'critical_facility_site' => 'Critical Facility/Site',
										'desktop' => 'Desktop',
										'gallery' => 'Gallery',
										'indoor' => 'Indoor',
										'modular_container' => 'Modular Container',
										'network_it_edge' => 'Network/IT Edge',
										'perimeter' => 'Perimeter',
										'rack' => 'Rack',
										'room' => 'Room',
										'row' => 'Row',
									),
									'default_value' => array(),
									'return_format' => 'value',
									'allow_custom' => 0,
									'layout' => 'vertical',
									'toggle' => 0,
									'save_custom' => 0,
									'custom_choice_button_text' => 'Add new choice',
								),
								array(
									'key' => 'field_63f947b8d29bc',
									'label' => 'Load Rating Static (kg / lbs)',
									'name' => 'load_rating_static_kg_lbs',
									'aria-label' => '',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'1361_3000' => '1361/3000',
									),
									'default_value' => array(),
									'return_format' => 'value',
									'allow_custom' => 0,
									'layout' => 'vertical',
									'toggle' => 0,
									'save_custom' => 0,
									'custom_choice_button_text' => 'Add new choice',
								),
								array(
									'key' => 'field_63f947b6cc9bd',
									'label' => 'Monitored Equipment',
									'name' => 'monitored_equipment',
									'aria-label' => '',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => false,
									'conditional_logic' => false,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'batteries' => 'Batteries',
										'dc_power_systems' => 'DC Power Systems',
									),
									'layout' => 'vertical',
									'default_value' => array(),
									'allow_custom' => 0,
									'save_custom' => 0,
									'toggle' => 0,
									'return_format' => 'value',
									'custom_choice_button_text' => 'Add new choice',
								),
								array(
									'key' => 'field_63f9479974d6a',
									'label' => 'Mounting Arrangement',
									'name' => 'mounting_arrangement',
									'aria-label' => '',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => false,
									'conditional_logic' => false,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'buried_plinth' => 'Buried Plinth',
										'h_frame' => 'H-Frame',
										'pad' => 'Pad',
										'pole' => 'Pole',
										'stake' => 'Stake',
										'vault' => 'Vault',
										'wall' => 'Wall',
									),
									'layout' => 'vertical',
									'default_value' => array(),
									'allow_custom' => 0,
									'save_custom' => 0,
									'toggle' => 0,
									'return_format' => 'value',
									'custom_choice_button_text' => 'Add new choice',
								),
								array(
									'key' => 'field_63f940fc74ae9',
									'label' => 'Output Voltage',
									'name' => 'output_voltage',
									'aria-label' => '',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => false,
									'conditional_logic' => false,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'690vac' => ' 690VAC',
										'100_vac_single_phase' => '100 VAC Single Phase',
										'120_vac_single_phase' => '120 VAC Single Phase',
										'208_vac_single_phase' => '208 VAC Single Phase',
										'208_vac_three_phase' => '208 VAC Three Phase',
										'220_vac_single_phase' => '220 VAC Single Phase',
										'220_vac_three_phase' => '220 VAC Three Phase',
										'230_vac_single_phase' => '230 VAC Single Phase',
										'230_vac_three_phase' => '230 VAC Three Phase',
										'24_vdc' => '24 VDC',
										'240_vac_three_phase' => '240 VAC Three Phase',
										'254_vac_three_phase' => '254 VAC Three Phase',
										'277_vac_three_phase' => '277 VAC Three Phase',
										'346_vac_three_phase' => '346 VAC Three Phase',
										'380_vac_three_phase' => '380 VAC Three Phase',
										'400_vac_three_phase' => '400 VAC Three Phase',
										'400_vdc' => '400 VDC',
										'415_vac_three_phase' => '415 VAC Three Phase',
										'440_vac_three_phase' => '440 VAC Three Phase',
										'48_vdc' => '48 VDC',
										'480_vac_three_phase' => '480 VAC Three Phase',
										'480vac' => '480VAC',
										'575_vac_three_phase' => '575 VAC Three Phase',
										'600_vac_three_phase' => '600 VAC Three Phase',
									),
									'layout' => 'vertical',
									'default_value' => array(),
									'allow_custom' => 0,
									'save_custom' => 0,
									'toggle' => 0,
									'return_format' => 'value',
									'custom_choice_button_text' => 'Add new choice',
								),
								array(
									'key' => 'field_63f947b8c8e36',
									'label' => 'Rack Depth (mm / in)',
									'name' => 'rack_depth_mm_in',
									'aria-label' => '',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'1100_43_31' => '1100/43.31',
										'1200_47_24' => '1200/47.24',
									),
									'default_value' => array(),
									'return_format' => 'value',
									'allow_custom' => 0,
									'layout' => 'vertical',
									'toggle' => 0,
									'save_custom' => 0,
									'custom_choice_button_text' => 'Add new choice',
								),
								array(
									'key' => 'field_63f947becf2b7',
									'label' => 'Product Brand',
									'name' => 'product_brand',
									'aria-label' => '',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => false,
									'conditional_logic' => false,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'liebert' => 'Liebert',
										'vertiv' => 'Vertiv',
									),
									'layout' => 'vertical',
									'default_value' => array(),
									'allow_custom' => 0,
									'save_custom' => 0,
									'toggle' => 0,
									'return_format' => 'value',
									'custom_choice_button_text' => 'Add new choice',
								),
								array(
									'key' => 'field_63f947b8af093',
									'label' => 'Rack Height (U)',
									'name' => 'rack_height_u',
									'aria-label' => '',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => false,
									'conditional_logic' => false,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										24 => '24',
										42 => '42',
										45 => '45',
										48 => '48',
									),
									'layout' => 'vertical',
									'default_value' => array(),
									'allow_custom' => 0,
									'save_custom' => 0,
									'toggle' => 0,
									'return_format' => 'value',
									'custom_choice_button_text' => 'Add new choice',
								),
								array(
									'key' => 'field_642afd05c6bdc',
									'label' => 'Product Type',
									'name' => 'product_type',
									'aria-label' => '',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => false,
									'conditional_logic' => false,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'controls' => ' Controls',
										'dyna_flex' => ' Dyna Flex',
										'microgrid' => ' Microgrid',
										'accessories' => 'Accessories',
										'buried_distribution' => 'Buried Distribution',
										'catv' => 'CATV',
										'colocation_racks' => 'Colocation Racks',
										'console_tray' => 'Console Tray',
										'containment_solutions' => 'Containment Solutions',
										'cross_connect_cabinets' => 'Cross-Connect Cabinets',
										'dc_power_distribution' => 'DC Power Distribution',
										'dc_power_retrofit' => 'DC Power Retrofit',
										'dc_power_system' => 'DC Power System',
										'dslam_fttx_cabinets' => 'DSLAM/FTTx Cabinets',
										'dyna_flex_bess' => 'Dyna Flex BESS',
										'embedded_technologies_and_applications' => 'Embedded Technologies and Applications',
										'enterprise_kvm' => 'Enterprise KVM',
										'fiber_optic_enclosures' => 'Fiber Optic Enclosures',
										'high_performance_kvm' => 'High Performance KVM',
										'indoor_cabinet' => 'Indoor Cabinet',
										'management_software' => 'Management Software',
										'monitoring_software' => 'Monitoring Software',
										'network_racks' => 'Network Racks',
										'outdoor_enclosure' => 'Outdoor Enclosure',
										'power_transfer_switches' => 'Power Transfer Switches',
										'rack' => 'Rack',
										'secure_desktop_kvm' => 'Secure Desktop KVM',
										'server_racks' => 'Server Racks',
										'subrack' => 'Subrack',
										'surge_suppression' => 'Surge Suppression',
										'uninterruptible_power_supplies_ups' => 'Uninterruptible Power Supplies UPS',
										'wireless' => 'Wireless',
									),
									'layout' => 'vertical',
									'default_value' => array(),
									'allow_custom' => 0,
									'save_custom' => 0,
									'toggle' => 0,
									'return_format' => 'value',
									'custom_choice_button_text' => 'Add new choice',
								),
								array(
									'key' => 'field_63f947b8be084',
									'label' => 'Rack Width (mm / in)',
									'name' => 'rack_width_mm_in',
									'aria-label' => '',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => false,
									'conditional_logic' => false,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'600_23_62' => '600/23.62',
										'700_27_56' => '700/27.56',
										'800_31_50' => '800/31.50',
									),
									'layout' => 'vertical',
									'default_value' => array(),
									'allow_custom' => 0,
									'save_custom' => 0,
									'toggle' => 0,
									'return_format' => 'value',
									'custom_choice_button_text' => 'Add new choice',
								),
								array(
									'key' => 'field_63f947beaa0bc',
									'label' => 'Service Type',
									'name' => 'service_type',
									'aria-label' => '',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => false,
									'conditional_logic' => false,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'preventive_maintenance' => 'Preventive Maintenance',
										'remote_services' => 'Remote Services',
									),
									'layout' => 'vertical',
									'default_value' => array(),
									'allow_custom' => 0,
									'save_custom' => 0,
									'toggle' => 0,
									'return_format' => 'value',
									'custom_choice_button_text' => 'Add new choice',
								),
								array(
									'key' => 'field_63f947c087a7c',
									'label' => 'Technology Type',
									'name' => 'technology_type',
									'aria-label' => '',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => false,
									'conditional_logic' => false,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'chilled_water' => 'Chilled Water',
										'dxrefrigerant' => 'DXRefrigerant',
									),
									'layout' => 'vertical',
									'default_value' => array(),
									'allow_custom' => 0,
									'save_custom' => 0,
									'toggle' => 0,
									'return_format' => 'value',
									'custom_choice_button_text' => 'Add new choice',
								),
								array(
									'key' => 'field_63f94a0e72299',
									'label' => 'Voltage',
									'name' => 'voltage',
									'aria-label' => '',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => false,
									'conditional_logic' => false,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'greater_than_600v' => 'Greater than 600V',
									),
									'layout' => 'vertical',
									'default_value' => array(),
									'allow_custom' => 0,
									'save_custom' => 0,
									'toggle' => 0,
									'return_format' => 'value',
									'custom_choice_button_text' => 'Add new choice',
								),
							),
						),
					),
					'location' => array(
						array(
							array(
								'param' => 'post_type',
								'operator' => '==',
								'value' => 'products',
							),
						),
					),
					'menu_order' => 0,
					'position' => 'normal',
					'style' => 'default',
					'label_placement' => 'top',
					'instruction_placement' => 'label',
					'hide_on_screen' => array(
						0 => 'discussion',
						1 => 'comments',
						2 => 'revisions',
						3 => 'author',
						4 => 'format',
						5 => 'page_attributes',
						6 => 'featured_image',
						7 => 'tags',
						8 => 'send-trackbacks',
					),
					'active' => true,
					'description' => '',
					'show_in_rest' => 1,
				)
			);

			acf_add_local_field_group(
				array(
					'key' => 'group_5d8aa5c5079ff',
					'title' => 'Product Tools',
					'fields' => array(
						array(
							'key' => 'field_5d8aa5d96da08',
							'label' => 'Mark as Locally Hosted?',
							'name' => 'hosted_by_vf',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 1,
							'ui_on_text' => 'Local',
							'ui_off_text' => 'External',
						),
						array(
							'key' => 'field_5d8aa5f66da09',
							'label' => 'Discontinue This Product?',
							'name' => 'discontinue_product',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 1,
							'ui_on_text' => 'Yes',
							'ui_off_text' => 'No',
						),
						array(
							'key' => 'field_5d8aa61b6da0a',
							'label' => 'Import Feed Data',
							'name' => 'import_feed_data',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 1,
							'ui_on_text' => 'Yes',
							'ui_off_text' => 'No',
						),
						array(
							'key' => 'field_5de95489b22a4',
							'label' => 'Site Specific Product',
							'name' => 'site_specific',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 1,
							'ui_on_text' => 'Yes',
							'ui_off_text' => 'No',
						),
					),
					'location' => array(
						array(
							array(
								'param' => 'post_type',
								'operator' => '==',
								'value' => 'products',
							),
						),
					),
					'menu_order' => 0,
					'position' => 'side',
					'style' => 'default',
					'label_placement' => 'top',
					'instruction_placement' => 'label',
					'hide_on_screen' => array(
						0 => 'discussion',
						1 => 'comments',
						2 => 'revisions',
						3 => 'author',
						4 => 'format',
						5 => 'page_attributes',
						6 => 'featured_image',
						7 => 'tags',
						8 => 'send-trackbacks',
					),
					'active' => true,
					'description' => '',
					'show_in_rest' => 1,
				)
			);
		}
	}

	/**
	 * Modifies the columns displayed on the admin product listing page.
	 *
	 * @param array $columns Existing array of columns to be displayed.
	 * @return array Modified array of columns.
	 */
	public function manage_products_columns( $columns ) {
		// Remove unnecessary columns
		unset(
			$columns['author'],
			$columns['comments']
		);

		// Rename title and add ID and Address
		$columns['product_id'] = esc_attr__( 'Product ID', 'common-framework' );
		$columns['parent_product_id'] = esc_attr__( 'Parent ID', 'common-framework' );
		$columns['sub_products'] = esc_attr__( 'Child IDs', 'common-framework' );

		/**
		 * Rearrange column order
		 *
		 * Now define a new order. you need to look up the column
		 * names in the HTML of the admin interface HTML of the table header.
		 *
		 *     "cb" is the "select all" checkbox.
		 *     "title" is the title column.
		 *     "date" is the date column.
		 *     "icl_translations" comes from a plugin (eg.: WPML).
		 *
		 * change the order of the names to change the order of the columns.
		 *
		 * @link http://wordpress.stackexchange.com/questions/8427/change-order-of-custom-columns-for-edit-panels
		 */
		$custom_order = array( 'cb', 'title', 'product_id', 'parent_product_id', 'sub_products', 'taxonomy-product-category', 'date' );

		/**
		 * return a new column array to wordpress.
		 * order is the exactly like you set in $custom_order.
		 */
		foreach ( $custom_order as $column_name ) {
			$rearranged[ $column_name ] = $columns[ $column_name ];
		}

		return $rearranged;
	}

	/**
	 * Handles the display of custom columns in the admin products list.
	 *
	 * @param string $column The name of the column to display.
	 * @param int    $post_id The ID of the current post.
	 */
	public function manage_products_custom_column( $column, $post_id ) {
		$columns = [ 'product_id', 'parent_product_id', 'sub_products' ];
		if ( in_array( $column, $columns ) ) {
			$field = get_field( $column, $post_id );
			if ( ! empty( $field ) ) {
				echo esc_html( $field );
			}
		}
	}

	/**
	 * Sets sortable columns in the product list in the admin area.
	 *
	 * @param array $columns Array of sortable columns.
	 * @return array Array of sortable columns with added custom product columns.
	 */
	public function manage_sortable_columns( $columns ) {
		$columns['product_id'] = 'product_id';
		$columns['parent_product_id'] = 'parent_product_id';
		$columns['sub_products'] = 'sub_products';

		return $columns;
	}

	/**
	 * Adjusts the WP_Query object to sort products by meta values.
	 *
	 * @param WP_Query $query The WP_Query instance being modified.
	 */
	public function manage_posts_orderby( $query ) {
		if ( ! is_admin() || ! $query->is_main_query() ) {
			return;
		}

		/**
		 * meta_types:
		 * Possible values are 'NUMERIC', 'BINARY', 'CHAR', 'DATE', 'DATETIME', 'DECIMAL', 'SIGNED', 'TIME', 'UNSIGNED'.
		 * Default value is 'CHAR'.
		 *
		 * @link https://codex.wordpress.org/Class_Reference/WP_Meta_Query
		 */
		$columns = array(
			'product_id'  => 'NUMERIC',
			'parent_product_id' => 'NUMERIC',
			'sub_products'  => 'NUMERIC',
		);

		foreach ( $columns as $key => $type ) {
			if ( $key === $query->get( 'orderby' ) ) {
				$query->set( 'orderby', 'meta_value_num' );
				$query->set( 'meta_key', $key );
				$query->set( 'meta_type', $type );
				break;
			}
		}
	}

	/**
	 * Outputs an accordion JavaScript for the FacetWP plugin.
	 */
	public function facet_accordion_script() {
		?>
		<script>
		(function($) {
			document.addEventListener('facetwp-loaded', function() {
				$.each(FWP.settings.num_choices, function(key, val) {
					var $facet = $('.facetwp-facet-' + key);
					var $wrap = $facet.closest('.facet__wrapper');
					if ($wrap.length) {
						(0 === val) ? $wrap.hide() : $wrap.show();
					}
				});
			});
		})(jQuery);
		</script>
		<?php
	}

	/**
	 * Implements a shortcode that renders all product facets.
	 *
	 * @param array       $atts An associative array of attributes, or an empty string if no attributes are given.
	 * @param string|null $content The enclosed content (if the shortcode is used in its enclosing form).
	 * @return string The shortcode output.
	 */
	public function all_product_facets_shortcode( $atts, $content = null ) {
		ob_start();
		$fwp = FacetWP::instance();
		$all_facets = $fwp->helper->settings['facets'];

		foreach ( $all_facets as $facet ) {
			$spec_pattern = '/_spec_/i';
			if ( ! preg_match( $spec_pattern, $facet['name'] ) && strpos( $facet['name'], 'pf_' ) !== false ) {
				echo '<div class="facet__wrapper">';
				echo '<h3 class="facet__label">' . esc_html( $facet['label'] ) . '</h3>';
				// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				echo facetwp_display( 'facet', $facet['name'] ); // phpcs
				echo '</div>';
			}
		}

		$html = ob_get_contents();
		ob_end_clean();
		return $html;
	}

	/**
	 * Shortcode to display all products related to a specific term ID.
	 *
	 * @param array $atts Shortcode attributes.
	 * @return string HTML content listing all products.
	 */
	public function display_all_products_shortcode( $atts ) {
		ob_start();

		$term_slug = $atts['term'];
		$term = get_term_by( 'slug', $term_slug, 'product-category', ARRAY_A );

		$product_args = array(
			'post_type' => 'products',
			'post_status' => 'publish',
			'orderby' => 'title',
			'order' => 'ASC',
			'posts_per_page' => -1,
			'tax_query' => array(
				array(
					'taxonomy' => 'product-category',
					'field'    => 'slug',
					'terms'    => $term_slug,
				),
				array(
					'taxonomy' => 'product-category',
					'field'    => 'slug',
					'terms'    => 'discontinued',
					'operator' => 'NOT IN',
				),
			),
		);

		$discontined_args = array(
			'post_type' => 'products',
			'post_status' => 'publish',
			'orderby' => 'title',
			'order' => 'ASC',
			'posts_per_page' => -1,
			'tax_query' => array(
				array(
					'taxonomy' => 'cf_product_type',
					'field'    => 'slug',
					'terms'    => $term_slug,
				),
				array(
					'taxonomy' => 'cf_product_type',
					'field'    => 'slug',
					'terms'    => 'discontinued',
				),
			),
		);

		$products_query = new WP_Query( $product_args );
		if ( $products_query->have_posts() ) {
			?>
			<h2><?php echo esc_html( $term['name'] ); ?></h2>
			<ul class="product-list">
			<?php
			while ( $products_query->have_posts() ) : $products_query->the_post();
				?>
				<li>
					<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
				</li>
				<?php endwhile; ?>
			</ul>
			<?php
		}

		$discontinued_query = new WP_Query( $discontined_args );
		if ( $discontinued_query->have_posts() ) {
			?>
			<h3>Dicontinued Products</h3>
			<ul class="product-list">
			<?php
			while ( $discontinued_query->have_posts() ) : $discontinued_query->the_post();
				?>
				<li>
					<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
				</li>
				<?php endwhile; ?>
			</ul>
			<?php
		}

		wp_reset_postdata();

		$products = ob_get_contents();
		ob_end_clean();
		return $products;
	}

	/**
	 * Reorders posts to put featured products first.
	 *
	 * @param array  $post_ids Array of post IDs.
	 * @param string $class Additional classes or identifiers.
	 * @return array Modified array of post IDs.
	 */
	public function put_featured_products_first( $post_ids, $class ) {
		global $wpdb;

		if ( empty( $post_ids ) ) {
			return $post_ids;
		}

		$placeholders = implode( ', ', array_fill( 0, count( $post_ids ), '%d' ) );
		if ( empty( $placeholders ) ) {
			return $post_ids;
		}

		$results = $wpdb->get_col( $wpdb->prepare( "SELECT post_id FROM {$wpdb->prefix}postmeta WHERE meta_key = 'featured' AND meta_value = '1' AND post_id IN ($placeholders)", ...$post_ids ) ); // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared

		// If a featured post, remove it from $post_ids and add it to $matches
		// We loop through $post_ids to preserve featured order
		$matches = array();
		foreach ( $post_ids as $key => $post_id ) {
			if ( in_array( $post_id, $results ) ) {
				$matches[] = $post_id;
				unset( $post_ids[ $key ] );
			}
		}

		// Featured first, then default sort
		$post_ids = array_merge( $matches, $post_ids );

		return $post_ids;
	}

	/**
	 * Enqueues specific styles for product pages.
	 */
	public function enqueue_styles() {
		if ( is_singular( 'products' ) ) {
			wp_enqueue_style(
				'slick_css',
				Utility\style_url( 'slick', 'frontend' ),
				[],
				Utility\get_asset_info( 'slick', 'version' ),
			);
		}
	}

	/**
	 * Registers and enqueues scripts required on product pages or specific tools.
	 */
	public function enqueue_scripts() {
		wp_register_script(
			'battery_selector',
			Utility\script_url( 'battery-selector', 'frontend' ),
			[ 'jquery' ],
			Utility\get_asset_info( 'battery-selector', 'version' ),
			true
		);

		wp_register_script(
			'facet_loaded',
			Utility\script_url( 'facet-loaded', 'frontend' ),
			[ 'jquery' ],
			Utility\get_asset_info( 'facet-loaded', 'version' ),
			true
		);

		if ( is_singular( 'products' ) ) {
			wp_enqueue_script(
				'accordions',
				Utility\script_url( 'accordions', 'frontend' ),
				[],
				Utility\get_asset_info( 'accordions', 'version' ),
				true
			);
			wp_enqueue_script(
				'product_slider',
				Utility\script_url( 'product-slider', 'frontend' ),
				[ 'jquery' ],
				Utility\get_asset_info( 'product-slider', 'version' ),
				true
			);
		}

		if ( is_page( 'product-list' ) || is_page( 'thermal-management-tool' ) || is_page( 'ups-selection-tool' ) ) {
			wp_enqueue_script( 'facet_loaded' );
		}

		if ( is_page( 'battery-systems' ) ) {
			wp_enqueue_script( 'battery_selector' );
		}
	}

	/**
	 * Adds structured data to the header of the page for various custom post types.
	 */
	public function add_schemas() {
		global $post;

		if ( ! is_null( $post ) ) :

			$id = $post->ID;
			$title = get_the_title( $id );
			$description = strip_tags( get_the_excerpt( $id ) );
			// $metaDescription = get_post_meta($id, '_yoast_wpseo_metadesc', true);
			$permalink = get_permalink( $id );

			$organization_name = get_bloginfo( 'name' );
			$image = wp_get_attachment_image_src( get_theme_mod( 'custom_logo' ), 'full' );

			if ( is_singular( 'post' ) ) {
				$imgurl = get_the_post_thumbnail_url(); // Post Thumbnail
				$schema_blogposting = array(
					'@context'  => 'http://schema.org',
					'@type'     => 'BlogPosting',
					'mainEntityOfPage' => array(
						'@type' => 'WebPage',
						'@id'   => $permalink,
					),
					'headline' => $title,
					'image'     => array(
						'@type'     => 'ImageObject',
						'url'       => $imgurl,
					),
					'datePublished' => get_the_date(),
					'dateModified' => get_the_modified_time( 'c' ),
					'author'    => array(
						'@type'     => 'Person',
						'name'      => $organization_name,
					),
					'publisher' => array(
						'@type' => 'Organization',
						'name'  => $organization_name,
						'logo'  => array(
							'@type'  => 'ImageObject',
							'url'    => $image[0],
						),
					),
					'description' => $description,
				);
				echo '<script type="application/ld+json">' . json_encode( $schema_blogposting ) . '</script>'; // encode schema for blogposting
			}
		endif;
	}

	/**
	 * Adds a discontinued badge to the product content if applicable.
	 *
	 * @param string $content The original content of the product.
	 * @return string Modified content including a discontinued badge if applicable.
	 */
	public function add_discontinued_badge( $content ) {
		if ( is_singular( 'products' ) && has_term( 'discontinued', 'product-category' ) ) {
			return '<img class="alignleft" src="https://commonframework.us/app/uploads/products/categories/discontinued.png" alt="This product is discontinued." title="Discontinued Badge">' . $content;
		}
		return $content;
	}

	/**
	 * Retrieves child product IDs from a custom field.
	 *
	 * @return array List of child product IDs.
	 */
	public function get_child_ids() {
		$child_ids = get_field( 'sub_products' );
		if ( ! empty( $child_ids ) ) {
			$child_product_ids = explode( ',', $child_ids );
		}
		return $child_product_ids;
	}

	/**
	 * Adds a custom meta description to product posts if none exists.
	 *
	 * @param string $desc The current meta description.
	 * @return string Modified or new meta description.
	 */
	public function custom_meta( $desc ) {
		if ( empty( $desc ) ) {
			$desc = get_post_meta( get_the_ID(), '_yoast_wpseo_metadesc', true );
		}
		if ( is_singular( 'products' ) && empty( $desc ) ) {
			$content = get_the_content();
			// $content = trim($content, '\n');
			$content = trim( preg_replace( '/\s\s+/', ' ', $content ) );
			$desc = substr( $content, 0, 155 );
		}
		return $desc;
	}

	/**
	 * Adds "Discontinued" to the beginning of Yoast SEO titles
	 * for single product pages that belong to the "Discontinued" category.
	 *
	 * @param string $yoast_title The current Yoast SEO title.
	 * @return string Modified title with "Discontinued" prefix if applicable,
	 *                otherwise the original title.
	 */
	public function add_discontinued_to_yoast_title( $yoast_title ) {
		if ( ! is_singular( 'products' ) ) {
			return $yoast_title;
		}
		$post_id = get_queried_object_id();
		if ( $post_id && $this->is_discontinued( $post_id ) ) {
			$yoast_title = $this->ensure_prefix( $yoast_title );
		}
		return $yoast_title;
	}

	/**
	 * Ensures that a given title is prefixed with "Discontinued".
	 * Prevents double-prefixing if the title already starts with it.
	 *
	 * @param string $title The original post title.
	 * @return string Title guaranteed to begin with "Discontinued ".
	 */
	protected function ensure_prefix( $title ) {
		if ( 0 === stripos( $title, 'Discontinued ' ) ) {
			return $title;
		}
		return 'Discontinued ' . $title;
	}

	/**
	 * Checks whether the given post is a "products" CPT
	 * and is assigned the "discontinued" term in the "product-category" taxonomy.
	 *
	 * @param int $post_id The post ID to check.
	 * @return bool True if the post is a discontinued product, false otherwise.
	 */
	protected function is_discontinued( $post_id ) {
		if ( 'products' !== get_post_type( $post_id ) ) {
			return false;
		}
		return has_term( 'discontinued', 'product-category', $post_id );
	}

	/**
	 * Implements a shortcode to create a slider of product images.
	 *
	 * @return string HTML content for a product image slider.
	 */
	public function product_image_slider_shortcode() {

		ob_start();

		if ( have_rows( 'product_images' ) ) {
			?>
			<div id="product__slider">
				<?php
				while ( have_rows( 'product_images' ) ) {
					the_row();
					?>
					<div class="product__slider-slide">
						<img data-lazy="https://commonframework.us/app/uploads/products/<?php echo esc_attr( get_sub_field( 'image' ) ); ?>" alt="<?php echo esc_attr( get_the_title() . ' | ' . get_sub_field( 'group' ) ); ?>" title="<?php echo esc_attr( get_sub_field( 'group' ) ); ?>" />
					</div>
					<?php
				}
				?>
			</div>
			<?php
		}

		$images = ob_get_contents();
		ob_end_clean();
		return $images;
	}

	/**
	 * Implements a shortcode to display product features and documents in an accordion format.
	 *
	 * @return string HTML content for product accordions.
	 */
	public function product_accordions_shortcode() {

		ob_start();

		echo wp_kses_post( $this->display_field_accordion( 'product_features', 'Features' ) );

		echo wp_kses_post( $this->display_field_accordion( 'product_benefits', 'Benefits' ) );

		$documents = $this->get_product_documents();

		echo wp_kses_post( $this->display_specific_document_accordion( $documents[0][0], 'Brochures and Data Sheets' ) );
		echo wp_kses_post( $this->display_specific_document_accordion( $documents[0][1], 'Specification Documentation' ) );
		echo wp_kses_post( $this->display_specific_document_accordion( $documents[0][2], 'Technical Documents' ) );
		echo wp_kses_post( $this->display_specific_document_accordion( $documents[0][3], 'Manuals' ) );
		echo wp_kses_post( $this->display_specific_document_accordion( $documents[0][4], 'White Papers' ) );
		echo wp_kses_post( $this->display_specific_document_accordion( $documents[0][5], 'Reports & Case Studies' ) );
		echo wp_kses_post( $this->display_specific_document_accordion( $documents[0][6], 'Warranties' ) );
		echo wp_kses_post( $this->display_specific_document_accordion( $documents[0][7], 'Drawings' ) );
		echo wp_kses_post( $this->display_specific_document_accordion( $documents[0][8], 'Other Documents' ) );

		if ( get_field( 'sub_products' ) ) {
			echo wp_kses_post( $this->display_child_products_accordion() );
			echo wp_kses_post( $this->display_child_manuals() );
		}

		$accordions = ob_get_contents();
		ob_end_clean();
		return $accordions;
	}


	/**
	 * Retrieves and organizes documents related to the product.
	 *
	 * @return array Nested array of product documents categorized by type.
	 */
	public function get_product_documents() {

		$documents = array();
		$brouchures = array(); // CoeFamilyAndProductLineBrochures
		$spec_documents = array(); // SpecDocs
		$technical_documents = array(); // TechnicalDocumentation
		$manuals = array(); // Manuals
		$white_papers = array(); // WhitePapers
		$case_studies = array(); // CaseStudies
		$warranties = array(); // WarrantyDocument
		$drawings = array(); // Drawings
		$other_documents = array(); // OtherDocuments

		if ( have_rows( 'product_documents' ) ) {
			while ( have_rows( 'product_documents' ) ) {
				the_row();
				$document_type = get_sub_field( 'group' );
				switch ( $document_type ) {
					case 'CoeFamilyAndProductLineBrochures':
						array_push(
							$brouchures,
							array(
								get_sub_field( 'title' ),
								get_sub_field( 'document' ),
							)
						);
						break;
					case 'SpecDocs':
						array_push(
							$spec_documents,
							array(
								get_sub_field( 'title' ),
								get_sub_field( 'document' ),
							)
						);
						break;
					case 'TechnicalDocumentation':
						array_push(
							$technical_documents,
							array(
								get_sub_field( 'title' ),
								get_sub_field( 'document' ),
							)
						);
						break;
					case 'Manuals':
						array_push(
							$manuals,
							array(
								get_sub_field( 'title' ),
								get_sub_field( 'document' ),
							)
						);
						break;
					case 'WhitePapers':
						array_push(
							$white_papers,
							array(
								get_sub_field( 'title' ),
								get_sub_field( 'document' ),
							)
						);
						break;
					case 'CaseStudies':
						array_push(
							$case_studies,
							array(
								get_sub_field( 'title' ),
								get_sub_field( 'document' ),
							)
						);
						break;
					case 'WarrantyDocument':
						array_push(
							$warranties,
							array(
								get_sub_field( 'title' ),
								get_sub_field( 'document' ),
							)
						);
						break;
					case 'Drawings':
						array_push(
							$drawings,
							array(
								get_sub_field( 'title' ),
								get_sub_field( 'document' ),
							)
						);
						break;
					case 'OtherDocuments':
						array_push(
							$other_documents,
							array(
								get_sub_field( 'title' ),
								get_sub_field( 'document' ),
							)
						);
						break;
					default:
						array_push(
							$other_documents,
							array(
								get_sub_field( 'title' ),
								get_sub_field( 'document' ),
							)
						);
						break;
				}
			}
		}

		array_push(
			$documents,
			array(
				$brouchures,
				$spec_documents,
				$technical_documents,
				$manuals,
				$white_papers,
				$case_studies,
				$warranties,
				$drawings,
				$other_documents,
			)
		);

		return $documents;
	}

	/**
	 * Displays a custom field in an accordion format.
	 *
	 * @param string $field Field identifier to fetch content for.
	 * @param string $title Title of the accordion.
	 * @return string HTML content for the accordion.
	 */
	public function display_field_accordion( $field, $title ) {

		ob_start();

		if ( get_field( $field ) ) {
			?>

			<h2 class="product__accordion"><?php echo wp_kses_post( $title ); ?></h2>
			<div class="product__accordion-panel"><?php echo wp_kses_post( get_field( $field ) ); ?></div>

			<?php
		}

		$accordion = ob_get_contents();
		ob_end_clean();
		return $accordion;
	}

	/**
	 * Displays specific product documents grouped by type in an accordion.
	 *
	 * @param array  $documents Array of documents to display.
	 * @param string $title Title for the accordion section.
	 * @return string HTML content for the document accordion.
	 */
	public function display_specific_document_accordion( $documents, $title ) {

		ob_start();

		if ( ! empty( $documents ) ) {
			?>

			<h2 class="product__accordion"><?php echo esc_html( $title ); ?></h2>
			<div class="product__accordion-panel">
				<ul>
					<?php
					foreach ( $documents as $document ) {
						echo '<li><a href="' . esc_url( $document[1] ) . '" target="_blank" rel="noopener nofollow">' . esc_html( $document[0] ) . '</a></li>';
					}
					?>
				</ul>
			</div>

			<?php
		}

		$accordion = ob_get_contents();
		ob_end_clean();
		return $accordion;
	}

	/**
	 * Displays an accordion containing links to other products considered as child products.
	 *
	 * @return string HTML content for the child products accordion.
	 */
	public function display_child_products_accordion() {

		ob_start();

		$child_product_ids = $this->get_child_ids();
		?>

		<h2 class="product__accordion">Additional Models</h2>
		<div class="product__accordion-panel">
			<ul>
				<?php
				foreach ( $child_product_ids as $id ) {
					$args = array(
						'post_type' => 'products',
						'meta_query' => array(
							array(
								'key' => 'product_id',
								'value' => $id,
							),
						),
					);

					$post_query = new WP_Query( $args );

					if ( $post_query->have_posts() ) {
						while ( $post_query->have_posts() ) : $post_query->the_post();
							?>
							<li><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></li>
																<?php
																								endwhile;
					}
				}

																						wp_reset_postdata();
				?>

			</ul>
		</div>

		<?php

		$accordion = ob_get_contents();
		ob_end_clean();
		return $accordion;
	}

	/**
	 * Displays an accordion with links to manuals for all child products.
	 *
	 * @return string HTML content for the child product manuals accordion.
	 */
	public function display_child_manuals() {

		ob_start();

		$child_product_ids = $this->get_child_ids();

		$child_product_manuals = array();

		foreach ( $child_product_ids as $id ) {

			$args = array(
				'post_type' => 'products',
				'meta_query' => array(
					array(
						'key' => 'product_id',
						'value' => $id,
					),
				),
			);

			$post_query = new WP_Query( $args );

			if ( $post_query->have_posts() ) {
				while ( $post_query->have_posts() ) {
					$post_query->the_post();
					if ( have_rows( 'product_documents' ) ) {
						while ( have_rows( 'product_documents' ) ) {
							the_row();
							if ( get_sub_field( 'group' ) == 'Manuals' ) {
								$file = get_sub_field( 'document' );
								$title = get_sub_field( 'title' );
								array_push(
									$child_product_manuals,
									array( $file, $title )
								);
							}
						}
					}
				}
			}

			wp_reset_postdata();
		}

		$manuals = array_unique( $child_product_manuals, SORT_REGULAR );

		if ( ! empty( $manuals ) ) {
			?>
			<h2 class="product__accordion">Product Manuals</h2>
			<div class="product__accordion-panel">
				<ul>
					<?php foreach ( $manuals as $manual ) { ?>
						<li><a target="_blank" rel="noopener nofollow" href="<?php echo esc_url( $manual[0] ); ?>"><?php echo esc_html( $manual[1] ); ?></a></li>
					<?php } ?>
				</ul>
			</div>
		<?php } ?>

		<?php
		$accordion = ob_get_contents();
		ob_end_clean();
		return $accordion;
	}
}
