<?php
/**
 * Font Definition for Lato-Regular
 *
 * This PHP script defines the properties and metrics of the Lato-Regular
 * TrueType font. It includes details such as ascent, descent, character
 * widths, encoding, and other relevant font metrics. The data is structured
 * in arrays for easy access and manipulation, and is intended for use
 * in applications requiring font management or rendering.
 *
 * @package    FontManagement
 * @subpackage Fonts
 * @version    1.0
 * @license    MIT License
 *
 * Properties:
 * - $type: The type of font (e.g., TrueType).
 * - $name: The name of the font (e.g., Lato-Regular).
 * - $desc: An associative array containing font metrics.
 * - $up: Underline position.
 * - $ut: Underline thickness.
 * - $cw: An associative array of character widths, indexed by character.
 * - $enc: Character encoding (e.g., cp1252).
 * - $uv: A mapping of Unicode values.
 * - $file: The filename of the font file.
 * - $originalsize: The original size of the font file in bytes.
 * - $subsetted: A boolean indicating whether the font has been subsetted.
 */

$type = 'TrueType';
$name = 'Lato-Regular';
$desc = array(
	'Ascent' => 805,
	'Descent' => -195,
	'CapHeight' => 717,
	'Flags' => 32,
	'FontBBox' => '[-94 -183 1117 919]',
	'ItalicAngle' => 0,
	'StemV' => 70,
	'MissingWidth' => 532,
);
$up = -70;
$ut = 60;
$cw = array(
	chr( 0 ) => 532,
	chr( 1 ) => 532,
	chr( 2 ) => 532,
	chr( 3 ) => 532,
	chr( 4 ) => 532,
	chr( 5 ) => 532,
	chr( 6 ) => 532,
	chr( 7 ) => 532,
	chr( 8 ) => 532,
	chr( 9 ) => 532,
	chr( 10 ) => 532,
	chr( 11 ) => 532,
	chr( 12 ) => 532,
	chr( 13 ) => 532,
	chr( 14 ) => 532,
	chr( 15 ) => 532,
	chr( 16 ) => 532,
	chr( 17 ) => 532,
	chr( 18 ) => 532,
	chr( 19 ) => 532,
	chr( 20 ) => 532,
	chr( 21 ) => 532,
	chr( 22 ) => 532,
	chr( 23 ) => 532,
	chr( 24 ) => 532,
	chr( 25 ) => 532,
	chr( 26 ) => 532,
	chr( 27 ) => 532,
	chr( 28 ) => 532,
	chr( 29 ) => 532,
	chr( 30 ) => 532,
	chr( 31 ) => 532,
	' ' => 193,
	'!' => 343,
	'"' => 397,
	'#' => 580,
	'$' => 580,
	'%' => 786,
	'&' => 703,
	'\'' => 230,
	'(' => 300,
	')' => 300,
	'*' => 400,
	'+' => 580,
	',' => 212,
	'-' => 347,
	'.' => 212,
	'/' => 373,
	'0' => 580,
	'1' => 580,
	'2' => 580,
	'3' => 580,
	'4' => 580,
	'5' => 580,
	'6' => 580,
	'7' => 580,
	'8' => 580,
	'9' => 580,
	':' => 252,
	';' => 252,
	'<' => 580,
	'=' => 580,
	'>' => 580,
	'?' => 398,
	'@' => 822,
	'A' => 680,
	'B' => 647,
	'C' => 685,
	'D' => 753,
	'E' => 581,
	'F' => 566,
	'G' => 734,
	'H' => 756,
	'I' => 307,
	'J' => 444,
	'K' => 681,
	'L' => 514,
	'M' => 920,
	'N' => 756,
	'O' => 798,
	'P' => 611,
	'Q' => 798,
	'R' => 644,
	'S' => 530,
	'T' => 590,
	'U' => 730,
	'V' => 680,
	'W' => 1019,
	'X' => 643,
	'Y' => 629,
	'Z' => 624,
	'[' => 300,
	'\\' => 375,
	']' => 300,
	'^' => 580,
	'_' => 394,
	'`' => 307,
	'a' => 507,
	'b' => 559,
	'c' => 467,
	'd' => 559,
	'e' => 524,
	'f' => 337,
	'g' => 511,
	'h' => 556,
	'i' => 256,
	'j' => 254,
	'k' => 524,
	'l' => 256,
	'm' => 821,
	'n' => 556,
	'o' => 556,
	'p' => 552,
	'q' => 559,
	'r' => 403,
	's' => 434,
	't' => 373,
	'u' => 556,
	'v' => 512,
	'w' => 766,
	'x' => 504,
	'y' => 512,
	'z' => 462,
	'{' => 300,
	'|' => 300,
	'}' => 300,
	'~' => 580,
	chr( 127 ) => 532,
	chr( 128 ) => 580,
	chr( 129 ) => 532,
	chr( 130 ) => 212,
	chr( 131 ) => 580,
	chr( 132 ) => 364,
	chr( 133 ) => 727,
	chr( 134 ) => 580,
	chr( 135 ) => 580,
	chr( 136 ) => 307,
	chr( 137 ) => 1153,
	chr( 138 ) => 530,
	chr( 139 ) => 316,
	chr( 140 ) => 1096,
	chr( 141 ) => 532,
	chr( 142 ) => 624,
	chr( 143 ) => 532,
	chr( 144 ) => 532,
	chr( 145 ) => 212,
	chr( 146 ) => 212,
	chr( 147 ) => 364,
	chr( 148 ) => 364,
	chr( 149 ) => 580,
	chr( 150 ) => 556,
	chr( 151 ) => 821,
	chr( 152 ) => 307,
	chr( 153 ) => 720,
	chr( 154 ) => 434,
	chr( 155 ) => 316,
	chr( 156 ) => 867,
	chr( 157 ) => 532,
	chr( 158 ) => 462,
	chr( 159 ) => 629,
	chr( 160 ) => 193,
	chr( 161 ) => 343,
	chr( 162 ) => 580,
	chr( 163 ) => 580,
	chr( 164 ) => 580,
	chr( 165 ) => 580,
	chr( 166 ) => 300,
	chr( 167 ) => 503,
	chr( 168 ) => 307,
	chr( 169 ) => 798,
	chr( 170 ) => 342,
	chr( 171 ) => 463,
	chr( 172 ) => 580,
	chr( 173 ) => 347,
	chr( 174 ) => 798,
	chr( 175 ) => 307,
	chr( 176 ) => 397,
	chr( 177 ) => 580,
	chr( 178 ) => 332,
	chr( 179 ) => 332,
	chr( 180 ) => 307,
	chr( 181 ) => 556,
	chr( 182 ) => 669,
	chr( 183 ) => 273,
	chr( 184 ) => 307,
	chr( 185 ) => 332,
	chr( 186 ) => 381,
	chr( 187 ) => 463,
	chr( 188 ) => 712,
	chr( 189 ) => 712,
	chr( 190 ) => 713,
	chr( 191 ) => 398,
	chr( 192 ) => 680,
	chr( 193 ) => 680,
	chr( 194 ) => 680,
	chr( 195 ) => 680,
	chr( 196 ) => 680,
	chr( 197 ) => 680,
	chr( 198 ) => 929,
	chr( 199 ) => 685,
	chr( 200 ) => 581,
	chr( 201 ) => 581,
	chr( 202 ) => 581,
	chr( 203 ) => 581,
	chr( 204 ) => 307,
	chr( 205 ) => 307,
	chr( 206 ) => 307,
	chr( 207 ) => 307,
	chr( 208 ) => 789,
	chr( 209 ) => 756,
	chr( 210 ) => 798,
	chr( 211 ) => 798,
	chr( 212 ) => 798,
	chr( 213 ) => 798,
	chr( 214 ) => 798,
	chr( 215 ) => 580,
	chr( 216 ) => 798,
	chr( 217 ) => 730,
	chr( 218 ) => 730,
	chr( 219 ) => 730,
	chr( 220 ) => 730,
	chr( 221 ) => 629,
	chr( 222 ) => 611,
	chr( 223 ) => 609,
	chr( 224 ) => 507,
	chr( 225 ) => 507,
	chr( 226 ) => 507,
	chr( 227 ) => 507,
	chr( 228 ) => 507,
	chr( 229 ) => 507,
	chr( 230 ) => 816,
	chr( 231 ) => 467,
	chr( 232 ) => 524,
	chr( 233 ) => 524,
	chr( 234 ) => 524,
	chr( 235 ) => 524,
	chr( 236 ) => 256,
	chr( 237 ) => 256,
	chr( 238 ) => 256,
	chr( 239 ) => 256,
	chr( 240 ) => 553,
	chr( 241 ) => 556,
	chr( 242 ) => 556,
	chr( 243 ) => 556,
	chr( 244 ) => 556,
	chr( 245 ) => 556,
	chr( 246 ) => 556,
	chr( 247 ) => 580,
	chr( 248 ) => 556,
	chr( 249 ) => 556,
	chr( 250 ) => 556,
	chr( 251 ) => 556,
	chr( 252 ) => 556,
	chr( 253 ) => 512,
	chr( 254 ) => 552,
	chr( 255 ) => 512,
);
$enc = 'cp1252';
$uv = array(
	0 => array( 0, 128 ),
	128 => 8364,
	130 => 8218,
	131 => 402,
	132 => 8222,
	133 => 8230,
	134 => array( 8224, 2 ),
	136 => 710,
	137 => 8240,
	138 => 352,
	139 => 8249,
	140 => 338,
	142 => 381,
	145 => array( 8216, 2 ),
	147 => array( 8220, 2 ),
	149 => 8226,
	150 => array( 8211, 2 ),
	152 => 732,
	153 => 8482,
	154 => 353,
	155 => 8250,
	156 => 339,
	158 => 382,
	159 => 376,
	160 => array( 160, 96 ),
);
$file = 'Lato-Regular.z';
$originalsize = 59772;
$subsetted = true;
