<?php

// GENERATED CODE -- DO NOT EDIT!
// Original file comments:
// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
namespace DeliciousBrains\WP_Offload_Media\Gcp\Google\LongRunning;

/**
 * Manages long-running operations with an API service.
 *
 * When an API method normally takes long time to complete, it can be designed
 * to return [Operation][google.longrunning.Operation] to the client, and the client can use this
 * interface to receive the real response asynchronously by polling the
 * operation resource, or pass the operation resource to another API (such as
 * Google Cloud Pub/Sub API) to receive the response.  Any API service that
 * returns long-running operations should implement the `Operations` interface
 * so developers can have a consistent client experience.
 */
class OperationsGrpcClient extends \DeliciousBrains\WP_Offload_Media\Gcp\Grpc\BaseStub
{
    /**
     * @param string $hostname hostname
     * @param array $opts channel options
     * @param \Grpc\Channel $channel (optional) re-use channel object
     */
    public function __construct($hostname, $opts, $channel = null)
    {
        parent::__construct($hostname, $opts, $channel);
    }
    /**
     * Lists operations that match the specified filter in the request. If the
     * server doesn't support this method, it returns `UNIMPLEMENTED`.
     *
     * NOTE: the `name` binding allows API services to override the binding
     * to use different resource name schemes, such as `users/&#42;/operations`. To
     * override the binding, API services can add a binding such as
     * `"/v1/{name=users/*}/operations"` to their service configuration.
     * For backwards compatibility, the default name includes the operations
     * collection id, however overriding users must ensure the name binding
     * is the parent resource, without the operations collection id.
     * @param \Google\LongRunning\ListOperationsRequest $argument input argument
     * @param array $metadata metadata
     * @param array $options call options
     * @return \Grpc\UnaryCall
     */
    public function ListOperations(\DeliciousBrains\WP_Offload_Media\Gcp\Google\LongRunning\ListOperationsRequest $argument, $metadata = [], $options = [])
    {
        return $this->_simpleRequest('/google.longrunning.Operations/ListOperations', $argument, ['DeliciousBrains\\WP_Offload_Media\\Gcp\\Google\\LongRunning\\ListOperationsResponse', 'decode'], $metadata, $options);
    }
    /**
     * Gets the latest state of a long-running operation.  Clients can use this
     * method to poll the operation result at intervals as recommended by the API
     * service.
     * @param \Google\LongRunning\GetOperationRequest $argument input argument
     * @param array $metadata metadata
     * @param array $options call options
     * @return \Grpc\UnaryCall
     */
    public function GetOperation(\DeliciousBrains\WP_Offload_Media\Gcp\Google\LongRunning\GetOperationRequest $argument, $metadata = [], $options = [])
    {
        return $this->_simpleRequest('/google.longrunning.Operations/GetOperation', $argument, ['DeliciousBrains\\WP_Offload_Media\\Gcp\\Google\\LongRunning\\Operation', 'decode'], $metadata, $options);
    }
    /**
     * Deletes a long-running operation. This method indicates that the client is
     * no longer interested in the operation result. It does not cancel the
     * operation. If the server doesn't support this method, it returns
     * `google.rpc.Code.UNIMPLEMENTED`.
     * @param \Google\LongRunning\DeleteOperationRequest $argument input argument
     * @param array $metadata metadata
     * @param array $options call options
     * @return \Grpc\UnaryCall
     */
    public function DeleteOperation(\DeliciousBrains\WP_Offload_Media\Gcp\Google\LongRunning\DeleteOperationRequest $argument, $metadata = [], $options = [])
    {
        return $this->_simpleRequest('/google.longrunning.Operations/DeleteOperation', $argument, ['DeliciousBrains\\WP_Offload_Media\\Gcp\\Google\\Protobuf\\GPBEmpty', 'decode'], $metadata, $options);
    }
    /**
     * Starts asynchronous cancellation on a long-running operation.  The server
     * makes a best effort to cancel the operation, but success is not
     * guaranteed.  If the server doesn't support this method, it returns
     * `google.rpc.Code.UNIMPLEMENTED`.  Clients can use
     * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
     * other methods to check whether the cancellation succeeded or whether the
     * operation completed despite cancellation. On successful cancellation,
     * the operation is not deleted; instead, it becomes an operation with
     * an [Operation.error][google.longrunning.Operation.error] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
     * corresponding to `Code.CANCELLED`.
     * @param \Google\LongRunning\CancelOperationRequest $argument input argument
     * @param array $metadata metadata
     * @param array $options call options
     * @return \Grpc\UnaryCall
     */
    public function CancelOperation(\DeliciousBrains\WP_Offload_Media\Gcp\Google\LongRunning\CancelOperationRequest $argument, $metadata = [], $options = [])
    {
        return $this->_simpleRequest('/google.longrunning.Operations/CancelOperation', $argument, ['DeliciousBrains\\WP_Offload_Media\\Gcp\\Google\\Protobuf\\GPBEmpty', 'decode'], $metadata, $options);
    }
    /**
     * Waits until the specified long-running operation is done or reaches at most
     * a specified timeout, returning the latest state.  If the operation is
     * already done, the latest state is immediately returned.  If the timeout
     * specified is greater than the default HTTP/RPC timeout, the HTTP/RPC
     * timeout is used.  If the server does not support this method, it returns
     * `google.rpc.Code.UNIMPLEMENTED`.
     * Note that this method is on a best-effort basis.  It may return the latest
     * state before the specified timeout (including immediately), meaning even an
     * immediate response is no guarantee that the operation is done.
     * @param \Google\LongRunning\WaitOperationRequest $argument input argument
     * @param array $metadata metadata
     * @param array $options call options
     * @return \Grpc\UnaryCall
     */
    public function WaitOperation(\DeliciousBrains\WP_Offload_Media\Gcp\Google\LongRunning\WaitOperationRequest $argument, $metadata = [], $options = [])
    {
        return $this->_simpleRequest('/google.longrunning.Operations/WaitOperation', $argument, ['DeliciousBrains\\WP_Offload_Media\\Gcp\\Google\\LongRunning\\Operation', 'decode'], $metadata, $options);
    }
}
