<?php

namespace DeliciousBrains\WP_Offload_Media\Aws3;

// This file was auto-generated from sdk-root/src/data/chime-sdk-media-pipelines/2021-07-15/api-2.json
return ['version' => '2.0', 'metadata' => ['apiVersion' => '2021-07-15', 'endpointPrefix' => 'media-pipelines-chime', 'protocol' => 'rest-json', 'serviceFullName' => 'Amazon Chime SDK Media Pipelines', 'serviceId' => 'Chime SDK Media Pipelines', 'signatureVersion' => 'v4', 'signingName' => 'chime', 'uid' => 'chime-sdk-media-pipelines-2021-07-15'], 'operations' => ['CreateMediaCapturePipeline' => ['name' => 'CreateMediaCapturePipeline', 'http' => ['method' => 'POST', 'requestUri' => '/sdk-media-capture-pipelines', 'responseCode' => 201], 'input' => ['shape' => 'CreateMediaCapturePipelineRequest'], 'output' => ['shape' => 'CreateMediaCapturePipelineResponse'], 'errors' => [['shape' => 'BadRequestException'], ['shape' => 'ForbiddenException'], ['shape' => 'UnauthorizedClientException'], ['shape' => 'ThrottledClientException'], ['shape' => 'ResourceLimitExceededException'], ['shape' => 'ServiceUnavailableException'], ['shape' => 'ServiceFailureException']]], 'CreateMediaConcatenationPipeline' => ['name' => 'CreateMediaConcatenationPipeline', 'http' => ['method' => 'POST', 'requestUri' => '/sdk-media-concatenation-pipelines', 'responseCode' => 201], 'input' => ['shape' => 'CreateMediaConcatenationPipelineRequest'], 'output' => ['shape' => 'CreateMediaConcatenationPipelineResponse'], 'errors' => [['shape' => 'BadRequestException'], ['shape' => 'ForbiddenException'], ['shape' => 'UnauthorizedClientException'], ['shape' => 'ThrottledClientException'], ['shape' => 'ResourceLimitExceededException'], ['shape' => 'ServiceUnavailableException'], ['shape' => 'ServiceFailureException']]], 'CreateMediaLiveConnectorPipeline' => ['name' => 'CreateMediaLiveConnectorPipeline', 'http' => ['method' => 'POST', 'requestUri' => '/sdk-media-live-connector-pipelines', 'responseCode' => 201], 'input' => ['shape' => 'CreateMediaLiveConnectorPipelineRequest'], 'output' => ['shape' => 'CreateMediaLiveConnectorPipelineResponse'], 'errors' => [['shape' => 'BadRequestException'], ['shape' => 'ForbiddenException'], ['shape' => 'UnauthorizedClientException'], ['shape' => 'ThrottledClientException'], ['shape' => 'ResourceLimitExceededException'], ['shape' => 'ServiceUnavailableException'], ['shape' => 'ServiceFailureException']]], 'DeleteMediaCapturePipeline' => ['name' => 'DeleteMediaCapturePipeline', 'http' => ['method' => 'DELETE', 'requestUri' => '/sdk-media-capture-pipelines/{mediaPipelineId}', 'responseCode' => 204], 'input' => ['shape' => 'DeleteMediaCapturePipelineRequest'], 'errors' => [['shape' => 'BadRequestException'], ['shape' => 'ForbiddenException'], ['shape' => 'ThrottledClientException'], ['shape' => 'NotFoundException'], ['shape' => 'UnauthorizedClientException'], ['shape' => 'ServiceUnavailableException'], ['shape' => 'ServiceFailureException']]], 'DeleteMediaPipeline' => ['name' => 'DeleteMediaPipeline', 'http' => ['method' => 'DELETE', 'requestUri' => '/sdk-media-pipelines/{mediaPipelineId}', 'responseCode' => 204], 'input' => ['shape' => 'DeleteMediaPipelineRequest'], 'errors' => [['shape' => 'BadRequestException'], ['shape' => 'ForbiddenException'], ['shape' => 'ThrottledClientException'], ['shape' => 'NotFoundException'], ['shape' => 'UnauthorizedClientException'], ['shape' => 'ServiceUnavailableException'], ['shape' => 'ServiceFailureException']]], 'GetMediaCapturePipeline' => ['name' => 'GetMediaCapturePipeline', 'http' => ['method' => 'GET', 'requestUri' => '/sdk-media-capture-pipelines/{mediaPipelineId}', 'responseCode' => 200], 'input' => ['shape' => 'GetMediaCapturePipelineRequest'], 'output' => ['shape' => 'GetMediaCapturePipelineResponse'], 'errors' => [['shape' => 'BadRequestException'], ['shape' => 'ForbiddenException'], ['shape' => 'UnauthorizedClientException'], ['shape' => 'ThrottledClientException'], ['shape' => 'NotFoundException'], ['shape' => 'ServiceUnavailableException'], ['shape' => 'ServiceFailureException']]], 'GetMediaPipeline' => ['name' => 'GetMediaPipeline', 'http' => ['method' => 'GET', 'requestUri' => '/sdk-media-pipelines/{mediaPipelineId}', 'responseCode' => 200], 'input' => ['shape' => 'GetMediaPipelineRequest'], 'output' => ['shape' => 'GetMediaPipelineResponse'], 'errors' => [['shape' => 'BadRequestException'], ['shape' => 'ForbiddenException'], ['shape' => 'UnauthorizedClientException'], ['shape' => 'ThrottledClientException'], ['shape' => 'NotFoundException'], ['shape' => 'ServiceUnavailableException'], ['shape' => 'ServiceFailureException']]], 'ListMediaCapturePipelines' => ['name' => 'ListMediaCapturePipelines', 'http' => ['method' => 'GET', 'requestUri' => '/sdk-media-capture-pipelines', 'responseCode' => 200], 'input' => ['shape' => 'ListMediaCapturePipelinesRequest'], 'output' => ['shape' => 'ListMediaCapturePipelinesResponse'], 'errors' => [['shape' => 'BadRequestException'], ['shape' => 'ForbiddenException'], ['shape' => 'UnauthorizedClientException'], ['shape' => 'ThrottledClientException'], ['shape' => 'ResourceLimitExceededException'], ['shape' => 'ServiceUnavailableException'], ['shape' => 'ServiceFailureException']]], 'ListMediaPipelines' => ['name' => 'ListMediaPipelines', 'http' => ['method' => 'GET', 'requestUri' => '/sdk-media-pipelines', 'responseCode' => 200], 'input' => ['shape' => 'ListMediaPipelinesRequest'], 'output' => ['shape' => 'ListMediaPipelinesResponse'], 'errors' => [['shape' => 'BadRequestException'], ['shape' => 'ForbiddenException'], ['shape' => 'UnauthorizedClientException'], ['shape' => 'ThrottledClientException'], ['shape' => 'ResourceLimitExceededException'], ['shape' => 'ServiceUnavailableException'], ['shape' => 'ServiceFailureException']]], 'ListTagsForResource' => ['name' => 'ListTagsForResource', 'http' => ['method' => 'GET', 'requestUri' => '/tags', 'responseCode' => 200], 'input' => ['shape' => 'ListTagsForResourceRequest'], 'output' => ['shape' => 'ListTagsForResourceResponse'], 'errors' => [['shape' => 'NotFoundException'], ['shape' => 'BadRequestException'], ['shape' => 'ForbiddenException'], ['shape' => 'UnauthorizedClientException'], ['shape' => 'ThrottledClientException'], ['shape' => 'ServiceUnavailableException'], ['shape' => 'ServiceFailureException']]], 'TagResource' => ['name' => 'TagResource', 'http' => ['method' => 'POST', 'requestUri' => '/tags?operation=tag-resource', 'responseCode' => 204], 'input' => ['shape' => 'TagResourceRequest'], 'output' => ['shape' => 'TagResourceResponse'], 'errors' => [['shape' => 'NotFoundException'], ['shape' => 'BadRequestException'], ['shape' => 'ForbiddenException'], ['shape' => 'UnauthorizedClientException'], ['shape' => 'ThrottledClientException'], ['shape' => 'ServiceUnavailableException'], ['shape' => 'ServiceFailureException']]], 'UntagResource' => ['name' => 'UntagResource', 'http' => ['method' => 'POST', 'requestUri' => '/tags?operation=untag-resource', 'responseCode' => 204], 'input' => ['shape' => 'UntagResourceRequest'], 'output' => ['shape' => 'UntagResourceResponse'], 'errors' => [['shape' => 'NotFoundException'], ['shape' => 'BadRequestException'], ['shape' => 'ForbiddenException'], ['shape' => 'UnauthorizedClientException'], ['shape' => 'ThrottledClientException'], ['shape' => 'ServiceUnavailableException'], ['shape' => 'ServiceFailureException']]]], 'shapes' => ['AmazonResourceName' => ['type' => 'string', 'max' => 1011, 'min' => 1, 'pattern' => '^arn[\\/\\:\\-\\_\\.a-zA-Z0-9]+$'], 'Arn' => ['type' => 'string', 'max' => 1024, 'min' => 1, 'pattern' => '^arn[\\/\\:\\-\\_\\.a-zA-Z0-9]+$', 'sensitive' => \true], 'ArtifactsConcatenationConfiguration' => ['type' => 'structure', 'required' => ['Audio', 'Video', 'Content', 'DataChannel', 'TranscriptionMessages', 'MeetingEvents', 'CompositedVideo'], 'members' => ['Audio' => ['shape' => 'AudioConcatenationConfiguration'], 'Video' => ['shape' => 'VideoConcatenationConfiguration'], 'Content' => ['shape' => 'ContentConcatenationConfiguration'], 'DataChannel' => ['shape' => 'DataChannelConcatenationConfiguration'], 'TranscriptionMessages' => ['shape' => 'TranscriptionMessagesConcatenationConfiguration'], 'MeetingEvents' => ['shape' => 'MeetingEventsConcatenationConfiguration'], 'CompositedVideo' => ['shape' => 'CompositedVideoConcatenationConfiguration']]], 'ArtifactsConcatenationState' => ['type' => 'string', 'enum' => ['Enabled', 'Disabled']], 'ArtifactsConfiguration' => ['type' => 'structure', 'required' => ['Audio', 'Video', 'Content'], 'members' => ['Audio' => ['shape' => 'AudioArtifactsConfiguration'], 'Video' => ['shape' => 'VideoArtifactsConfiguration'], 'Content' => ['shape' => 'ContentArtifactsConfiguration'], 'CompositedVideo' => ['shape' => 'CompositedVideoArtifactsConfiguration']]], 'ArtifactsState' => ['type' => 'string', 'enum' => ['Enabled', 'Disabled']], 'AttendeeIdList' => ['type' => 'list', 'member' => ['shape' => 'GuidString'], 'min' => 1], 'AudioArtifactsConcatenationState' => ['type' => 'string', 'enum' => ['Enabled']], 'AudioArtifactsConfiguration' => ['type' => 'structure', 'required' => ['MuxType'], 'members' => ['MuxType' => ['shape' => 'AudioMuxType']]], 'AudioChannelsOption' => ['type' => 'string', 'enum' => ['Stereo', 'Mono']], 'AudioConcatenationConfiguration' => ['type' => 'structure', 'required' => ['State'], 'members' => ['State' => ['shape' => 'AudioArtifactsConcatenationState']]], 'AudioMuxType' => ['type' => 'string', 'enum' => ['AudioOnly', 'AudioWithActiveSpeakerVideo', 'AudioWithCompositedVideo']], 'AudioSampleRateOption' => ['type' => 'string', 'pattern' => '44100|48000'], 'BadRequestException' => ['type' => 'structure', 'members' => ['Code' => ['shape' => 'ErrorCode'], 'Message' => ['shape' => 'String'], 'RequestId' => ['shape' => 'String']], 'error' => ['httpStatusCode' => 400], 'exception' => \true], 'ChimeSdkMeetingConcatenationConfiguration' => ['type' => 'structure', 'required' => ['ArtifactsConfiguration'], 'members' => ['ArtifactsConfiguration' => ['shape' => 'ArtifactsConcatenationConfiguration']]], 'ChimeSdkMeetingConfiguration' => ['type' => 'structure', 'members' => ['SourceConfiguration' => ['shape' => 'SourceConfiguration'], 'ArtifactsConfiguration' => ['shape' => 'ArtifactsConfiguration']]], 'ChimeSdkMeetingLiveConnectorConfiguration' => ['type' => 'structure', 'required' => ['Arn', 'MuxType'], 'members' => ['Arn' => ['shape' => 'Arn'], 'MuxType' => ['shape' => 'LiveConnectorMuxType'], 'CompositedVideo' => ['shape' => 'CompositedVideoArtifactsConfiguration'], 'SourceConfiguration' => ['shape' => 'SourceConfiguration']]], 'ClientRequestToken' => ['type' => 'string', 'max' => 64, 'min' => 2, 'pattern' => '[-_a-zA-Z0-9]*', 'sensitive' => \true], 'CompositedVideoArtifactsConfiguration' => ['type' => 'structure', 'required' => ['GridViewConfiguration'], 'members' => ['Layout' => ['shape' => 'LayoutOption'], 'Resolution' => ['shape' => 'ResolutionOption'], 'GridViewConfiguration' => ['shape' => 'GridViewConfiguration']]], 'CompositedVideoConcatenationConfiguration' => ['type' => 'structure', 'required' => ['State'], 'members' => ['State' => ['shape' => 'ArtifactsConcatenationState']]], 'ConcatenationSink' => ['type' => 'structure', 'required' => ['Type', 'S3BucketSinkConfiguration'], 'members' => ['Type' => ['shape' => 'ConcatenationSinkType'], 'S3BucketSinkConfiguration' => ['shape' => 'S3BucketSinkConfiguration']]], 'ConcatenationSinkList' => ['type' => 'list', 'member' => ['shape' => 'ConcatenationSink'], 'max' => 1, 'min' => 1], 'ConcatenationSinkType' => ['type' => 'string', 'enum' => ['S3Bucket']], 'ConcatenationSource' => ['type' => 'structure', 'required' => ['Type', 'MediaCapturePipelineSourceConfiguration'], 'members' => ['Type' => ['shape' => 'ConcatenationSourceType'], 'MediaCapturePipelineSourceConfiguration' => ['shape' => 'MediaCapturePipelineSourceConfiguration']]], 'ConcatenationSourceList' => ['type' => 'list', 'member' => ['shape' => 'ConcatenationSource'], 'max' => 1, 'min' => 1], 'ConcatenationSourceType' => ['type' => 'string', 'enum' => ['MediaCapturePipeline']], 'ContentArtifactsConfiguration' => ['type' => 'structure', 'required' => ['State'], 'members' => ['State' => ['shape' => 'ArtifactsState'], 'MuxType' => ['shape' => 'ContentMuxType']]], 'ContentConcatenationConfiguration' => ['type' => 'structure', 'required' => ['State'], 'members' => ['State' => ['shape' => 'ArtifactsConcatenationState']]], 'ContentMuxType' => ['type' => 'string', 'enum' => ['ContentOnly']], 'ContentShareLayoutOption' => ['type' => 'string', 'enum' => ['PresenterOnly', 'Horizontal', 'Vertical']], 'CreateMediaCapturePipelineRequest' => ['type' => 'structure', 'required' => ['SourceType', 'SourceArn', 'SinkType', 'SinkArn'], 'members' => ['SourceType' => ['shape' => 'MediaPipelineSourceType'], 'SourceArn' => ['shape' => 'Arn'], 'SinkType' => ['shape' => 'MediaPipelineSinkType'], 'SinkArn' => ['shape' => 'Arn'], 'ClientRequestToken' => ['shape' => 'ClientRequestToken', 'idempotencyToken' => \true], 'ChimeSdkMeetingConfiguration' => ['shape' => 'ChimeSdkMeetingConfiguration'], 'Tags' => ['shape' => 'TagList']]], 'CreateMediaCapturePipelineResponse' => ['type' => 'structure', 'members' => ['MediaCapturePipeline' => ['shape' => 'MediaCapturePipeline']]], 'CreateMediaConcatenationPipelineRequest' => ['type' => 'structure', 'required' => ['Sources', 'Sinks'], 'members' => ['Sources' => ['shape' => 'ConcatenationSourceList'], 'Sinks' => ['shape' => 'ConcatenationSinkList'], 'ClientRequestToken' => ['shape' => 'ClientRequestToken', 'idempotencyToken' => \true], 'Tags' => ['shape' => 'TagList']]], 'CreateMediaConcatenationPipelineResponse' => ['type' => 'structure', 'members' => ['MediaConcatenationPipeline' => ['shape' => 'MediaConcatenationPipeline']]], 'CreateMediaLiveConnectorPipelineRequest' => ['type' => 'structure', 'required' => ['Sources', 'Sinks'], 'members' => ['Sources' => ['shape' => 'LiveConnectorSourceList'], 'Sinks' => ['shape' => 'LiveConnectorSinkList'], 'ClientRequestToken' => ['shape' => 'ClientRequestToken', 'idempotencyToken' => \true], 'Tags' => ['shape' => 'TagList']]], 'CreateMediaLiveConnectorPipelineResponse' => ['type' => 'structure', 'members' => ['MediaLiveConnectorPipeline' => ['shape' => 'MediaLiveConnectorPipeline']]], 'DataChannelConcatenationConfiguration' => ['type' => 'structure', 'required' => ['State'], 'members' => ['State' => ['shape' => 'ArtifactsConcatenationState']]], 'DeleteMediaCapturePipelineRequest' => ['type' => 'structure', 'required' => ['MediaPipelineId'], 'members' => ['MediaPipelineId' => ['shape' => 'GuidString', 'location' => 'uri', 'locationName' => 'mediaPipelineId']]], 'DeleteMediaPipelineRequest' => ['type' => 'structure', 'required' => ['MediaPipelineId'], 'members' => ['MediaPipelineId' => ['shape' => 'GuidString', 'location' => 'uri', 'locationName' => 'mediaPipelineId']]], 'ErrorCode' => ['type' => 'string', 'enum' => ['BadRequest', 'Forbidden', 'NotFound', 'ResourceLimitExceeded', 'ServiceFailure', 'ServiceUnavailable', 'Throttling']], 'ExternalUserIdList' => ['type' => 'list', 'member' => ['shape' => 'ExternalUserIdType'], 'min' => 1], 'ExternalUserIdType' => ['type' => 'string', 'max' => 64, 'min' => 2, 'sensitive' => \true], 'ForbiddenException' => ['type' => 'structure', 'members' => ['Code' => ['shape' => 'ErrorCode'], 'Message' => ['shape' => 'String'], 'RequestId' => ['shape' => 'String']], 'error' => ['httpStatusCode' => 403], 'exception' => \true], 'GetMediaCapturePipelineRequest' => ['type' => 'structure', 'required' => ['MediaPipelineId'], 'members' => ['MediaPipelineId' => ['shape' => 'GuidString', 'location' => 'uri', 'locationName' => 'mediaPipelineId']]], 'GetMediaCapturePipelineResponse' => ['type' => 'structure', 'members' => ['MediaCapturePipeline' => ['shape' => 'MediaCapturePipeline']]], 'GetMediaPipelineRequest' => ['type' => 'structure', 'required' => ['MediaPipelineId'], 'members' => ['MediaPipelineId' => ['shape' => 'GuidString', 'location' => 'uri', 'locationName' => 'mediaPipelineId']]], 'GetMediaPipelineResponse' => ['type' => 'structure', 'members' => ['MediaPipeline' => ['shape' => 'MediaPipeline']]], 'GridViewConfiguration' => ['type' => 'structure', 'required' => ['ContentShareLayout'], 'members' => ['ContentShareLayout' => ['shape' => 'ContentShareLayoutOption'], 'PresenterOnlyConfiguration' => ['shape' => 'PresenterOnlyConfiguration']]], 'GuidString' => ['type' => 'string', 'max' => 36, 'min' => 36, 'pattern' => '[a-fA-F0-9]{8}(?:-[a-fA-F0-9]{4}){3}-[a-fA-F0-9]{12}'], 'Iso8601Timestamp' => ['type' => 'timestamp', 'timestampFormat' => 'iso8601'], 'LayoutOption' => ['type' => 'string', 'enum' => ['GridView']], 'ListMediaCapturePipelinesRequest' => ['type' => 'structure', 'members' => ['NextToken' => ['shape' => 'String', 'location' => 'querystring', 'locationName' => 'next-token'], 'MaxResults' => ['shape' => 'ResultMax', 'location' => 'querystring', 'locationName' => 'max-results']]], 'ListMediaCapturePipelinesResponse' => ['type' => 'structure', 'members' => ['MediaCapturePipelines' => ['shape' => 'MediaCapturePipelineSummaryList'], 'NextToken' => ['shape' => 'String']]], 'ListMediaPipelinesRequest' => ['type' => 'structure', 'members' => ['NextToken' => ['shape' => 'String', 'location' => 'querystring', 'locationName' => 'next-token'], 'MaxResults' => ['shape' => 'ResultMax', 'location' => 'querystring', 'locationName' => 'max-results']]], 'ListMediaPipelinesResponse' => ['type' => 'structure', 'members' => ['MediaPipelines' => ['shape' => 'MediaPipelineList'], 'NextToken' => ['shape' => 'String']]], 'ListTagsForResourceRequest' => ['type' => 'structure', 'required' => ['ResourceARN'], 'members' => ['ResourceARN' => ['shape' => 'AmazonResourceName', 'location' => 'querystring', 'locationName' => 'arn']]], 'ListTagsForResourceResponse' => ['type' => 'structure', 'members' => ['Tags' => ['shape' => 'TagList']]], 'LiveConnectorMuxType' => ['type' => 'string', 'enum' => ['AudioWithCompositedVideo', 'AudioWithActiveSpeakerVideo']], 'LiveConnectorRTMPConfiguration' => ['type' => 'structure', 'required' => ['Url'], 'members' => ['Url' => ['shape' => 'SensitiveString'], 'AudioChannels' => ['shape' => 'AudioChannelsOption'], 'AudioSampleRate' => ['shape' => 'AudioSampleRateOption']]], 'LiveConnectorSinkConfiguration' => ['type' => 'structure', 'required' => ['SinkType', 'RTMPConfiguration'], 'members' => ['SinkType' => ['shape' => 'LiveConnectorSinkType'], 'RTMPConfiguration' => ['shape' => 'LiveConnectorRTMPConfiguration']]], 'LiveConnectorSinkList' => ['type' => 'list', 'member' => ['shape' => 'LiveConnectorSinkConfiguration'], 'max' => 1, 'min' => 1], 'LiveConnectorSinkType' => ['type' => 'string', 'enum' => ['RTMP']], 'LiveConnectorSourceConfiguration' => ['type' => 'structure', 'required' => ['SourceType', 'ChimeSdkMeetingLiveConnectorConfiguration'], 'members' => ['SourceType' => ['shape' => 'LiveConnectorSourceType'], 'ChimeSdkMeetingLiveConnectorConfiguration' => ['shape' => 'ChimeSdkMeetingLiveConnectorConfiguration']]], 'LiveConnectorSourceList' => ['type' => 'list', 'member' => ['shape' => 'LiveConnectorSourceConfiguration'], 'max' => 1, 'min' => 1], 'LiveConnectorSourceType' => ['type' => 'string', 'enum' => ['ChimeSdkMeeting']], 'MediaCapturePipeline' => ['type' => 'structure', 'members' => ['MediaPipelineId' => ['shape' => 'GuidString'], 'MediaPipelineArn' => ['shape' => 'AmazonResourceName'], 'SourceType' => ['shape' => 'MediaPipelineSourceType'], 'SourceArn' => ['shape' => 'Arn'], 'Status' => ['shape' => 'MediaPipelineStatus'], 'SinkType' => ['shape' => 'MediaPipelineSinkType'], 'SinkArn' => ['shape' => 'Arn'], 'CreatedTimestamp' => ['shape' => 'Iso8601Timestamp'], 'UpdatedTimestamp' => ['shape' => 'Iso8601Timestamp'], 'ChimeSdkMeetingConfiguration' => ['shape' => 'ChimeSdkMeetingConfiguration']]], 'MediaCapturePipelineSourceConfiguration' => ['type' => 'structure', 'required' => ['MediaPipelineArn', 'ChimeSdkMeetingConfiguration'], 'members' => ['MediaPipelineArn' => ['shape' => 'Arn'], 'ChimeSdkMeetingConfiguration' => ['shape' => 'ChimeSdkMeetingConcatenationConfiguration']]], 'MediaCapturePipelineSummary' => ['type' => 'structure', 'members' => ['MediaPipelineId' => ['shape' => 'GuidString'], 'MediaPipelineArn' => ['shape' => 'AmazonResourceName']]], 'MediaCapturePipelineSummaryList' => ['type' => 'list', 'member' => ['shape' => 'MediaCapturePipelineSummary']], 'MediaConcatenationPipeline' => ['type' => 'structure', 'members' => ['MediaPipelineId' => ['shape' => 'GuidString'], 'MediaPipelineArn' => ['shape' => 'AmazonResourceName'], 'Sources' => ['shape' => 'ConcatenationSourceList'], 'Sinks' => ['shape' => 'ConcatenationSinkList'], 'Status' => ['shape' => 'MediaPipelineStatus'], 'CreatedTimestamp' => ['shape' => 'Iso8601Timestamp'], 'UpdatedTimestamp' => ['shape' => 'Iso8601Timestamp']]], 'MediaLiveConnectorPipeline' => ['type' => 'structure', 'members' => ['Sources' => ['shape' => 'LiveConnectorSourceList'], 'Sinks' => ['shape' => 'LiveConnectorSinkList'], 'MediaPipelineId' => ['shape' => 'GuidString'], 'MediaPipelineArn' => ['shape' => 'AmazonResourceName'], 'Status' => ['shape' => 'MediaPipelineStatus'], 'CreatedTimestamp' => ['shape' => 'Iso8601Timestamp'], 'UpdatedTimestamp' => ['shape' => 'Iso8601Timestamp']]], 'MediaPipeline' => ['type' => 'structure', 'members' => ['MediaCapturePipeline' => ['shape' => 'MediaCapturePipeline'], 'MediaLiveConnectorPipeline' => ['shape' => 'MediaLiveConnectorPipeline'], 'MediaConcatenationPipeline' => ['shape' => 'MediaConcatenationPipeline']]], 'MediaPipelineList' => ['type' => 'list', 'member' => ['shape' => 'MediaPipelineSummary']], 'MediaPipelineSinkType' => ['type' => 'string', 'enum' => ['S3Bucket']], 'MediaPipelineSourceType' => ['type' => 'string', 'enum' => ['ChimeSdkMeeting']], 'MediaPipelineStatus' => ['type' => 'string', 'enum' => ['Initializing', 'InProgress', 'Failed', 'Stopping', 'Stopped']], 'MediaPipelineSummary' => ['type' => 'structure', 'members' => ['MediaPipelineId' => ['shape' => 'GuidString'], 'MediaPipelineArn' => ['shape' => 'AmazonResourceName']]], 'MeetingEventsConcatenationConfiguration' => ['type' => 'structure', 'required' => ['State'], 'members' => ['State' => ['shape' => 'ArtifactsConcatenationState']]], 'NotFoundException' => ['type' => 'structure', 'members' => ['Code' => ['shape' => 'ErrorCode'], 'Message' => ['shape' => 'String'], 'RequestId' => ['shape' => 'String']], 'error' => ['httpStatusCode' => 404], 'exception' => \true], 'PresenterOnlyConfiguration' => ['type' => 'structure', 'members' => ['PresenterPosition' => ['shape' => 'PresenterPosition']]], 'PresenterPosition' => ['type' => 'string', 'enum' => ['TopLeft', 'TopRight', 'BottomLeft', 'BottomRight']], 'ResolutionOption' => ['type' => 'string', 'enum' => ['HD', 'FHD']], 'ResourceLimitExceededException' => ['type' => 'structure', 'members' => ['Code' => ['shape' => 'ErrorCode'], 'Message' => ['shape' => 'String'], 'RequestId' => ['shape' => 'String']], 'error' => ['httpStatusCode' => 400], 'exception' => \true], 'ResultMax' => ['type' => 'integer', 'max' => 100, 'min' => 1], 'S3BucketSinkConfiguration' => ['type' => 'structure', 'required' => ['Destination'], 'members' => ['Destination' => ['shape' => 'Arn']]], 'SelectedVideoStreams' => ['type' => 'structure', 'members' => ['AttendeeIds' => ['shape' => 'AttendeeIdList'], 'ExternalUserIds' => ['shape' => 'ExternalUserIdList']]], 'SensitiveString' => ['type' => 'string', 'max' => 1024, 'min' => 1, 'sensitive' => \true], 'ServiceFailureException' => ['type' => 'structure', 'members' => ['Code' => ['shape' => 'ErrorCode'], 'Message' => ['shape' => 'String'], 'RequestId' => ['shape' => 'String']], 'error' => ['httpStatusCode' => 500], 'exception' => \true, 'fault' => \true], 'ServiceUnavailableException' => ['type' => 'structure', 'members' => ['Code' => ['shape' => 'ErrorCode'], 'Message' => ['shape' => 'String'], 'RequestId' => ['shape' => 'String']], 'error' => ['httpStatusCode' => 503], 'exception' => \true, 'fault' => \true], 'SourceConfiguration' => ['type' => 'structure', 'members' => ['SelectedVideoStreams' => ['shape' => 'SelectedVideoStreams']]], 'String' => ['type' => 'string', 'max' => 4096, 'pattern' => '.*'], 'Tag' => ['type' => 'structure', 'required' => ['Key', 'Value'], 'members' => ['Key' => ['shape' => 'TagKey'], 'Value' => ['shape' => 'TagValue']]], 'TagKey' => ['type' => 'string', 'max' => 128, 'min' => 1], 'TagKeyList' => ['type' => 'list', 'member' => ['shape' => 'TagKey'], 'max' => 50, 'min' => 1], 'TagList' => ['type' => 'list', 'member' => ['shape' => 'Tag'], 'max' => 50, 'min' => 1], 'TagResourceRequest' => ['type' => 'structure', 'required' => ['ResourceARN', 'Tags'], 'members' => ['ResourceARN' => ['shape' => 'AmazonResourceName'], 'Tags' => ['shape' => 'TagList']]], 'TagResourceResponse' => ['type' => 'structure', 'members' => []], 'TagValue' => ['type' => 'string', 'max' => 256, 'min' => 0], 'ThrottledClientException' => ['type' => 'structure', 'members' => ['Code' => ['shape' => 'ErrorCode'], 'Message' => ['shape' => 'String'], 'RequestId' => ['shape' => 'String']], 'error' => ['httpStatusCode' => 429], 'exception' => \true], 'TranscriptionMessagesConcatenationConfiguration' => ['type' => 'structure', 'required' => ['State'], 'members' => ['State' => ['shape' => 'ArtifactsConcatenationState']]], 'UnauthorizedClientException' => ['type' => 'structure', 'members' => ['Code' => ['shape' => 'ErrorCode'], 'Message' => ['shape' => 'String'], 'RequestId' => ['shape' => 'String']], 'error' => ['httpStatusCode' => 401], 'exception' => \true], 'UntagResourceRequest' => ['type' => 'structure', 'required' => ['ResourceARN', 'TagKeys'], 'members' => ['ResourceARN' => ['shape' => 'AmazonResourceName'], 'TagKeys' => ['shape' => 'TagKeyList']]], 'UntagResourceResponse' => ['type' => 'structure', 'members' => []], 'VideoArtifactsConfiguration' => ['type' => 'structure', 'required' => ['State'], 'members' => ['State' => ['shape' => 'ArtifactsState'], 'MuxType' => ['shape' => 'VideoMuxType']]], 'VideoConcatenationConfiguration' => ['type' => 'structure', 'required' => ['State'], 'members' => ['State' => ['shape' => 'ArtifactsConcatenationState']]], 'VideoMuxType' => ['type' => 'string', 'enum' => ['VideoOnly']]]];
